/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.service.buffer;

import com.metamatrix.common.application.Application;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.buffer.impl.BufferConfig;
import com.metamatrix.common.buffer.impl.BufferManagerImpl;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.dqp.embedded.EmbeddedTestUtil;
import com.metamatrix.dqp.embedded.services.EmbeddedBufferService;
import com.metamatrix.dqp.embedded.services.EmbeddedConfigurationService;
import java.util.Properties;
import junit.framework.TestCase;

public class TestLocalBufferService
extends TestCase {
    public TestLocalBufferService(String name) {
        super(name);
    }

    public void testMissingRequiredProperties() throws Exception {
        try {
            System.setProperty("mm.io.tmpdir", System.getProperty("java.io.tmpdir") + "/metamatrix/1");
            Application r = new Application();
            EmbeddedConfigurationService cs = new EmbeddedConfigurationService();
            Properties p = EmbeddedTestUtil.getProperties(UnitTestUtil.getTestDataPath() + "/admin/buffertest1.properties");
            p.setProperty("mm.io.tmpdir", System.getProperty("mm.io.tmpdir"));
            cs.initialize(p);
            r.installService("dqp.configuration", (ApplicationService)cs);
            EmbeddedBufferService svc = new EmbeddedBufferService();
            svc.initialize(null);
            r.installService("dqp.buffer", (ApplicationService)svc);
            TestLocalBufferService.assertTrue((boolean)"64".equals(cs.getBufferMemorySize()));
            TestLocalBufferService.assertTrue((cs.getDiskBufferDirectory().isDirectory() && cs.getDiskBufferDirectory().exists() ? 1 : 0) != 0);
            TestLocalBufferService.assertTrue((boolean)cs.useDiskBuffering());
        }
        catch (ApplicationInitializationException applicationInitializationException) {
            // empty catch block
        }
    }

    public void testCheckMemPropertyGotSet() throws Exception {
        EmbeddedBufferService svc = null;
        EmbeddedConfigurationService cs = null;
        Application r = new Application();
        cs = new EmbeddedConfigurationService();
        Properties p = EmbeddedTestUtil.getProperties(UnitTestUtil.getTestDataPath() + "/admin/buffertest2.properties");
        cs.initialize(p);
        r.installService("dqp.configuration", (ApplicationService)cs);
        svc = new EmbeddedBufferService();
        svc.initialize(null);
        r.installService("dqp.buffer", (ApplicationService)svc);
        TestLocalBufferService.assertTrue((boolean)"96".equals(cs.getBufferMemorySize()));
        cs.getDiskBufferDirectory();
        TestLocalBufferService.assertTrue((String)"Not Directory", (boolean)cs.getDiskBufferDirectory().isDirectory());
        TestLocalBufferService.assertTrue((String)"does not exist", (boolean)cs.getDiskBufferDirectory().exists());
        TestLocalBufferService.assertTrue((String)"does not end with one", (boolean)cs.getDiskBufferDirectory().getName().endsWith("1"));
        TestLocalBufferService.assertTrue((boolean)cs.useDiskBuffering());
        BufferManagerImpl mgr = (BufferManagerImpl)svc.getBufferManager();
        BufferConfig config = mgr.getConfig();
        TestLocalBufferService.assertEquals((String)"Did not get expected memory level", (long)96000000L, (long)config.getTotalAvailableMemory());
        TestLocalBufferService.assertTrue((boolean)config.getBufferStorageDirectory().endsWith(cs.getDiskBufferDirectory().getName()));
    }

    public void testCheckMemPropertyGotSet2() throws Exception {
        System.setProperty("mm.io.tmpdir", System.getProperty("java.io.tmpdir") + "/metamatrix/1");
        EmbeddedBufferService svc = null;
        Application r = new Application();
        EmbeddedConfigurationService cs = new EmbeddedConfigurationService();
        Properties p = EmbeddedTestUtil.getProperties(UnitTestUtil.getTestDataPath() + "/admin/buffertest3.properties");
        p.setProperty("mm.io.tmpdir", System.getProperty("mm.io.tmpdir"));
        cs.initialize(p);
        r.installService("dqp.configuration", (ApplicationService)cs);
        svc = new EmbeddedBufferService();
        svc.initialize(null);
        r.installService("dqp.buffer", (ApplicationService)svc);
        TestLocalBufferService.assertFalse((boolean)cs.useDiskBuffering());
        BufferManagerImpl mgr = (BufferManagerImpl)svc.getBufferManager();
        BufferConfig config = mgr.getConfig();
        TestLocalBufferService.assertEquals((String)"Did not get expected memory level", (long)64000000L, (long)config.getTotalAvailableMemory());
    }
}

