/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.jdbc.EmbeddedDriver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.TestCase;

public class TestEmbeddedDriver
extends TestCase {
    EmbeddedDriver driver = new EmbeddedDriver();

    public void testAcceptsURL() throws SQLException {
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@c:\\metamatrix\\dqp\\dqp.properties"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@c:\\metamatrix\\dqp\\dqp.properties;version=1"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@c:\\metamatrix\\dqp\\dqp.properties;version=1;txnAutoWrap=ON;partialResultsMode=YES"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@c:/metamatrix/dqp/dqp.properties"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@c:/metamatrix/dqp/dqp.properties;version=1"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@c:/metamatrix/dqp/dqp.properties;version=1;txnAutoWrap=ON;partialResultsMode=YES"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@/metamatrix/dqp/dqp.properties"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@/metamatrix/dqp/dqp.properties;version=1"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@/metamatrix/dqp/dqp.properties;version=1;txnAutoWrap=ON;partialResultsMode=YES"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@../../metamatrix/dqp/dqp.properties"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@../../metamatrix/dqp/dqp.properties;version=1"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@../../metamatrix/dqp/dqp.properties;version=1;txnAutoWrap=ON;partialResultsMode=YES"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@file:///c:/metamatrix/dqp/dqp.properties"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@testdata/dqp/dqp.properties;partialResultsMode=true"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@classpath:/dqp.properties;partialResultsMode=true"));
        TestEmbeddedDriver.assertFalse((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@mm://host:7001;version=1"));
        TestEmbeddedDriver.assertFalse((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT@mms://host:7001;version=1"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT"));
        TestEmbeddedDriver.assertFalse((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT!/path/foo.properties"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT;"));
        TestEmbeddedDriver.assertTrue((boolean)this.driver.acceptsURL("jdbc:metamatrix:BQT;version=1;logFile=foo.txt"));
    }

    public void testParseURL() throws SQLException {
        Properties p = new Properties();
        this.driver.parseURL("jdbc:metamatrix:BQT@c:\\metamatrix\\dqp\\dqp.properties", p);
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        TestEmbeddedDriver.assertTrue((boolean)p.get("bootstrapFile").toString().equals("mmfile:/c:/metamatrix/dqp/dqp.properties"));
        TestEmbeddedDriver.assertEquals((int)2, (int)p.size());
    }

    public void testParseURL2() throws SQLException {
        Properties p = new Properties();
        this.driver.parseURL("jdbc:metamatrix:BQT@\\metamatrix\\dqp\\dqp.properties;version=3", p);
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        TestEmbeddedDriver.assertTrue((boolean)p.get("bootstrapFile").toString().equals("mmfile:/metamatrix/dqp/dqp.properties"));
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("version").equals("3"));
        TestEmbeddedDriver.assertEquals((int)4, (int)p.size());
    }

    public void testParseURL3() throws SQLException {
        Properties p = new Properties();
        this.driver.parseURL("jdbc:metamatrix:BQT@/metamatrix/dqp/dqp.properties;version=4;txnAutoWrap=ON;partialResultsMode=YES;", p);
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("4"));
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("version").equals("4"));
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("txnAutoWrap").equals("ON"));
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("partialResultsMode").equals("YES"));
        TestEmbeddedDriver.assertEquals((int)6, (int)p.size());
    }

    public void testParseURL4() throws SQLException {
        Properties p = new Properties();
        this.driver.parseURL("jdbc:metamatrix:BQT@testdata/dqp/dqp.properties;partialResultsMode=true", p);
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        TestEmbeddedDriver.assertTrue((boolean)p.get("bootstrapFile").toString().equals("mmfile:testdata/dqp/dqp.properties"));
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("partialResultsMode").equals("true"));
        TestEmbeddedDriver.assertEquals((int)3, (int)p.size());
    }

    public void testParseURL5() throws SQLException {
        Properties p = new Properties();
        this.driver.parseURL("jdbc:metamatrix:BQT", p);
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        TestEmbeddedDriver.assertTrue((boolean)p.get("bootstrapFile").toString().equals("classpath:/deploy.properties"));
    }

    public void testParseURL55() throws SQLException {
        Properties p = new Properties();
        this.driver.parseURL("jdbc:metamatrix:BQT;", p);
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        TestEmbeddedDriver.assertTrue((boolean)p.get("bootstrapFile").toString().equals("classpath:/deploy.properties"));
    }

    public void testParseURL6() throws SQLException {
        Properties p = new Properties();
        this.driver.parseURL("jdbc:metamatrix:BQT;partialResultsMode=true;version=1", p);
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        TestEmbeddedDriver.assertTrue((boolean)p.get("bootstrapFile").toString().equals("classpath:/deploy.properties"));
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("partialResultsMode").equals("true"));
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("1"));
        TestEmbeddedDriver.assertTrue((boolean)p.getProperty("vdb.definition").equals("BQT.vdb"));
        TestEmbeddedDriver.assertEquals((int)6, (int)p.size());
    }

    public void test() throws Exception {
        try {
            Class.forName("com.metamatrix.jdbc.EmbeddedDriver");
            DriverManager.getConnection("jdbc:metamatrix:Parts@invalidConfig.properties;version=1");
            TestEmbeddedDriver.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

