/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded;

import com.google.inject.Binder;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.DQPConfigSource;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.services.EmbeddedBufferService;
import com.metamatrix.dqp.embedded.services.EmbeddedConfigurationService;
import com.metamatrix.dqp.embedded.services.EmbeddedDataService;
import com.metamatrix.dqp.embedded.services.EmbeddedMetadataService;
import com.metamatrix.dqp.embedded.services.EmbeddedTrackingService;
import com.metamatrix.dqp.embedded.services.EmbeddedTransactionService;
import com.metamatrix.dqp.embedded.services.EmbeddedVDBService;
import com.metamatrix.jdbc.JDBCPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class EmbeddedConfigSource
implements DQPConfigSource {
    private static final String SERVER_CONFIG_FILE_EXTENSION = ".properties";
    private Properties props;
    private boolean useTxn;

    public EmbeddedConfigSource(Properties connectionProperties) {
        URL dqpURL = (URL)connectionProperties.get("bootstrapFile");
        if (dqpURL == null) {
            throw new MetaMatrixRuntimeException(JDBCPlugin.Util.getString("LocalTransportHandler.No_configuration_file_set_in_property", new Object[]{"dqp.propertiesFile"}));
        }
        String dqpFileName = dqpURL.toString().toLowerCase();
        if (!dqpFileName.endsWith(SERVER_CONFIG_FILE_EXTENSION)) {
            throw new MetaMatrixRuntimeException(JDBCPlugin.Util.getString("LocalTransportHandler.Invalid_config_file_extension", new Object[]{dqpFileName}));
        }
        String dqpURLString = dqpURL.toString();
        try {
            dqpURL = URLHelper.buildURL((String)dqpURLString);
            InputStream in = dqpURL.openStream();
            if (in == null) {
                throw new MetaMatrixRuntimeException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigSource.Can_not_load_config_file_2", new Object[]{dqpURL}));
            }
            this.props = new Properties();
            this.props.load(in);
            in.close();
            if (connectionProperties != null) {
                this.props.putAll((Map<?, ?>)connectionProperties);
            }
            this.props = PropertiesUtils.resolveNestedProperties((Properties)this.props);
            this.props.setProperty("dqp.identity", this.getDQPIdentity());
            this.props.setProperty("mm.io.tmpdir", this.getWorkspaceDirectory());
            this.props.put("dqp.propertiesFile", dqpURL);
            this.useTxn = PropertiesUtils.getBooleanProperty((Properties)this.props, (String)"metamatrix.xatxnmgr.enabled", (boolean)true);
        }
        catch (IOException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    String getDQPIdentity() {
        String id = System.getProperty("dqp.identity", "0");
        return id;
    }

    String getWorkspaceDirectory() {
        return System.getProperty("mm.io.tmpdir", System.getProperty("java.io.tmpdir"));
    }

    public Properties getProperties() {
        return this.props;
    }

    public void updateBindings(Binder binder) {
    }

    public Map<String, Class<? extends ApplicationService>> getDefaultServiceClasses() {
        HashMap<String, Class<? extends ApplicationService>> result = new HashMap<String, Class<? extends ApplicationService>>();
        result.put("dqp.configuration", EmbeddedConfigurationService.class);
        result.put("dqp.tracking", EmbeddedTrackingService.class);
        result.put("dqp.buffer", EmbeddedBufferService.class);
        result.put("dqp.vdb", EmbeddedVDBService.class);
        result.put("dqp.metadata", EmbeddedMetadataService.class);
        result.put("dqp.data", EmbeddedDataService.class);
        if (this.useTxn) {
            result.put("dqp.transaction", EmbeddedTransactionService.class);
        }
        return result;
    }
}

