/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.admin;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.ConnectorType;
import com.metamatrix.admin.api.objects.LogConfiguration;
import com.metamatrix.admin.api.objects.Model;
import com.metamatrix.admin.api.objects.QueueWorkerPool;
import com.metamatrix.admin.api.objects.Request;
import com.metamatrix.admin.api.objects.Session;
import com.metamatrix.admin.api.objects.SystemObject;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.admin.objects.MMConnectorBinding;
import com.metamatrix.admin.objects.MMConnectorType;
import com.metamatrix.admin.objects.MMExtensionModule;
import com.metamatrix.admin.objects.MMLogConfiguration;
import com.metamatrix.admin.objects.MMModel;
import com.metamatrix.admin.objects.MMPropertyDefinition;
import com.metamatrix.admin.objects.MMQueueWorkerPool;
import com.metamatrix.admin.objects.MMRequest;
import com.metamatrix.admin.objects.MMSession;
import com.metamatrix.admin.objects.MMSystem;
import com.metamatrix.admin.objects.MMVDB;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.jdbc.EmbeddedConnectionFactoryImpl;
import com.metamatrix.server.serverapi.RequestInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

abstract class BaseAdmin {
    static final String DOT = ".";
    static final String STAR = "*";
    static final String FILE_NAME_REGEX = "\\w+\\.\\w+";
    static final String MULTIPLE_WORDS_REGEX = "\\w+([\\s|-]*\\w)*";
    static final String SINGLE_WORD_REGEX = "\\w+";
    static final String MULTIPLE_WORD_WILDCARD_REGEX = "\\w*((\\.)?\\s*\\w)*(\\*)?";
    static final String SINGLE_WORD_WILDCARD_REGEX = "\\w*(\\*)?";
    static final String WORD_AND_DOT_WILDCARD_REGEX = "\\w+((\\.\\*)|(\\.\\w+)|(\\.\\w*\\*))*|\\w*(\\*){1}";
    static final String VDB_REGEX = "\\w*(\\*)?(\\.\\d+)?";
    static final String NUMBER_DOT_REGEX = "\\d+((\\.\\*)|(\\.\\d+)|(\\.\\d*\\*))*|\\d*(\\*){1}";
    static final String NUMBER_REGEX = "\\d*(\\*)?";
    static final String[] cacheTypes = new String[]{"CodeTableCache", "ConnectorResultSetCache", "PreparedPlanCache", "QueryServiceResultSetCache"};
    EmbeddedConnectionFactoryImpl manager = null;

    BaseAdmin(EmbeddedConnectionFactoryImpl manager) {
        this.manager = manager;
    }

    protected AdminException accumulateSystemException(AdminException parent, Exception e) {
        if (parent == null) {
            return new AdminComponentException((Throwable)e);
        }
        parent.addChild((AdminException)new AdminComponentException((Throwable)e));
        return parent;
    }

    protected AdminException accumulateProcessingException(AdminException parent, Exception e) {
        if (parent == null) {
            return new AdminProcessingException((Throwable)e);
        }
        parent.addChild((AdminException)new AdminProcessingException((Throwable)e));
        return parent;
    }

    protected String prettyPrintBindingNames(List bindings) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            ConnectorBinding binding = (ConnectorBinding)iter.next();
            buffer.append(binding.getDeployedName());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public EmbeddedConnectionFactoryImpl getManager() {
        return this.manager;
    }

    VDBService getVDBService() {
        return (VDBService)this.getManager().findService("dqp.vdb");
    }

    DataService getDataService() {
        return (DataService)this.getManager().findService("dqp.data");
    }

    ConfigurationService getConfigurationService() {
        return (ConfigurationService)this.getManager().findService("dqp.configuration");
    }

    protected Object convertToAdminObjects(Object src) {
        return this.convertToAdminObjects(src, null);
    }

    protected Object convertToAdminObjects(Object src, Object parent) {
        if (src == null) {
            return src;
        }
        if (src instanceof List) {
            ArrayList<Object> modified = new ArrayList<Object>();
            List list = (List)src;
            for (Object e : list) {
                Object converted = this.convertToAdminObject(e, parent);
                modified.add(converted);
            }
            return modified;
        }
        if (src instanceof Collection) {
            ArrayList<Object> modified = new ArrayList<Object>();
            for (Object e : (Collection)src) {
                Object converted = this.convertToAdminObject(e, parent);
                modified.add(converted);
            }
            return modified;
        }
        if (src instanceof Object[]) {
            ArrayList<Object> modified = new ArrayList<Object>();
            Object[] srcArray = (Object[])src;
            for (int i = 0; i < srcArray.length; ++i) {
                Object converted = this.convertToAdminObject(srcArray[i], parent);
                modified.add(converted);
            }
            return modified;
        }
        return this.convertToAdminObject(src, parent);
    }

    private Object convertToAdminObject(Object src, Object parent) {
        if (src != null && src instanceof ConnectorBinding) {
            ConnectorBinding binding = (ConnectorBinding)src;
            return this.convertConnectorType(binding, parent);
        }
        if (src != null && src instanceof ConnectorBindingType) {
            ConnectorBindingType type = (ConnectorBindingType)src;
            return this.convertConnectorType(type, parent);
        }
        if (src != null && src instanceof VDBDefn) {
            VDBDefn vdb = (VDBDefn)src;
            return this.convertVDB(vdb, parent);
        }
        if (src != null && src instanceof VDBArchive) {
            VDBArchive vdb = (VDBArchive)src;
            return this.convertVDB((VDBDefn)vdb.getConfigurationDef(), parent);
        }
        if (src != null && src instanceof ModelInfo) {
            ModelInfo model = (ModelInfo)src;
            return this.convertModel(model, parent);
        }
        if (src != null && src instanceof com.metamatrix.common.log.LogConfiguration) {
            com.metamatrix.common.log.LogConfiguration config = (com.metamatrix.common.log.LogConfiguration)src;
            return this.covertLogConfiguration(config);
        }
        if (src != null && src instanceof RequestInfo) {
            RequestInfo request = (RequestInfo)src;
            return this.convertRequest(request);
        }
        if (src != null && src instanceof WorkerPoolStats) {
            WorkerPoolStats stats = (WorkerPoolStats)src;
            return this.convertStats(stats);
        }
        if (src != null && src instanceof ServerConnection) {
            ServerConnection conn = (ServerConnection)src;
            return this.convertConnection(conn);
        }
        if (src != null && src instanceof ExtensionModule) {
            ExtensionModule extModule = (ExtensionModule)src;
            return this.convertExtensionModule(extModule);
        }
        throw new UnsupportedOperationException(DQPEmbeddedPlugin.Util.getString("UnSupported_object_conversion"));
    }

    Object convertToNativeObjects(Object src) {
        if (src instanceof LogConfiguration) {
            LogConfiguration config = (LogConfiguration)src;
            return this.covertLogConfiguration(config);
        }
        throw new UnsupportedOperationException(DQPEmbeddedPlugin.Util.getString("UnSupported_object_conversion"));
    }

    private com.metamatrix.admin.api.objects.ExtensionModule convertExtensionModule(ExtensionModule src) {
        MMExtensionModule module = new MMExtensionModule(new String[]{src.getFullName()});
        module.setDescription(src.getDescription());
        module.setFileContents(src.getFileContents());
        module.setModuleType(src.getModuleType());
        return module;
    }

    private Session convertConnection(ServerConnection src) {
        MMSession session = new MMSession(new String[]{src.getLogonResult().getSessionID().toString()});
        session.setVDBName(src.getLogonResult().getProductInfo("VirtualDatabaseName"));
        session.setVDBVersion(src.getLogonResult().getProductInfo("VirtualDatabaseVersion"));
        return session;
    }

    private QueueWorkerPool convertStats(WorkerPoolStats src) {
        MMQueueWorkerPool pool = new MMQueueWorkerPool(new String[]{src.name});
        pool.setDeployed(true);
        pool.setRegistered(true);
        pool.setDequeues(0);
        pool.setEnqueues(0);
        pool.setHighwaterMark(0);
        pool.setQueued(src.queued);
        pool.setThreads(src.threads);
        pool.setTotalDequeues(src.totalCompleted);
        pool.setTotalEnqueues(src.totalSubmitted);
        pool.setTotalHighwaterMark(0);
        return pool;
    }

    private LogConfiguration covertLogConfiguration(com.metamatrix.common.log.LogConfiguration src) {
        MMLogConfiguration log = new MMLogConfiguration();
        log.setDiscardedContexts(src.getDiscardedContexts());
        log.setLogLevel(src.getMessageLevel());
        return log;
    }

    private com.metamatrix.common.log.LogConfiguration covertLogConfiguration(LogConfiguration src) {
        return new BasicLogConfiguration((Collection)src.getDiscardedContexts(), src.getLogLevel());
    }

    private com.metamatrix.admin.api.objects.ConnectorBinding convertConnectorType(ConnectorBinding src, Object parent) {
        MMConnectorBinding binding = new MMConnectorBinding(new String[]{src.getDeployedName()});
        binding.setConnectorTypeName(src.getComponentTypeID().getFullName());
        binding.setCreated(src.getCreatedDate());
        binding.setCreatedBy(src.getCreatedBy());
        binding.setDeployed(src.isEnabled());
        binding.setDescription(src.getDescription());
        binding.setEnabled(src.isEnabled());
        binding.setLastUpdated(src.getLastChangedDate());
        binding.setLastUpdatedBy(src.getLastChangedBy());
        binding.setProperties(src.getProperties());
        binding.setRegistered(true);
        binding.setRoutingUUID(src.getRoutingUUID());
        binding.setServiceID(0L);
        try {
            Boolean status = this.getDataService().getConnectorBindingState(src.getDeployedName());
            if (status == Boolean.TRUE) {
                binding.setState(1);
            } else if (status == Boolean.FALSE) {
                binding.setState(6);
            } else {
                binding.setState(6);
            }
        }
        catch (Exception e) {
            binding.setState(6);
        }
        binding.setStateChangedTime(src.getLastChangedDate());
        return binding;
    }

    private ConnectorType convertConnectorType(ConnectorBindingType src, Object parent) {
        MMConnectorType type = new MMConnectorType(new String[]{src.getName()});
        type.setCreated(src.getCreatedDate());
        type.setCreatedBy(src.getCreatedBy());
        type.setDeployed(src.isDeployable());
        type.setEnabled(true);
        type.setLastUpdated(src.getLastChangedDate());
        type.setRegistered(true);
        return type;
    }

    private VDB convertVDB(VDBDefn src, Object parent) {
        MMVDB vdb = new MMVDB(new String[]{src.getName(), src.getVersion()});
        vdb.setCreated(src.getDateCreated());
        vdb.setCreatedBy(src.getCreatedBy());
        vdb.setDeployed(src.isActiveStatus());
        vdb.setEnabled(src.isActiveStatus());
        vdb.setLastUpdated(src.getDateCreated());
        vdb.setLastUpdatedBy(src.getCreatedBy());
        vdb.setMaterializedViews(src.getMatertializationModel() != null);
        vdb.setModels((Collection)this.convertToAdminObjects(src.getModels(), src));
        vdb.setProperties(null);
        vdb.setRegistered(true);
        vdb.setStatus(src.getStatus());
        vdb.setUID(0L);
        vdb.setVersionedBy(src.getCreatedBy());
        vdb.setVersionedDate(src.getDateCreated());
        vdb.setHasWSDL(src.hasWSDLDefined());
        return vdb;
    }

    private Model convertModel(ModelInfo src, Object parent) {
        List bindings;
        VDBDefn vdb = (VDBDefn)parent;
        MMModel model = new MMModel(new String[]{src.getName()});
        model.setCreated(vdb.getDateCreated());
        model.setCreatedBy(vdb.getCreatedBy());
        model.setDeployed(vdb.isActiveStatus());
        model.setEnabled(vdb.isActiveStatus());
        model.setLastUpdated(vdb.getDateCreated());
        model.setLastUpdatedBy(vdb.getCreatedBy());
        model.setModelType(src.getModelTypeName());
        model.setModelURI(src.getModelURI());
        model.setMaterialization(src.isMaterialization());
        model.setPhysical(src.isPhysical());
        model.setRegistered(true);
        model.setSupportsMultiSourceBindings(src.isMultiSourceBindingEnabled());
        model.setVisible(src.isVisible());
        if (src.isPhysical() && (bindings = src.getConnectorBindingNames()) != null && !bindings.isEmpty()) {
            ArrayList<ConnectorBinding> names = new ArrayList<ConnectorBinding>();
            for (int i = 0; i < bindings.size(); ++i) {
                names.add(vdb.getConnectorBindingByName((String)bindings.get(i)));
            }
            model.setConnectorBindingNames(names);
        }
        return model;
    }

    private Request convertRequest(RequestInfo src) {
        String connId = src.getRequestID().getConnectionID();
        MMRequest request = null;
        request = src.getConnectorBindingUUID() != null ? new MMRequest(new String[]{connId, String.valueOf(src.getRequestID().getExecutionID()), String.valueOf(src.getNodeID())}) : new MMRequest(new String[]{connId, String.valueOf(src.getRequestID().getExecutionID())});
        request.setSqlCommand(src.getCommand());
        request.setCreated(src.getProcessingTimestamp());
        if (src.getConnectorBindingUUID() != null) {
            request.setSource(true);
            request.setNodeID(String.valueOf(src.getNodeID()));
        }
        return request;
    }

    ServerConnection getClientConnection(String identifier) {
        Set connections = this.getConfigurationService().getClientConnections();
        for (ServerConnection clientConnection : connections) {
            if (!clientConnection.getLogonResult().getSessionID().toString().equals(identifier)) continue;
            return clientConnection;
        }
        return null;
    }

    Set<ServerConnection> getClientConnections() throws AdminException {
        return this.getConfigurationService().getClientConnections();
    }

    boolean matches(String regEx, String value) {
        regEx = regEx.replaceAll("\\*", ".*");
        regEx = regEx.replaceAll(AdminObject.ESCAPED_DELIMITER, "");
        return value.matches(regEx);
    }

    List matchedCollection(String identifier, List adminObjects) {
        ArrayList<AdminObject> matched = new ArrayList<AdminObject>();
        for (AdminObject aObj : adminObjects) {
            if (!this.matches(identifier, aObj.getName()) && !this.matches(identifier, aObj.getIdentifier())) continue;
            matched.add(aObj);
        }
        return matched;
    }

    Collection getConnectorBindings(String identifier) throws AdminException {
        try {
            List connectorBindings = this.getDataService().getConnectorBindings();
            connectorBindings = (List)this.convertToAdminObjects(connectorBindings);
            return this.matchedCollection(identifier, connectorBindings);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    Collection getConnectorTypes(String identifier) throws AdminException {
        try {
            List connectorTypes = this.getConfigurationService().getConnectorTypes();
            connectorTypes = (List)this.convertToAdminObjects(connectorTypes);
            return this.matchedCollection(identifier, connectorTypes);
        }
        catch (MetaMatrixComponentException err) {
            throw new AdminComponentException((Throwable)err);
        }
    }

    public SystemObject getSystem() {
        MMSystem system = new MMSystem();
        system.setStartTime(new Date(this.manager.getStartTime()));
        system.setStarted(this.manager.isAlive());
        system.setProperties(this.manager.getProperties());
        return system;
    }

    boolean isMaskedProperty(String propName, ComponentType type) {
        ComponentTypeDefn typeDef;
        return type != null && (typeDef = type.getComponentTypeDefinition(propName)) != null && typeDef.getPropertyDefinition().isMasked();
    }

    String encryptString(String value) throws AdminException {
        try {
            return CryptoUtil.stringEncrypt((String)value);
        }
        catch (CryptoException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    protected Collection convertPropertyDefinitions(ComponentType ctype, Properties properties) {
        ArrayList<MMPropertyDefinition> results = new ArrayList<MMPropertyDefinition>();
        for (ComponentTypeDefn cdefn : ctype.getComponentTypeDefinitions()) {
            PropertyDefinition pdefn = cdefn.getPropertyDefinition();
            MMPropertyDefinition result = new MMPropertyDefinition(new String[]{pdefn.getName()});
            result.setAllowedValues((Collection)pdefn.getAllowedValues());
            result.setConstrainedToAllowedValues(pdefn.isConstrainedToAllowedValues());
            result.setDefaultValue(pdefn.getDefaultValue());
            result.setDescription(pdefn.getShortDescription());
            result.setDisplayName(pdefn.getDisplayName());
            result.setExpert(pdefn.isExpert());
            result.setHidden(pdefn.isHidden());
            result.setMasked(pdefn.isMasked());
            result.setMinimumMultiplicity(pdefn.getMultiplicity().getMinimum());
            result.setMaximumMultiplicity(pdefn.getMultiplicity().getMaximum());
            result.setModifiable(pdefn.isModifiable());
            result.setPreferred(pdefn.isPreferred());
            result.setPropertyType(pdefn.getPropertyType().getDisplayName());
            result.setPropertyTypeClassName(pdefn.getPropertyType().getClassName());
            result.setRequired(pdefn.isRequired());
            result.setRequiresRestart(pdefn.getRequiresRestart());
            result.setValueDelimiter(pdefn.getValueDelimiter());
            String value = properties.getProperty(pdefn.getName());
            result.setValue(value);
            results.add(result);
        }
        return results;
    }

    protected Collection convertPropertyDefinitions(Properties properties) {
        ArrayList<MMPropertyDefinition> results = new ArrayList<MMPropertyDefinition>();
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string);
            MMPropertyDefinition result = new MMPropertyDefinition(new String[]{string});
            result.setDisplayName(string);
            result.setValue(value);
            results.add(result);
        }
        return results;
    }

    protected Collection getAdminObjects(String identifier, String className) throws AdminException {
        int code = MMAdminObject.getObjectType((String)className);
        ArrayList<SystemObject> list = null;
        switch (code) {
            case 2: {
                return this.getConnectorBindings(identifier);
            }
            case 3: {
                return this.getConnectorTypes(identifier);
            }
            case 19: {
                list = new ArrayList<SystemObject>();
                list.add(this.getSystem());
                return list;
            }
        }
        throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("AdminImpl.Unsupported_Admin_Object", new Object[]{className}));
    }
}

