/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.admin;

import com.metamatrix.admin.api.embedded.EmbeddedConfigAdmin;
import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.objects.AdminStatus;
import com.metamatrix.admin.api.objects.LogConfiguration;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.admin.objects.MMAdminStatus;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.model.BasicConnectorArchive;
import com.metamatrix.common.config.model.BasicExtensionModule;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.admin.BaseAdmin;
import com.metamatrix.dqp.embedded.configuration.ConnectorConfigurationReader;
import com.metamatrix.dqp.embedded.configuration.ConnectorConfigurationWriter;
import com.metamatrix.dqp.embedded.configuration.ServerConfigFileWriter;
import com.metamatrix.dqp.embedded.configuration.VDBConfigurationReader;
import com.metamatrix.jdbc.EmbeddedConnectionFactoryImpl;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class DQPConfigAdminImpl
extends BaseAdmin
implements EmbeddedConfigAdmin {
    public DQPConfigAdminImpl(EmbeddedConnectionFactoryImpl manager) {
        super(manager);
    }

    public void setSystemProperty(String propertyName, String propertyValue) throws AdminException {
        try {
            this.getConfigurationService().setSystemProperty(propertyName, propertyValue);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void updateSystemProperties(Properties properties) throws AdminException {
        try {
            this.getConfigurationService().updateSystemProperties(properties);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void setProperty(String identifier, String className, String propertyName, String propertyValue) throws AdminException {
        Properties properties = new Properties();
        properties.setProperty(propertyName, propertyValue);
        this.updateProperties(identifier, className, properties);
    }

    public void updateProperties(String identifier, String className, Properties properties) throws AdminException {
        Collection adminObjects = this.getAdminObjects(identifier, className);
        if (adminObjects == null || adminObjects.size() == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.No_Objects_Found", new Object[]{identifier, className}));
        }
        if (adminObjects.size() > 1) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Multiple_Objects_Found", new Object[]{identifier, className}));
        }
        AdminObject adminObject = (AdminObject)adminObjects.iterator().next();
        int typeCode = MMAdminObject.getObjectType((String)className);
        switch (typeCode) {
            case 19: {
                this.updateSystemProperties(properties);
                break;
            }
            case 2: {
                try {
                    String bindingName = adminObject.getName();
                    ConnectorBinding binding = this.getConfigurationService().getConnectorBinding(bindingName);
                    ComponentTypeID id = binding.getComponentTypeID();
                    ConnectorBindingType type = this.getConfigurationService().getConnectorType(id.getName());
                    Properties encryptedProperties = new Properties();
                    encryptedProperties.putAll((Map<?, ?>)properties);
                    for (String string : properties.keySet()) {
                        boolean needsEncryption = this.isMaskedProperty(string, (ComponentType)type);
                        if (!needsEncryption) continue;
                        String propertyValue = properties.getProperty(string);
                        propertyValue = this.encryptString(propertyValue);
                        encryptedProperties.put(string, propertyValue);
                    }
                    binding = ConnectorConfigurationReader.addConnectorBindingProperties(binding, encryptedProperties);
                    this.getConfigurationService().updateConnectorBinding(binding);
                    break;
                }
                catch (MetaMatrixComponentException e) {
                    throw new AdminComponentException((Throwable)e);
                }
            }
            default: {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.can_not_set_property"));
            }
        }
    }

    public void addConnectorType(String deployName, char[] cdkFile) throws AdminException {
        try {
            if (deployName == null || !deployName.matches("\\w+([\\s|-]*\\w)*")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_name"));
            }
            if (cdkFile == null || cdkFile.length == 0) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_source"));
            }
            if (this.getConfigurationService().getConnectorType(deployName) != null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_type_exists", new Object[]{deployName}));
            }
            ConnectorBindingType type = ConnectorConfigurationReader.loadConnectorType(cdkFile);
            this.saveConnectorType(type);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixProcessingException e) {
            throw new AdminProcessingException((Throwable)e);
        }
    }

    public void deleteConnectorType(String deployName) throws AdminException {
        try {
            if (deployName == null || !deployName.matches("\\w+([\\s|-]*\\w)*")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_name"));
            }
            this.getConfigurationService().deleteConnectorType(deployName);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public com.metamatrix.admin.api.objects.ConnectorBinding addConnectorBinding(String deployName, String type, Properties properties, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        if (deployName == null || !deployName.matches("\\w+([\\s|-]*\\w)*")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_name"));
        }
        if (type == null || !type.matches("\\w+([\\s|-]*\\w)*")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_name"));
        }
        ConnectorBinding binding = null;
        try {
            ConnectorBindingType ctype;
            if (this.bindingExists(deployName)) {
                if (options.containsOption(4)) {
                    throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.addBindingEixists", new Object[]{deployName}));
                }
                if (options.containsOption(2)) {
                    binding = this.getDataService().getConnectorBinding(deployName);
                    return (com.metamatrix.admin.api.objects.ConnectorBinding)this.convertToAdminObjects(binding);
                }
            }
            if ((ctype = this.getConfigurationService().getConnectorType(type)) == null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.connector_type_not_exists", new Object[]{type}));
            }
            binding = ConnectorConfigurationReader.loadConnectorBinding(deployName, properties, ctype);
            AdminStatus status = this.checkDecryption(binding, ctype);
            if (status.getCode() == -101 && !options.containsOption(8)) {
                throw new AdminProcessingException(status.getCode(), status.getMessage());
            }
            binding = this.addConnectorBinding(deployName, binding, ctype, true);
        }
        catch (MetaMatrixProcessingException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        return (com.metamatrix.admin.api.objects.ConnectorBinding)this.convertToAdminObjects(binding);
    }

    boolean bindingExists(String name) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        ConnectorBinding binding = this.getDataService().getConnectorBinding(name);
        return binding != null;
    }

    boolean bindingTypeExists(String name) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        ConnectorBindingType type = this.getConfigurationService().getConnectorType(name);
        return type != null;
    }

    public com.metamatrix.admin.api.objects.ConnectorBinding addConnectorBinding(String deployName, char[] xmlFile, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        if (deployName == null || !deployName.matches("\\w+([\\s|-]*\\w)*")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_name"));
        }
        if (xmlFile == null || xmlFile.length == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_source"));
        }
        ConnectorBinding binding = null;
        try {
            ConnectorBindingType type;
            if (this.bindingExists(deployName)) {
                if (options.containsOption(4)) {
                    throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.addBindingEixists", new Object[]{deployName}));
                }
                if (options.containsOption(2)) {
                    binding = this.getDataService().getConnectorBinding(deployName);
                    return (com.metamatrix.admin.api.objects.ConnectorBinding)this.convertToAdminObjects(binding);
                }
            }
            if (this.bindingTypeExists((type = ConnectorConfigurationReader.loadConnectorType(xmlFile)).getName()) && options.containsOption(4)) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.addBinding_type_exists", new Object[]{deployName, type.getName()}));
            }
            binding = ConnectorConfigurationReader.loadConnectorBinding(deployName, xmlFile);
            AdminStatus status = this.checkDecryption(binding, type);
            if (status.getCode() == -101 && !options.containsOption(8)) {
                throw new AdminProcessingException(status.getCode(), status.getMessage());
            }
            binding = this.addConnectorBinding(deployName, binding, type, true);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixProcessingException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        return (com.metamatrix.admin.api.objects.ConnectorBinding)this.convertToAdminObjects(binding);
    }

    ConnectorBinding addConnectorBinding(String deployName, ConnectorBinding binding, ConnectorBindingType type, boolean replace) throws AdminException {
        if (type != null && binding != null) {
            if (binding.getComponentTypeID().getName().equals(type.getName())) {
                try {
                    if (this.getConfigurationService().getConnectorType(type.getName()) == null || replace) {
                        this.saveConnectorType(type);
                    }
                    binding = this.getConfigurationService().addConnectorBinding(deployName, binding, replace);
                    return binding;
                }
                catch (MetaMatrixComponentException e) {
                    throw new AdminComponentException((Throwable)e);
                }
                catch (MetaMatrixProcessingException e) {
                    throw new AdminProcessingException((Throwable)e);
                }
            }
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.connector_load_failed_wrong_type", new Object[]{deployName}));
        }
        throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.connector_load_failed_wrong_contents", new Object[]{deployName}));
    }

    public void deleteConnectorBinding(String identifier) throws AdminException {
        try {
            if (identifier == null || !identifier.matches("\\w*((\\.)?\\s*\\w)*(\\*)?")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_name"));
            }
            this.getConfigurationService().deleteConnectorBinding(identifier);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    private VDB addVDB(String deployName, byte[] vdbFile, char[] defFile, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        if (deployName == null || !deployName.matches("\\w+")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_vdb_name"));
        }
        if (vdbFile == null || vdbFile.length == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_vdb_source"));
        }
        if (defFile == null) {
            DQPEmbeddedPlugin.logInfo("Admin.load_combined_vdb", new Object[]{deployName});
        }
        VDBArchive vdb = null;
        try {
            vdb = defFile == null ? VDBConfigurationReader.loadVDB(deployName, vdbFile) : VDBConfigurationReader.loadVDB(deployName, defFile, vdbFile);
            this.validateConnectorBindingsInVdb(vdb, options);
            VDBArchive deployedVDB = this.getConfigurationService().addVDB(vdb, !options.containsOption(2));
            if (deployedVDB.getStatus() == 3 || deployedVDB.getStatus() == 3) {
                try {
                    this.startVDBConnectorBindings(deployedVDB);
                }
                catch (MetaMatrixComponentException e) {
                }
                catch (MetaMatrixProcessingException e) {
                }
                catch (ApplicationLifecycleException e) {
                    // empty catch block
                }
            }
            return (VDB)this.convertToAdminObjects(deployedVDB);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixProcessingException e) {
            throw new AdminProcessingException((Throwable)e);
        }
    }

    private void startVDBConnectorBindings(VDBArchive vdb) throws MetaMatrixComponentException, MetaMatrixProcessingException, ApplicationLifecycleException {
        BasicVDBDefn def = vdb.getConfigurationDef();
        Collection bindings = def.getConnectorBindings().values();
        for (ConnectorBinding binding : bindings) {
            this.getDataService().startConnectorBinding(binding.getDeployedName());
        }
    }

    void validateConnectorBindingsInVdb(VDBArchive vdb, AdminOptions options) throws MetaMatrixComponentException, MetaMatrixProcessingException, AdminProcessingException, AdminException {
        BasicVDBDefn def = vdb.getConfigurationDef();
        int version = 0;
        VDBArchive existing = null;
        while ((existing = this.getConfigurationService().getVDB(def.getName(), String.valueOf(++version))) != null) {
        }
        ArrayList vdbbindings = new ArrayList(def.getConnectorBindings().values());
        for (ConnectorBinding binding : vdbbindings) {
            String deployName = binding.getDeployedName();
            if (deployName == null) {
                deployName = binding.getFullName();
            }
            if (this.bindingExists(deployName) && options.containsOption(4)) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.addBindingEixists", new Object[]{binding.getDeployedName()}));
            }
            ConnectorBindingType type = (ConnectorBindingType)def.getConnectorType(binding.getComponentTypeID().getName());
            AdminStatus status = this.checkDecryption(binding, type);
            if (status.getCode() != -101 || options.containsOption(8)) continue;
            throw new AdminProcessingException(status.getCode(), status.getMessage());
        }
    }

    private AdminStatus checkDecryption(ConnectorBinding binding, ConnectorBindingType type) {
        try {
            Properties props = binding.getProperties();
            for (String string : props.keySet()) {
                if (!this.isMaskedProperty(string, (ComponentType)type)) continue;
                this.decryptProperty(props.getProperty(string));
            }
        }
        catch (CryptoException e) {
            return new MMAdminStatus(-101, "AdminStatus.CODE_DECRYPTION_FAILED", (Object)binding.getFullName());
        }
        return new MMAdminStatus(0, "AdminStatus.CODE_SUCCESS");
    }

    @Override
    boolean isMaskedProperty(String propName, ComponentType type) {
        ComponentTypeDefn typeDef;
        return type != null && (typeDef = type.getComponentTypeDefinition(propName)) != null && typeDef.getPropertyDefinition().isMasked();
    }

    String decryptProperty(String value) throws CryptoException {
        if (value != null && value.length() > 0) {
            return CryptoUtil.stringDecrypt((String)value);
        }
        return value;
    }

    public VDB addVDB(String deployName, byte[] vdbFile, AdminOptions options) throws AdminException {
        return this.addVDB(deployName, vdbFile, null, options);
    }

    public void addExtensionModule(String type, String sourceName, byte[] source, String description) throws AdminException {
        try {
            if (sourceName == null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ext_source_name"));
            }
            if (source == null || source.length == 0) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ext_source"));
            }
            if (!sourceName.endsWith(".jar") && !sourceName.endsWith(".xmi")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ext_module"));
            }
            ExtensionModule previousModule = null;
            try {
                previousModule = this.getConfigurationService().getExtensionModule(sourceName);
            }
            catch (MetaMatrixComponentException e) {
                // empty catch block
            }
            if (previousModule != null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.extension_module_exists", new Object[]{sourceName}));
            }
            BasicExtensionModule extModule = new BasicExtensionModule(sourceName, type, description, source);
            this.getConfigurationService().saveExtensionModule((ExtensionModule)extModule);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void deleteExtensionModule(String sourceName) throws AdminException {
        try {
            if (sourceName == null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ext_source_name"));
            }
            this.getConfigurationService().deleteExtensionModule(sourceName);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void assignBindingToModel(String deployedConnectorBindingName, String vdbName, String vdbVersion, String modelName) throws AdminException {
        if (deployedConnectorBindingName == null || !deployedConnectorBindingName.matches("\\w*((\\.)?\\s*\\w)*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_name"));
        }
        if (vdbName == null || vdbVersion == null || !vdbName.matches("\\w+")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_vdb_name"));
        }
        if (modelName == null || !modelName.matches("\\w+([\\s|-]*\\w)*")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_model_name"));
        }
        try {
            ConnectorBinding binding = this.getDataService().getConnectorBinding(deployedConnectorBindingName);
            if (binding == null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Vdb_or_Model_notfound"));
            }
            ArrayList<ConnectorBinding> list = new ArrayList<ConnectorBinding>();
            list.add(binding);
            this.getConfigurationService().assignConnectorBinding(vdbName, vdbVersion, modelName, list.toArray(new ConnectorBinding[list.size()]));
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public LogConfiguration getLogConfiguration() throws AdminException {
        return (LogConfiguration)this.convertToAdminObjects(LogManager.getLogConfigurationCopy());
    }

    public void setLogConfiguration(LogConfiguration config) throws AdminException {
        LogManager.setLogConfiguration((com.metamatrix.common.log.LogConfiguration)((com.metamatrix.common.log.LogConfiguration)this.convertToNativeObjects(config)));
    }

    public byte[] exportExtensionModule(String sourceName) throws AdminException {
        try {
            if (sourceName == null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ext_source_name"));
            }
            ExtensionModule extModule = this.getConfigurationService().getExtensionModule(sourceName);
            return extModule.getFileContents();
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public char[] exportConfiguration() throws AdminException {
        try {
            ConfigurationModelContainer model = this.getConfigurationService().getSystemConfiguration();
            return ServerConfigFileWriter.writeToCharArray(model);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public char[] exportConnectorBinding(String identifier) throws AdminException {
        try {
            if (identifier == null || !identifier.matches("\\w*((\\.)?\\s*\\w)*(\\*)?")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_name"));
            }
            List bindingList = this.getDataService().getConnectorBindings();
            ArrayList<ConnectorBinding> matchedList = new ArrayList<ConnectorBinding>();
            for (ConnectorBinding binding : bindingList) {
                if (!this.matches(identifier, binding.getDeployedName())) continue;
                matchedList.add(binding);
            }
            if (!matchedList.isEmpty()) {
                ConnectorBinding[] bindings = matchedList.toArray(new ConnectorBinding[matchedList.size()]);
                ConnectorBindingType[] types = new ConnectorBindingType[bindings.length];
                for (int i = 0; i < bindings.length; ++i) {
                    types[i] = this.getConfigurationService().getConnectorType(bindings[i].getComponentTypeID().getName());
                }
                return ConnectorConfigurationWriter.writeToCharArray(bindings, types);
            }
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_binding_does_not_exists", new Object[]{identifier}));
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public char[] exportConnectorType(String identifier) throws AdminException {
        try {
            if (identifier == null || !identifier.matches("\\w+([\\s|-]*\\w)*")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_name"));
            }
            List typesList = this.getConfigurationService().getConnectorTypes();
            ArrayList<ConnectorBindingType> matchedList = new ArrayList<ConnectorBindingType>();
            for (ConnectorBindingType type : typesList) {
                if (!this.matches(identifier, type.getName())) continue;
                matchedList.add(type);
            }
            if (!matchedList.isEmpty()) {
                ConnectorBindingType[] types = matchedList.toArray(new ConnectorBindingType[matchedList.size()]);
                return ConnectorConfigurationWriter.writeToCharArray(types);
            }
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_type_does_not_exists", new Object[]{identifier}));
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public byte[] exportVDB(String name, String version) throws AdminException {
        try {
            if (name == null || version == null || !name.matches("\\w+")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_vdb_name"));
            }
            VDBArchive vdb = this.getConfigurationService().getVDB(name, version);
            if (vdb != null) {
                return VDBArchive.writeToByteArray((VDBArchive)vdb);
            }
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.vdb_does_not_exists", new Object[]{name, version}));
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void addConnectorArchive(byte[] contents, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        if (contents == null || contents.length == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_source"));
        }
        try {
            HashSet previouslyAddedModules = new HashSet();
            ConnectorArchive archive = ConnectorConfigurationReader.loadConnectorArchive(contents);
            ConnectorBindingType[] connectorTypes = archive.getConnectorTypes();
            for (int typeIndex = 0; typeIndex < connectorTypes.length; ++typeIndex) {
                ExtensionModule[] extModules;
                String connectorName = connectorTypes[typeIndex].getName();
                ConnectorBindingType type = this.getConfigurationService().getConnectorType(connectorName);
                if (type == null) {
                    type = connectorTypes[typeIndex];
                    extModules = archive.getExtensionModules(type);
                    this.checkAddingConnectorType(type, extModules, options, previouslyAddedModules);
                    this.saveConnectorType(type);
                } else {
                    if (options.containsOption(4)) {
                        throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_type_exists", new Object[]{connectorName}));
                    }
                    if (options.containsOption(2)) continue;
                    if (options.containsOption(1)) {
                        this.deleteConnectorType(connectorName);
                        type = connectorTypes[typeIndex];
                        extModules = archive.getExtensionModules(type);
                        this.checkAddingConnectorType(type, extModules, options, previouslyAddedModules);
                        this.saveConnectorType(type);
                    }
                }
                type = connectorTypes[typeIndex];
                extModules = archive.getExtensionModules(type);
                this.checkAddingConnectorType(type, extModules, options, previouslyAddedModules);
            }
            for (ExtensionModule extModule : previouslyAddedModules) {
                this.addExtensionModule(extModule.getModuleType(), extModule.getFullName(), extModule.getFileContents(), extModule.getDescription());
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixProcessingException e) {
            throw new AdminProcessingException((Throwable)e);
        }
    }

    void checkAddingConnectorType(ConnectorBindingType type, ExtensionModule[] extModules, AdminOptions options, HashSet ignorableModules) throws MetaMatrixComponentException, MetaMatrixProcessingException, AdminException {
        for (int i = 0; i < extModules.length; ++i) {
            boolean add = true;
            String moduleName = extModules[i].getFullName();
            ExtensionModule previousModule = null;
            if (ignorableModules.contains(extModules[i])) continue;
            try {
                previousModule = this.getConfigurationService().getExtensionModule(moduleName);
            }
            catch (MetaMatrixComponentException e) {
                // empty catch block
            }
            if (previousModule != null && options.containsOption(4)) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.extension_module_exists", new Object[]{previousModule.getFullName()}));
            }
            if (previousModule != null && options.containsOption(2)) {
                add = false;
            } else if (previousModule != null && options.containsOption(1)) {
                this.deleteExtensionModule(previousModule.getFullName());
            }
            if (!add) continue;
            ignorableModules.add(extModules[i]);
        }
    }

    public byte[] exportConnectorArchive(String identifier) throws AdminException {
        try {
            if (identifier == null || !identifier.matches("\\w*((\\.)?\\s*\\w)*(\\*)?")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_name"));
            }
            BasicConnectorArchive archive = new BasicConnectorArchive();
            List connectorTypes = this.getConfigurationService().getConnectorTypes();
            for (ConnectorBindingType type : connectorTypes) {
                if (type == null || !this.matches(identifier, type.getName())) continue;
                archive.addConnectorType(type);
                String[] extModules = type.getExtensionModules();
                for (int m = 0; m < extModules.length; ++m) {
                    ExtensionModule extModule = this.getConfigurationService().getExtensionModule(extModules[m]);
                    if (extModule == null) {
                        throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("DataService.ext_module_not_found", new Object[]{extModules[m]}));
                    }
                    archive.addExtensionModule(type, extModule);
                }
            }
            if (archive.getConnectorTypes().length == 0) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_type_does_not_exists", new Object[]{identifier}));
            }
            return ConnectorConfigurationWriter.writeToByteArray((ConnectorArchive)archive);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    private void saveConnectorType(ConnectorBindingType type) throws MetaMatrixProcessingException, MetaMatrixComponentException {
        this.getConfigurationService().saveConnectorType(type);
    }

    public void addUDF(byte[] modelFileContents, String classpath) throws AdminException {
        if (modelFileContents == null || modelFileContents.length == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_UDF_contents"));
        }
        try {
            this.getConfigurationService().unloadUDF();
            try {
                this.deleteExtensionModule("FunctionDefinitions.xmi");
            }
            catch (AdminException e) {
                // empty catch block
            }
            this.addExtensionModule("Function Definition", "FunctionDefinitions.xmi", modelFileContents, "User Defined Functions File");
            String commonpath = this.getConfigurationService().getSystemProperties().getProperty("dqp.extension.CommonClasspath", "");
            StringBuilder sb = new StringBuilder();
            if (classpath != null && classpath.length() > 0) {
                StringTokenizer st = new StringTokenizer(classpath, ";");
                while (st.hasMoreTokens()) {
                    String partpath = st.nextToken();
                    if (commonpath.indexOf(partpath) != -1) continue;
                    sb.append(partpath).append(";");
                }
            }
            this.setSystemProperty("dqp.extension.CommonClasspath", sb.toString() + commonpath);
            Properties p = new Properties();
            p.setProperty("dqp.extension.CommonClasspath", classpath);
            this.getConfigurationService().updateSystemProperties(p);
            this.getConfigurationService().loadUDF();
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void deleteUDF() throws AdminException {
        try {
            this.getConfigurationService().unloadUDF();
            this.deleteExtensionModule("FunctionDefinitions.xmi");
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }
}

