/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.admin;

import com.metamatrix.admin.api.embedded.EmbeddedMonitoringAdmin;
import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.ConnectorBinding;
import com.metamatrix.admin.api.objects.SystemObject;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.admin.BaseAdmin;
import com.metamatrix.jdbc.EmbeddedConnectionFactoryImpl;
import com.metamatrix.server.serverapi.RequestInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DQPMonitoringAdminImpl
extends BaseAdmin
implements EmbeddedMonitoringAdmin {
    public DQPMonitoringAdminImpl(EmbeddedConnectionFactoryImpl manager) {
        super(manager);
    }

    @Override
    public Collection getConnectorTypes(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*((\\.)?\\s*\\w)*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        return super.getConnectorTypes(identifier);
    }

    public Collection getVDBs(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*(\\*)?(\\.\\d+)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        if (identifier.indexOf(".") == -1 && identifier.indexOf("*") == -1) {
            identifier = identifier + "." + "*";
        }
        try {
            List vdbs = this.getVDBService().getAvailableVDBs();
            ArrayList<VDBArchive> matchedVdbs = new ArrayList<VDBArchive>();
            for (VDBArchive vdb : vdbs) {
                if (!this.matches(identifier, vdb.getName() + "." + vdb.getVersion())) continue;
                matchedVdbs.add(vdb);
            }
            return (List)this.convertToAdminObjects(matchedVdbs);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    @Override
    public Collection getConnectorBindings(String identifier) throws AdminException {
        if (identifier == null) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        return super.getConnectorBindings(identifier);
    }

    public Collection getConnectorBindingsInVDB(String identifier) throws AdminException {
        List vdbs = null;
        HashMap bindings = new HashMap();
        if (identifier == null || !identifier.matches("\\w*(\\*)?(\\.\\d+)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        if (identifier.indexOf(".") == -1 && identifier.indexOf("*") == -1) {
            identifier = identifier + "*";
        }
        try {
            vdbs = this.getVDBService().getAvailableVDBs();
            for (VDBArchive vdb : vdbs) {
                if (!this.matches(identifier, vdb.getName() + "." + vdb.getVersion())) continue;
                Map connectorBindings = vdb.getConfigurationDef().getConnectorBindings();
                bindings.putAll(connectorBindings);
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        return (List)this.convertToAdminObjects(bindings.values());
    }

    public Collection getExtensionModules(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w+((\\.\\*)|(\\.\\w+)|(\\.\\w*\\*))*|\\w*(\\*){1}")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        try {
            List extModules = this.getConfigurationService().getExtensionModules();
            extModules = (List)this.convertToAdminObjects(extModules);
            return this.matchedCollection(identifier, extModules);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public Collection getQueueWorkerPools(String identifier) throws AdminException {
        Collection c;
        if (identifier == null || !identifier.matches("\\w*((\\.)?\\s*\\w)*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        ArrayList results = new ArrayList();
        if (this.matches(identifier, "dqp") && (c = this.manager.getDQP().getQueueStatistics()) != null && !c.isEmpty()) {
            results.addAll(c);
        }
        try {
            Collection bindings = super.getConnectorBindings(identifier);
            for (ConnectorBinding binding : bindings) {
                Collection c2 = this.getDataService().getConnectorBindingStatistics(binding.getName());
                if (c2 == null || c2.isEmpty()) continue;
                results.addAll(c2);
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        if (!results.isEmpty()) {
            return (List)this.convertToAdminObjects(results);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getCaches(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        ArrayList<String> cacheList = new ArrayList<String>();
        for (int i = 0; i < cacheTypes.length; ++i) {
            if (!this.matches(identifier, cacheTypes[i])) continue;
            cacheList.add(cacheTypes[i]);
        }
        return cacheList;
    }

    public Collection getSessions(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\d*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        ArrayList<ServerConnection> goodConections = new ArrayList<ServerConnection>();
        Set<ServerConnection> connections = this.getClientConnections();
        for (ServerConnection connection : connections) {
            if (!connection.isOpen()) continue;
            goodConections.add(connection);
        }
        return this.matchedCollection(identifier, (List)this.convertToAdminObjects(goodConections));
    }

    public Collection getRequests(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\d+((\\.\\*)|(\\.\\d+)|(\\.\\d*\\*))*|\\d*(\\*){1}")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        ArrayList<RequestInfo> requestList = new ArrayList<RequestInfo>();
        List requests = this.manager.getDQP().getRequests();
        for (RequestInfo request : requests) {
            if (request.getConnectorBindingUUID() != null) continue;
            requestList.add(request);
        }
        return this.matchedCollection(identifier, (List)this.convertToAdminObjects(requestList));
    }

    public Collection getSourceRequests(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\d+((\\.\\*)|(\\.\\d+)|(\\.\\d*\\*))*|\\d*(\\*){1}")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        ArrayList<RequestInfo> atomicRequestList = new ArrayList<RequestInfo>();
        List requests = this.manager.getDQP().getRequests();
        for (RequestInfo request : requests) {
            if (request.getConnectorBindingUUID() == null) continue;
            atomicRequestList.add(request);
        }
        return this.matchedCollection(identifier, (List)this.convertToAdminObjects(atomicRequestList));
    }

    @Override
    public SystemObject getSystem() {
        return super.getSystem();
    }

    public Collection getPropertyDefinitions(String identifier, String className) throws AdminException {
        Collection adminObjects = this.getAdminObjects(identifier, className);
        if (adminObjects == null || adminObjects.size() == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.No_Objects_Found", new Object[]{identifier, className}));
        }
        if (adminObjects.size() > 1) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Multiple_Objects_Found", new Object[]{identifier, className}));
        }
        AdminObject adminObject = (AdminObject)adminObjects.iterator().next();
        try {
            String objectIdentifier = adminObject.getIdentifier();
            ComponentType ctype = null;
            int type = MMAdminObject.getObjectType((String)className);
            switch (type) {
                case 19: {
                    Properties properties = this.manager.getProperties();
                    return this.convertPropertyDefinitions(properties);
                }
                case 2: {
                    String ctypeName = ((ConnectorBinding)adminObject).getConnectorTypeName();
                    ctype = this.getConfigurationService().getSystemConfiguration().getComponentType(ctypeName);
                    ConnectorBinding binding = (ConnectorBinding)this.getConnectorBindings(objectIdentifier).iterator().next();
                    return this.convertPropertyDefinitions(ctype, binding.getProperties());
                }
                case 3: {
                    ctype = this.getConfigurationService().getSystemConfiguration().getComponentType(adminObject.getName());
                    return this.convertPropertyDefinitions(ctype, new Properties());
                }
            }
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Unsupported_Object_Class", new Object[]{className}));
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }
}

