/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.admin;

import com.metamatrix.admin.api.embedded.EmbeddedLogger;
import com.metamatrix.admin.api.embedded.EmbeddedRuntimeStateAdmin;
import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.ConnectorBinding;
import com.metamatrix.admin.api.objects.Request;
import com.metamatrix.admin.objects.MMRequest;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.admin.BaseAdmin;
import com.metamatrix.dqp.embedded.admin.DQPLogListener;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.jdbc.EmbeddedConnectionFactoryImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class DQPRuntimeStateAdminImpl
extends BaseAdmin
implements EmbeddedRuntimeStateAdmin {
    public DQPRuntimeStateAdminImpl(EmbeddedConnectionFactoryImpl manager) {
        super(manager);
    }

    public void stop(int millisToWait) throws AdminException {
        try {
            this.terminateSession("*");
            this.getManager().shutdown();
        }
        catch (SQLException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void restart() throws AdminException {
        try {
            this.terminateSession("*");
            this.getManager().shutdown();
        }
        catch (SQLException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void startConnectorBinding(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*((\\.)?\\s*\\w)*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        AdminException exceptionWrapper = null;
        Collection bindings = this.getConnectorBindings(identifier);
        if (bindings != null && !bindings.isEmpty()) {
            Iterator i = bindings.iterator();
            while (i.hasNext()) {
                try {
                    AdminObject binding = (AdminObject)i.next();
                    this.getDataService().startConnectorBinding(binding.getName());
                }
                catch (ApplicationLifecycleException e) {
                    exceptionWrapper = this.accumulateSystemException(exceptionWrapper, (Exception)((Object)e));
                }
                catch (MetaMatrixComponentException e) {
                    exceptionWrapper = this.accumulateSystemException(exceptionWrapper, (Exception)((Object)e));
                }
            }
        } else {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_binding_does_not_exists", new Object[]{identifier}));
        }
        if (exceptionWrapper != null) {
            throw exceptionWrapper;
        }
    }

    public void stopConnectorBinding(String identifier, boolean stopNow) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*((\\.)?\\s*\\w)*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        AdminException exceptionWrapper = null;
        Collection bindings = this.getConnectorBindings(identifier);
        if (bindings != null && !bindings.isEmpty()) {
            Iterator i = bindings.iterator();
            while (i.hasNext()) {
                try {
                    AdminObject binding = (AdminObject)i.next();
                    this.getDataService().stopConnectorBinding(binding.getName());
                }
                catch (ApplicationLifecycleException e) {
                    exceptionWrapper = this.accumulateSystemException(exceptionWrapper, (Exception)((Object)e));
                }
                catch (MetaMatrixComponentException e) {
                    exceptionWrapper = this.accumulateSystemException(exceptionWrapper, (Exception)((Object)e));
                }
            }
        } else {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_binding_does_not_exists", new Object[]{identifier}));
        }
        if (exceptionWrapper != null) {
            throw exceptionWrapper;
        }
    }

    public void clearCache(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        boolean processed = false;
        for (int i = 0; i < cacheTypes.length; ++i) {
            if (!this.matches(identifier, cacheTypes[i])) continue;
            if (cacheTypes[i].equals("CodeTableCache")) {
                processed = true;
                this.manager.getDQP().clearCodeTableCache();
                continue;
            }
            if (cacheTypes[i].equals("PreparedPlanCache")) {
                processed = true;
                this.manager.getDQP().clearPlanCache();
                continue;
            }
            if (cacheTypes[i].equals("QueryServiceResultSetCache")) {
                processed = true;
                this.manager.getDQP().clearResultSetCache();
                continue;
            }
            if (!cacheTypes[i].equals("ConnectorResultSetCache")) continue;
            processed = true;
            try {
                Collection bindings = super.getConnectorBindings("*");
                for (ConnectorBinding binding : bindings) {
                    this.getDataService().clearConnectorBindingCache(binding.getName());
                }
                continue;
            }
            catch (MetaMatrixComponentException e) {
                throw new AdminComponentException((Throwable)e);
            }
        }
        if (!processed) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.invalid_request", new Object[]{identifier}));
        }
    }

    public void terminateSession(String identifier) throws AdminException {
        Set<ServerConnection> connections = this.getClientConnections();
        ArrayList<ServerConnection> matchedConnections = new ArrayList<ServerConnection>();
        for (ServerConnection clientConnection : connections) {
            String id = clientConnection.getLogonResult().getSessionID().toString();
            if (!this.matches(identifier, id)) continue;
            matchedConnections.add(clientConnection);
        }
        for (ServerConnection clientConnection : matchedConnections) {
            try {
                this.manager.getDQP().terminateConnection(clientConnection.getLogonResult().getSessionID().toString());
            }
            catch (MetaMatrixComponentException e) {
                throw new AdminComponentException((Throwable)e);
            }
            clientConnection.shutdown();
        }
    }

    public void cancelRequest(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\d+\\" + Request.DELIMITER + "\\d+")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        String[] identifierParts = MMRequest.buildIdentifierArray((String)identifier);
        String connId = identifierParts[0];
        long requestId = Long.parseLong(identifierParts[1]);
        RequestID id = new RequestID(connId, requestId);
        try {
            this.manager.getDQP().cancelRequest(id);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void cancelSourceRequest(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\d+\\" + Request.DELIMITER + "\\d+\\" + Request.DELIMITER + "\\d+")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        String[] identifierParts = MMRequest.buildIdentifierArray((String)identifier);
        String connId = identifierParts[0];
        long requestId = Long.parseLong(identifierParts[1]);
        int nodeId = Integer.parseInt(identifierParts[2]);
        RequestID id = new RequestID(connId, requestId);
        try {
            this.manager.getDQP().cancelAtomicRequest(id, nodeId);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void changeVDBStatus(String name, String version, int status) throws AdminException {
        try {
            if (name == null || version == null || !name.matches("\\w+")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_vdb_name"));
            }
            this.getVDBService().changeVDBStatus(name, version, status);
        }
        catch (ApplicationLifecycleException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void setLogListener(EmbeddedLogger listener) throws AdminException {
        if (listener == null) {
            throw new AdminProcessingException("Admin_invalid_log_listener");
        }
        LogManager.setLogListener((LogListener)new DQPLogListener(listener));
    }
}

