/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.core.util.ObjectConverterUtil;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class ConnectorConfigurationReader {
    private static final XMLConfigurationImportExportUtility UTIL = new XMLConfigurationImportExportUtility();

    public static ConnectorBinding loadConnectorBinding(String name, char[] contents) throws MetaMatrixComponentException {
        try {
            InputStream in = ObjectConverterUtil.convertToInputStream((String)new String(contents));
            return UTIL.importConnectorBinding(in, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor(), name);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public static ConnectorBinding loadConnectorBinding(String bindingName, Properties props, ConnectorBindingType type) throws MetaMatrixComponentException {
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(true);
        ConnectorBinding binding = editor.createConnectorComponent(Configuration.NEXT_STARTUP_ID, (ComponentTypeID)type.getID(), bindingName, null);
        return (ConnectorBinding)editor.modifyProperties((ComponentObject)binding, props, 0);
    }

    public static ConnectorBindingType loadConnectorType(char[] contents) throws MetaMatrixComponentException {
        InputStream in = ObjectConverterUtil.convertToInputStream((String)new String(contents));
        try {
            return (ConnectorBindingType)UTIL.importComponentType(in, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor(), null);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public static ConnectorArchive loadConnectorArchive(byte[] contents) throws MetaMatrixComponentException {
        InputStream in = ObjectConverterUtil.convertToInputStream((byte[])contents);
        try {
            return UTIL.importConnectorArchive(in, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor());
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public static ConnectorBinding addConnectorBindingProperty(ConnectorBinding binding, String propName, Object value) {
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor();
        Properties props = binding.getProperties();
        props.put(propName, value);
        editor.modifyProperties((ComponentObject)binding, props, 0);
        return binding;
    }

    public static ConnectorBinding addConnectorBindingProperties(ConnectorBinding binding, Properties properties) {
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor();
        Properties props = binding.getProperties();
        props.putAll((Map<?, ?>)properties);
        editor.modifyProperties((ComponentObject)binding, props, 0);
        return binding;
    }
}

