/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.model.BasicExtensionModule;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ExtensionModuleReader {
    private static final String MM_JAR_PROTOCOL = "extensionjar";

    public static ExtensionModule loadExtensionModule(String extModuleName, URL extModuleURL) throws MetaMatrixComponentException {
        byte[] contents = null;
        InputStream in = null;
        try {
            in = extModuleURL.openStream();
            contents = ByteArrayHelper.toByteArray((InputStream)in);
        }
        catch (FileNotFoundException e) {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("ExtensionModuleReader.ext_module_does_not_exist", new Object[]{extModuleName}));
        }
        catch (IOException e) {
            throw new MetaMatrixComponentException((Throwable)e, DQPEmbeddedPlugin.Util.getString("ExtensionModuleReader.ext_module_failed_to_read", new Object[]{extModuleName}));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return new BasicExtensionModule(extModuleName, "JAR File", "Jar File", contents);
    }

    public static List loadExtensionModules(URL extensionPathURL) throws MetaMatrixComponentException {
        ObjectInputStream in = null;
        ArrayList<BasicExtensionModule> extModuleList = new ArrayList<BasicExtensionModule>();
        String extensionPath = extensionPathURL.toString() + "?action=list&filter=.jar";
        try {
            extensionPathURL = URLHelper.buildURL((String)extensionPath);
            in = new ObjectInputStream(extensionPathURL.openStream());
            String[] jarFiles = (String[])in.readObject();
            for (int i = 0; i < jarFiles.length; ++i) {
                String jarName = jarFiles[i];
                jarName = jarName.substring(jarName.lastIndexOf(47) + 1);
                byte[] contents = null;
                try {
                    URL jarFileURL = URLHelper.buildURL((String)jarFiles[i]);
                    InputStream jarStream = jarFileURL.openStream();
                    contents = ByteArrayHelper.toByteArray((InputStream)jarStream);
                    jarStream.close();
                }
                catch (IOException e) {
                    throw new MetaMatrixComponentException((Throwable)e, DQPEmbeddedPlugin.Util.getString("ExtensionModuleReader.ext_module_failed_to_read", new Object[]{jarFiles[i]}));
                }
                extModuleList.add(new BasicExtensionModule(jarName, "JAR File", "Jar File", contents));
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return extModuleList;
    }

    public static URL[] resolveExtensionClasspath(String extClassPath, URL context) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(extClassPath, ";");
        while (st.hasMoreTokens()) {
            URL entry = null;
            String temp = st.nextToken();
            int idx = temp.indexOf(MM_JAR_PROTOCOL);
            if (idx != -1) {
                entry = URLHelper.buildURL((URL)context, (String)temp.substring(idx + MM_JAR_PROTOCOL.length() + 1));
                InputStream in = null;
                try {
                    in = entry.openStream();
                    in.close();
                }
                catch (IOException e) {
                    LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPEmbeddedPlugin.Util.getString("DataService.ext_module_not_found", new Object[]{entry})});
                }
            } else {
                entry = new URL(temp);
            }
            urls.add(entry);
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

