/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class ExtensionModuleWriter {
    public static void write(ExtensionModule extModule, URL extModuleURL) throws MetaMatrixComponentException {
        OutputStream out = null;
        try {
            String extFile = extModuleURL.toString() + "?action=write";
            extModuleURL = URLHelper.buildURL((String)extFile);
            URLConnection conn = extModuleURL.openConnection();
            out = conn.getOutputStream();
            out.write(extModule.getFileContents());
            DQPEmbeddedPlugin.logInfo("ExtensionModuleWriter.ext_module_save", new Object[]{extModule.getFullName(), extModuleURL});
        }
        catch (IOException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void deleteModule(URL extModuleURL) throws MetaMatrixComponentException {
        String extensionPath = extModuleURL.toString() + "?action=delete";
        InputStream in = null;
        try {
            extModuleURL = URLHelper.buildURL((String)extensionPath);
            in = extModuleURL.openStream();
            if (in != null) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("ExtensionModuleWriter.ext_module_delete_failed", new Object[]{extModuleURL}));
            }
            DQPEmbeddedPlugin.logInfo("ExtensionModuleWriter.ext_module_delete", new Object[]{extModuleURL.getPath(), extModuleURL});
        }
        catch (FileNotFoundException e) {
            DQPEmbeddedPlugin.logInfo("ExtensionModuleWriter.ext_module_delete", new Object[]{extModuleURL.getPath(), extModuleURL});
        }
        catch (IOException e) {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("ExtensionModuleWriter.ext_module_delete_failed", new Object[]{extModuleURL}));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

