/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.ConfigurationModelContainerAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ServerConfigFileReader {
    private static final String QUERY_SERVICE = "QueryService";
    private Properties properties = new Properties();
    private Map connectorBindings = new HashMap();
    private Map connectorTypes = new HashMap();
    private ConfigurationModelContainer configuration = null;

    public ServerConfigFileReader(URL configFile) throws IOException {
        this.loadConfigFile(configFile);
    }

    private void loadConfigFile(URL configFile) throws IOException {
        InputStream in = null;
        try {
            in = configFile.openStream();
            ConfigurationModelContainerAdapter configAdapter = new ConfigurationModelContainerAdapter();
            this.configuration = configAdapter.readConfigurationModel(in, Configuration.NEXT_STARTUP_ID);
            Properties globalProps = this.configuration.getConfiguration().getProperties();
            Properties qs = this.configuration.getConfiguration().getServiceComponentDefn(QUERY_SERVICE).getProperties();
            this.properties.putAll((Map<?, ?>)globalProps);
            this.properties.putAll((Map<?, ?>)qs);
            Collection componentTypes = this.configuration.getComponentTypes().values();
            for (ComponentType type : componentTypes) {
                if (type.getComponentTypeCode() != 2) continue;
                this.connectorTypes.put(type.getName(), type);
            }
            Collection bindings = this.configuration.getConfiguration().getConnectorBindings();
            for (ConnectorBinding binding : bindings) {
                this.connectorBindings.put(binding.getFullName(), binding);
            }
        }
        catch (ConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public Properties getSystemProperties() {
        return this.properties;
    }

    public Map getConnectorBindings() {
        return this.connectorBindings;
    }

    public ConfigurationModelContainer getConfiguration() {
        return this.configuration;
    }

    public Map getConnectorTypes() {
        return this.connectorTypes;
    }
}

