/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.core.util.ObjectConverterUtil;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VDBConfigurationReader {
    private static final String VDB = ".vdb";
    private static final String DEF = ".def";

    public static VDBArchive loadVDB(String name, char[] defContents, byte[] vdbContents) throws MetaMatrixComponentException {
        if (defContents == null || vdbContents == null) {
            throw new IllegalArgumentException("VDB Content provided can not be null");
        }
        VDBArchive archive = null;
        try {
            InputStream defStream = ObjectConverterUtil.convertToInputStream((String)new String(defContents));
            BasicVDBDefn def = VDBArchive.readFromDef((InputStream)defStream);
            if (name != null) {
                def.setName(name);
            }
            archive = new VDBArchive((InputStream)new ByteArrayInputStream(vdbContents));
            archive.updateConfigurationDef(def);
            return archive;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public static VDBArchive loadVDB(String name, byte[] vdbContents) throws MetaMatrixComponentException {
        if (vdbContents == null) {
            throw new IllegalArgumentException("VDB Content provided can not be null");
        }
        try {
            VDBArchive archive = new VDBArchive((InputStream)new ByteArrayInputStream(vdbContents));
            archive.getConfigurationDef().setName(name);
            archive.updateConfigurationDef(archive.getConfigurationDef());
            return archive;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public static VDBArchive loadVDB(URL vdbURL) throws MetaMatrixComponentException {
        String vdblocation = vdbURL.toString().toLowerCase();
        if (vdblocation.endsWith(VDB) || vdblocation.endsWith(DEF)) {
            try {
                BasicVDBDefn def = null;
                if (vdblocation.endsWith(DEF)) {
                    def = VDBArchive.readFromDef((InputStream)vdbURL.openStream());
                    String vdbName = def.getFileName();
                    vdbURL = URLHelper.buildURL((URL)vdbURL, (String)vdbName);
                }
                VDBArchive vdb = new VDBArchive(vdbURL.openStream());
                if (def != null) {
                    vdb.updateConfigurationDef(def);
                }
                if (vdb.getVDBValidityErrors() != null) {
                    String[] errors = vdb.getVDBValidityErrors();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < errors.length; ++i) {
                        sb.append("-").append(errors[i]).append(";");
                    }
                    DQPEmbeddedPlugin.logError("VDBReader.validityErrors", new Object[]{vdbURL, sb});
                }
                return vdb;
            }
            catch (Exception e) {
                DQPEmbeddedPlugin.logWarning(e, "VDBReader.Archive_not_Found", new Object[]{vdbURL});
                throw new MetaMatrixComponentException((Throwable)e);
            }
        }
        throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBReader.Invalid_location", new Object[]{vdbURL}));
    }

    public static HashMap<URL, VDBArchive> loadVDBS(URL[] urls) throws MetaMatrixComponentException {
        HashMap<URL, VDBArchive> vdbs = new HashMap<URL, VDBArchive>();
        ArrayList<URL> vdbURLs = new ArrayList<URL>();
        for (int i = 0; i < urls.length; ++i) {
            String vdblocation = urls[i].toString().toLowerCase();
            if (vdblocation.endsWith(VDB) || vdblocation.endsWith(DEF)) {
                vdbURLs.add(urls[i]);
                continue;
            }
            vdbURLs.addAll(VDBConfigurationReader.getVDBResources(urls[i]));
        }
        for (URL vdbURL : vdbURLs) {
            VDBArchive vdb = VDBConfigurationReader.loadVDB(vdbURL);
            if (vdb.getVDBValidityErrors() != null) continue;
            vdbs.put(vdbURL, vdb);
        }
        return vdbs;
    }

    static List getVDBResources(URL vdbRepositoryURL) throws MetaMatrixComponentException {
        ObjectInputStream in = null;
        ArrayList<URL> urlList = new ArrayList<URL>();
        String vdblocation = vdbRepositoryURL.toString() + "?action=list&filter=.vdb,.def";
        try {
            vdbRepositoryURL = URLHelper.buildURL((String)vdblocation);
            in = new ObjectInputStream(vdbRepositoryURL.openStream());
            String[] urls = (String[])in.readObject();
            for (int i = 0; i < urls.length; ++i) {
                boolean add = true;
                URL vdbFileURL = URLHelper.buildURL((String)urls[i]);
                if (!add) continue;
                urlList.add(vdbFileURL);
            }
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

