/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class VDBConfigurationWriter {
    private static final String DEF = ".def";

    public static void write(VDBArchive vdb, URL vdbFileURL) throws MetaMatrixComponentException {
        OutputStream out = null;
        try {
            String vdbFile = vdbFileURL.toString() + "?action=write";
            vdbFileURL = URLHelper.buildURL((String)vdbFile);
            URLConnection conn = vdbFileURL.openConnection();
            out = conn.getOutputStream();
            vdb.write(out);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static Properties getPropertiesForExporting() {
        Properties properties = new Properties();
        properties.put("ApplicationCreatedBy", "EmbeddedAdmin");
        properties.put("ApplicationVersion", "4.3");
        properties.put("UserCreatedBy", "dqpadmin");
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteVDB(VDBArchive vdb, URL url) throws MetaMatrixComponentException {
        String urlPath = url.toString() + "?action=delete";
        InputStream in = null;
        try {
            url = URLHelper.buildURL((String)urlPath);
            in = url.openStream();
            if (in != null) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBConfigurationWriter.vdb_delete_failed", new Object[]{vdb.getName(), vdb.getVersion()}));
            }
        }
        catch (IOException e) {
            DQPEmbeddedPlugin.logInfo("VDBConfigurationWriter.vdb_delete", new Object[]{vdb.getName(), vdb.getVersion()});
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (url.getPath().endsWith(DEF)) {
            try {
                BasicVDBDefn def = vdb.getConfigurationDef();
                url = URLHelper.buildURL((URL)url, (String)def.getFileName());
                urlPath = url.toString() + "?action=delete";
                url = URLHelper.buildURL((String)urlPath);
                in = url.openStream();
                if (in != null) {
                    throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBConfigurationWriter.vdb_delete_failed", new Object[]{vdb.getName(), vdb.getVersion()}));
                }
            }
            catch (IOException e) {
                DQPEmbeddedPlugin.logInfo("VDBConfigurationWriter.vdb_delete", new Object[]{vdb.getName(), vdb.getVersion()});
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

