/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.util.Collection;
import java.util.Properties;

public abstract class EmbeddedBaseDQPService
implements ApplicationService {
    public static final String SYSTEM_PHYSICAL_MODEL_NAME = "SystemPhysical";
    private boolean started = false;
    private boolean initialized = false;
    private ApplicationEnvironment environment;

    public final void initialize(Properties props) throws ApplicationInitializationException {
        if (!this.initialized) {
            this.initialized = true;
            this.initializeService(props);
        }
    }

    public abstract void initializeService(Properties var1) throws ApplicationInitializationException;

    public final void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        if (!this.started) {
            this.started = true;
            this.environment = environment;
            this.startService(environment);
        }
    }

    public abstract void startService(ApplicationEnvironment var1) throws ApplicationLifecycleException;

    public final void stop() throws ApplicationLifecycleException {
        if (this.started) {
            this.started = false;
            this.stopService();
        }
    }

    public abstract void stopService() throws ApplicationLifecycleException;

    protected ApplicationService lookupService(String serviceName) {
        if (this.environment == null) {
            throw new IllegalStateException("Service " + this.getClass().getName() + " not started");
        }
        return this.environment.findService(serviceName);
    }

    protected ConfigurationService getConfigurationService() {
        return (ConfigurationService)this.lookupService("dqp.configuration");
    }

    protected final boolean isStarted() {
        return this.started;
    }

    protected String vdbId(VDBArchive vdb) {
        return this.vdbId(vdb.getName(), vdb.getVersion());
    }

    protected String vdbId(String name, String version) {
        return name.toUpperCase() + "_" + version;
    }

    protected boolean isValidVDB(VDBArchive vdb) {
        if (vdb.getVDBValidityErrors() != null) {
            String[] errors = vdb.getVDBValidityErrors();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < errors.length; ++i) {
                sb.append("-").append(errors[i]).append(";");
            }
            DQPEmbeddedPlugin.logError("VDBService.validityErrors", new Object[]{vdb.getName(), sb});
            return false;
        }
        BasicVDBDefn def = vdb.getConfigurationDef();
        Collection models = def.getModels();
        if (models != null && models.isEmpty()) {
            DQPEmbeddedPlugin.logError("VDBService.vdb_missing_models", new Object[]{vdb.getName(), vdb.getVersion()});
            return false;
        }
        return true;
    }
}

