/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.StorageManager;
import com.metamatrix.common.buffer.impl.BufferManagerImpl;
import com.metamatrix.common.buffer.storage.file.FileStorageManager;
import com.metamatrix.common.buffer.storage.memory.MemoryStorageManager;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.service.BufferService;
import com.metamatrix.dqp.service.ConfigurationService;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class EmbeddedBufferService
extends EmbeddedBaseDQPService
implements BufferService {
    private static final String DEFAULT_MANAGEMENT_INTERVAL = "0";
    private static final String DEFAULT_LOG_STATS_INTERVAL = "0";
    private static final String DEFAULT_SESSION_USE_PERCENTAGE = "100";
    private static final String DEFAULT_ID_CREATOR = "com.metamatrix.common.buffer.impl.LongIDCreator";
    private static final String DEFAULT_MAX_OPEN_FILES = "10";
    private BufferManager bufferMgr;
    private File bufferDir;

    @Override
    public void initializeService(Properties props) throws ApplicationInitializationException {
    }

    void cleanDirectory(File file) {
        if (file.exists()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    @Override
    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        try {
            ConfigurationService configurationSvc = this.getConfigurationService();
            boolean useDisk = configurationSvc.useDiskBuffering();
            this.bufferDir = configurationSvc.getDiskBufferDirectory();
            String memAvail = configurationSvc.getBufferMemorySize();
            String processorBatchSize = configurationSvc.getProcessorBatchSize();
            String connectorBatchSize = configurationSvc.getConnectorBatchSize();
            Properties bufferProps = new Properties();
            bufferProps.setProperty("metamatrix.buffer.idCreator", DEFAULT_ID_CREATOR);
            bufferProps.setProperty("metamatrix.buffer.sessionUsePercentage", DEFAULT_SESSION_USE_PERCENTAGE);
            bufferProps.setProperty("metamatrix.buffer.logStatsInterval", "0");
            bufferProps.setProperty("metamatrix.buffer.managementInterval", "0");
            bufferProps.setProperty("metamatrix.buffer.memoryAvailable", memAvail);
            bufferProps.setProperty("metamatrix.buffer.storageDirectory", this.bufferDir.getCanonicalPath());
            bufferProps.setProperty("metamatrix.buffer.processorBatchSize", processorBatchSize);
            bufferProps.setProperty("metamatrix.buffer.connectorBatchSize", connectorBatchSize);
            this.bufferMgr = new BufferManagerImpl();
            this.bufferMgr.initialize("local", bufferProps);
            if (useDisk) {
                Properties fsmProps = new Properties();
                fsmProps.setProperty("metamatrix.buffer.storageDirectory", this.bufferDir.getCanonicalPath());
                fsmProps.setProperty("metamatrix.buffer.maxOpenFiles", DEFAULT_MAX_OPEN_FILES);
                FileStorageManager fsm = new FileStorageManager();
                fsm.initialize(fsmProps);
                this.bufferMgr.addStorageManager((StorageManager)fsm);
                this.cleanDirectory(this.bufferDir);
            }
            this.bufferMgr.addStorageManager((StorageManager)new MemoryStorageManager());
        }
        catch (MetaMatrixComponentException e) {
            throw new ApplicationLifecycleException((Throwable)e, DQPEmbeddedPlugin.Util.getString("LocalBufferService.Failed_initializing_buffer_manager._8"));
        }
        catch (IOException e) {
            throw new ApplicationLifecycleException((Throwable)e, DQPEmbeddedPlugin.Util.getString("LocalBufferService.Failed_initializing_buffer_manager._8"));
        }
    }

    @Override
    public void stopService() throws ApplicationLifecycleException {
        this.bufferMgr.stop();
        if (this.bufferDir != null) {
            this.cleanDirectory(this.bufferDir);
            this.bufferDir.delete();
        }
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }
}

