/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionListener;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.model.BasicComponentType;
import com.metamatrix.common.config.model.BasicConnectorBinding;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.configuration.ExtensionModuleReader;
import com.metamatrix.dqp.embedded.configuration.ExtensionModuleWriter;
import com.metamatrix.dqp.embedded.configuration.ServerConfigFileReader;
import com.metamatrix.dqp.embedded.configuration.ServerConfigFileWriter;
import com.metamatrix.dqp.embedded.configuration.VDBConfigurationReader;
import com.metamatrix.dqp.embedded.configuration.VDBConfigurationWriter;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.ConnectorBindingLifeCycleListener;
import com.metamatrix.dqp.service.VDBLifeCycleListener;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.function.FunctionMetadataSource;
import com.metamatrix.query.function.UDFSource;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class EmbeddedConfigurationService
extends EmbeddedBaseDQPService
implements ConfigurationService {
    private static final String VDB_LIST_SEPARATOR = ";";
    private static final String VDB = ".vdb";
    private static final String DEF = ".def";
    Properties userPreferences;
    private Map<String, VDBArchive> loadedVDBs = new HashMap<String, VDBArchive>();
    Map<String, ConnectorBinding> loadedConnectorBindings = new HashMap<String, ConnectorBinding>();
    Map<String, ComponentType> loadedConnectorTypes = new HashMap<String, ComponentType>();
    private Map<String, URL> availableVDBFiles = new HashMap<String, URL>();
    ConfigurationModelContainer configurationModel;
    private Map<String, Integer> inuseVDBs = new HashMap<String, Integer>();
    private ArrayList<VDBLifeCycleListener> vdbLifeCycleListeners = new ArrayList();
    private ArrayList<ConnectorBindingLifeCycleListener> connectorBindingLifeCycleListeners = new ArrayList();
    private UDFSource udfSource;
    private HashSet<ServerConnection> clientConnections = new HashSet();

    boolean valid(String str) {
        if (str != null) {
            return (str = str.trim()).length() > 0;
        }
        return false;
    }

    public URL getSystemVdb() {
        String systemVDB = this.userPreferences.getProperty("dqp.metadata.systemURL");
        if (this.valid(systemVDB)) {
            return this.getFullyQualifiedPath(systemVDB);
        }
        return Thread.currentThread().getContextClassLoader().getResource("System.vdb");
    }

    public Properties getSystemProperties() {
        return this.userPreferences;
    }

    public void setSystemProperty(String key, String value) throws MetaMatrixComponentException {
        this.userPreferences.setProperty(key, value);
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.add_system_property", new Object[]{key, value});
        this.configurationModel = ServerConfigFileWriter.addProperty(this.getSystemConfiguration(), key, value);
        this.saveSystemConfiguration(this.configurationModel);
    }

    public void updateSystemProperties(Properties properties) throws MetaMatrixComponentException {
        this.userPreferences.putAll((Map<?, ?>)properties);
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.update_system_properties", new Object[]{properties});
        this.configurationModel = ServerConfigFileWriter.addProperties(this.getSystemConfiguration(), properties);
        this.saveSystemConfiguration(this.configurationModel);
    }

    public ConfigurationModelContainer getSystemConfiguration() throws MetaMatrixComponentException {
        if (this.configurationModel == null) {
            try {
                URL configFile = this.getConfigFile();
                ServerConfigFileReader configReader = new ServerConfigFileReader(configFile);
                this.configurationModel = configReader.getConfiguration();
            }
            catch (IOException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
        }
        return this.configurationModel;
    }

    void saveSystemConfiguration(ConfigurationModelContainer model) throws MetaMatrixComponentException {
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.savingConfiguration", null);
        URL configFile = this.getConfigFile();
        ServerConfigFileWriter.write(model, configFile);
    }

    public URL getConfigFile() {
        String configFile = this.userPreferences.getProperty("dqp.configFile", "configuration.xml");
        if (this.valid(configFile)) {
            return this.getFullyQualifiedPath(configFile);
        }
        return null;
    }

    public URL getUDFFile() {
        String udfFile = this.userPreferences.getProperty("dqp.userDefinedFunctionsFile");
        if (this.valid(udfFile)) {
            return this.getFullyQualifiedPath(udfFile);
        }
        try {
            return this.getFullyQualifiedPath(this.getDefaultExtensionPath(), "FunctionDefinitions.xmi");
        }
        catch (MetaMatrixComponentException e) {
            return null;
        }
    }

    public URL[] getCommonExtensionClasspath() {
        String classpath = this.userPreferences.getProperty("dqp.extension.CommonClasspath");
        if (this.valid(classpath)) {
            try {
                URL context = this.getExtensionPath();
                return ExtensionModuleReader.resolveExtensionClasspath(classpath, context);
            }
            catch (IOException e) {
                DQPEmbeddedPlugin.logError(e, "EmbeddedConfigurationService.udf_classspath_failure", new Object[0]);
            }
        } else {
            try {
                StringBuffer sb = new StringBuffer();
                List extModules = this.getExtensionModules();
                boolean valid = false;
                for (ExtensionModule module : extModules) {
                    sb.append("extensionjar:").append(module.getFullName()).append(VDB_LIST_SEPARATOR);
                    valid = true;
                }
                if (valid) {
                    URL context = this.getExtensionPath();
                    return ExtensionModuleReader.resolveExtensionClasspath(sb.toString(), context);
                }
            }
            catch (MetaMatrixComponentException e) {
            }
            catch (IOException e) {
                DQPEmbeddedPlugin.logError(e, "EmbeddedConfigurationService.udf_classspath_failure", new Object[0]);
            }
        }
        return null;
    }

    public URL getLogFile() {
        String logFile = this.userPreferences.getProperty("dqp.logFile");
        if (this.valid(logFile)) {
            return this.getFullyQualifiedPath(logFile);
        }
        return null;
    }

    public String getLogLevel() {
        String level = this.userPreferences.getProperty("dqp.logLevel");
        if (level == null) {
            level = "3";
        }
        return level;
    }

    public List<VDBArchive> getVDBs() throws MetaMatrixComponentException {
        return new ArrayList<VDBArchive>(this.loadedVDBs.values());
    }

    public VDBArchive getVDB(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        return this.loadedVDBs.get(this.vdbId(vdbName, vdbVersion));
    }

    URL getVDBLocation(VDBArchive vdb) throws MetaMatrixComponentException {
        URL vdbFile;
        if (this.availableVDBFiles != null && this.availableVDBFiles.size() > 0 && (vdbFile = this.availableVDBFiles.get(this.vdbId(vdb))) != null) {
            return vdbFile;
        }
        String vdbName = vdb.getName() + "_" + vdb.getVersion() + VDB;
        URL fileToSave = this.getFullyQualifiedPath(this.getVDBSaveLocation(), vdbName);
        BasicVDBDefn def = vdb.getConfigurationDef();
        def.setFileName(vdbName);
        this.updateDef(def, vdb);
        return fileToSave;
    }

    URL getVDBSaveLocation() throws MetaMatrixComponentException {
        URL[] urls = this.getVDBLocations();
        for (int i = 0; i < urls.length; ++i) {
            String vdblocation = urls[i].toString().toLowerCase();
            if (vdblocation.endsWith(VDB) || vdblocation.endsWith(DEF)) continue;
            return urls[i];
        }
        return urls[0];
    }

    private void updateDef(BasicVDBDefn def, VDBArchive vdb) throws MetaMatrixComponentException {
        try {
            vdb.updateConfigurationDef(def);
        }
        catch (IOException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public void saveVDB(VDBArchive srcVdb, String version) throws MetaMatrixComponentException {
        if (srcVdb.getStatus() == 4 && this.canDeleteVDB(srcVdb)) {
            this.deleteVDB(srcVdb);
            return;
        }
        BasicVDBDefn def = srcVdb.getConfigurationDef();
        if (version.equals("NEXT_VDB_VERSION")) {
            String nextVersion = Integer.toString(this.getNextVdbVersion(def.getName()));
            def.setVersion(nextVersion);
            String archiveFileName = def.getFileName();
            int index = archiveFileName.indexOf(46);
            if (index != -1) {
                archiveFileName = archiveFileName.substring(0, index) + "_" + nextVersion + VDB;
            }
            def.setFileName(archiveFileName);
            this.updateDef(def, srcVdb);
        }
        URL vdbFile = this.getVDBLocation(srcVdb);
        VDBConfigurationWriter.write(srcVdb, vdbFile);
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.vdb_saved", new Object[]{def.getName(), def.getVersion(), vdbFile});
        if (this.loadedVDBs.get(this.vdbId(srcVdb)) == null) {
            this.notifyVDBLoad(def.getName(), def.getVersion());
        }
        this.loadedVDBs.put(this.vdbId(srcVdb), srcVdb);
        this.availableVDBFiles.put(this.vdbId(srcVdb), vdbFile);
    }

    public VDBArchive addVDB(VDBArchive vdb, boolean replaceBindings) throws MetaMatrixComponentException {
        if (vdb != null) {
            boolean exists = false;
            if (!this.isValidVDB(vdb)) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.invalid_vdb", new Object[]{vdb.getName()}));
            }
            VDBArchive existingVdb = this.getVDB(vdb.getName(), vdb.getVersion());
            if (existingVdb != null) {
                exists = true;
                DQPEmbeddedPlugin.logWarning("VDBService.vdb_already_exists", new Object[]{existingVdb.getName(), existingVdb.getVersion()});
            }
            this.addConnectorTypesInVDB(vdb, replaceBindings);
            this.addConnectorBindingsInVDB(vdb, replaceBindings);
            this.saveVDB(vdb, exists ? "NEXT_VDB_VERSION" : vdb.getVersion());
            if (!this.isFullyConfiguredVDB(vdb)) {
                vdb.setStatus((short)1);
            } else {
                vdb.setStatus((short)3);
                DQPEmbeddedPlugin.logInfo("VDBService.vdb_active", new Object[]{vdb.getName(), vdb.getVersion()});
            }
            DQPEmbeddedPlugin.logInfo("VDBService.vdb_deployed", new Object[]{vdb.getName(), vdb.getVersion()});
            return vdb;
        }
        throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.failed_load"));
    }

    void addConnectorBindingsInVDB(VDBArchive vdb, boolean replace) throws MetaMatrixComponentException {
        BasicVDBDefn def = vdb.getConfigurationDef();
        Collection bindings = def.getConnectorBindings().values();
        for (ConnectorBinding binding : bindings) {
            ConnectorBinding existing;
            String deployedBindingName = binding.getDeployedName();
            if (deployedBindingName == null) {
                deployedBindingName = binding.getFullName();
            }
            if ((existing = this.getConnectorBinding(deployedBindingName)) == null || replace) {
                this.saveConnectorBinding(deployedBindingName, binding);
                continue;
            }
            def.addConnectorBinding(existing);
            this.updateDef(def, vdb);
        }
    }

    void addConnectorTypesInVDB(VDBArchive vdb, boolean replace) throws MetaMatrixComponentException {
        BasicVDBDefn def = vdb.getConfigurationDef();
        Map types = def.getConnectorTypes();
        for (String typeName : types.keySet()) {
            ConnectorBindingType localType = this.getConnectorType(typeName);
            if (localType != null && !replace) continue;
            ConnectorBindingType type = (ConnectorBindingType)types.get(typeName);
            this.saveConnectorType(type);
        }
    }

    int getNextVdbVersion(String vdbName) {
        int latestVersion = 0;
        for (VDBArchive vdb : this.loadedVDBs.values()) {
            if (!vdb.getName().equals(vdbName)) continue;
            latestVersion = Math.max(latestVersion, Integer.parseInt(vdb.getVersion()));
        }
        return latestVersion + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVDB(VDBArchive vdb) throws MetaMatrixComponentException {
        try {
            URL vdbFile = this.getVDBLocation(vdb);
            VDBConfigurationWriter.deleteVDB(vdb, vdbFile);
            this.notifyVDBUnLoad(vdb.getName(), vdb.getVersion());
            this.loadedVDBs.remove(this.vdbId(vdb));
            this.availableVDBFiles.remove(this.vdbId(vdb));
            BasicVDBDefn def = vdb.getConfigurationDef();
            this.deleteOrphanedConnectorBindings(def.getConnectorBindings().values());
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.vdb_delete", new Object[]{vdb.getName(), vdb.getVersion()});
        }
        finally {
            vdb.close();
        }
    }

    private void deleteOrphanedConnectorBindings(Collection connectorBindings) throws MetaMatrixComponentException {
        for (ConnectorBinding binding : connectorBindings) {
            List<VDBArchive> vdbs = this.getVdbsThatUseConnectorBinding(binding.getDeployedName());
            if (vdbs != null && !vdbs.isEmpty()) continue;
            this.deleteConnectorBinding(binding.getDeployedName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assignConnectorBinding(String vdbName, String version, String modelName, ConnectorBinding[] bindings) throws MetaMatrixComponentException {
        ConnectorBinding binding = bindings[0];
        VDBArchive vdb = this.getVDB(vdbName, version);
        BasicVDBDefn def = vdb.getConfigurationDef();
        if (binding == null || def == null) throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.VDB_does_not_exist._2", new Object[]{vdbName, version}));
        BasicModelInfo model = (BasicModelInfo)def.getModel(modelName);
        if (model == null) throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.VDB_does_not_exist._3", new Object[]{vdbName, version, modelName}));
        ArrayList<String> newBindingNames = new ArrayList<String>();
        for (int i = 0; i < bindings.length; ++i) {
            ConnectorBinding tgtBinding = bindings[i];
            newBindingNames.add(tgtBinding.getFullName());
            ConnectorBindingType type = this.getConnectorType(tgtBinding.getComponentTypeID().getName());
            def.addConnectorType((ComponentType)type);
            def.addConnectorBinding(model.getName(), tgtBinding);
        }
        model.setConnectorBindingNames(newBindingNames);
        ArrayList<ConnectorBinding> orphanBindings = new ArrayList<ConnectorBinding>();
        Map currentBindings = def.getConnectorBindings();
        for (ConnectorBinding currentBinding : currentBindings.values()) {
            if (def.isBindingInUse(currentBinding)) continue;
            def.removeConnectorBinding(currentBinding.getFullName());
            orphanBindings.add(currentBinding);
        }
        this.updateDef(def, vdb);
        this.saveVDB(vdb, vdb.getVersion());
        this.deleteOrphanedConnectorBindings(orphanBindings);
        DQPEmbeddedPlugin.logInfo("VDBService.connector_binding_changed", new Object[]{vdbName, version, modelName, newBindingNames});
    }

    public List getConnectorBindings() throws MetaMatrixComponentException {
        return new ArrayList<ConnectorBinding>(this.loadedConnectorBindings.values());
    }

    public ConnectorBinding getConnectorBinding(String deployedBindingName) throws MetaMatrixComponentException {
        return this.loadedConnectorBindings.get(deployedBindingName);
    }

    public Properties getDefaultProperties(ConnectorBinding binding) {
        ComponentTypeID id = binding.getComponentTypeID();
        return this.configurationModel.getDefaultPropertyValues(id);
    }

    List<VDBArchive> getVdbsThatUseConnectorBinding(String deployedBindingName) {
        ArrayList<VDBArchive> list = new ArrayList<VDBArchive>();
        for (VDBArchive vdb : this.loadedVDBs.values()) {
            BasicVDBDefn def = vdb.getConfigurationDef();
            Collection bindings = def.getConnectorBindings().values();
            for (ConnectorBinding deployedBinding : bindings) {
                if (!deployedBinding.getDeployedName().equals(deployedBindingName)) continue;
                list.add(vdb);
            }
        }
        return list;
    }

    public ConnectorBinding addConnectorBinding(String deployedBindingName, ConnectorBinding binding, boolean replace) throws MetaMatrixComponentException {
        boolean add = true;
        ConnectorBinding existingBinding = this.getConnectorBinding(deployedBindingName);
        if (existingBinding != null) {
            if (replace) {
                DQPEmbeddedPlugin.logInfo("DataService.Connector_exists_replace", new Object[]{existingBinding.getDeployedName()});
                if (!this.getVdbsThatUseConnectorBinding(existingBinding.getDeployedName()).isEmpty()) {
                    this.notifyConnectorBindingUnLoad(existingBinding.getDeployedName());
                } else {
                    this.deleteConnectorBinding(existingBinding.getDeployedName());
                }
            } else {
                add = false;
                DQPEmbeddedPlugin.logInfo("DataService.Connector_exists", new Object[]{existingBinding.getDeployedName()});
            }
        }
        if (add) {
            String typeName = binding.getComponentTypeID().getName();
            ConnectorBindingType type = this.getConnectorType(typeName);
            if (type != null) {
                binding = this.saveConnectorBinding(deployedBindingName, binding);
                DQPEmbeddedPlugin.logInfo("DataService.Connector_Added", new Object[]{binding.getDeployedName()});
                return binding;
            }
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("DataService.Connector_type_does_not_exists", new Object[]{typeName}));
        }
        return binding;
    }

    public ConnectorBinding updateConnectorBinding(ConnectorBinding binding) throws MetaMatrixComponentException {
        return this.saveConnectorBinding(binding.getDeployedName(), binding);
    }

    ConnectorBinding saveConnectorBinding(String deployedBindingName, ConnectorBinding binding) throws MetaMatrixComponentException {
        if (binding != null) {
            boolean used;
            binding = this.deployConnectorBinding(deployedBindingName, binding);
            List<VDBArchive> usedVDBs = this.getVdbsThatUseConnectorBinding(deployedBindingName);
            boolean bl = used = usedVDBs != null && !usedVDBs.isEmpty();
            if (used) {
                for (VDBArchive vdb : usedVDBs) {
                    BasicVDBDefn def = vdb.getConfigurationDef();
                    def.addConnectorBinding(binding);
                    this.updateDef(def, vdb);
                    this.saveVDB(vdb, vdb.getVersion());
                }
            }
            this.configurationModel = ServerConfigFileWriter.addConnectorBinding(this.configurationModel, binding);
            this.saveSystemConfiguration(this.configurationModel);
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connector_save", new Object[]{deployedBindingName});
        }
        return binding;
    }

    public void deleteConnectorBinding(String deployedConnectorBindingName) throws MetaMatrixComponentException {
        ConnectorBinding binding = this.getConnectorBinding(deployedConnectorBindingName);
        if (binding != null) {
            boolean used;
            List<VDBArchive> usedVDBs = this.getVdbsThatUseConnectorBinding(binding.getDeployedName());
            boolean bl = used = usedVDBs != null && !usedVDBs.isEmpty();
            if (used) {
                VDBArchive vdb = usedVDBs.get(0);
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.ConnectorBinding_in_use_failed_delete", new Object[]{deployedConnectorBindingName, vdb.getName(), vdb.getVersion()}));
            }
        } else {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.connector_binding_delete_failed", new Object[]{deployedConnectorBindingName}));
        }
        this.notifyConnectorBindingUnLoad(binding.getDeployedName());
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connector_delete", new Object[]{binding.getDeployedName()});
        this.loadedConnectorBindings.remove(binding.getDeployedName());
        this.configurationModel = ServerConfigFileWriter.deleteConnectorBinding(this.configurationModel, binding);
        this.saveSystemConfiguration(this.configurationModel);
    }

    public List getConnectorTypes() throws MetaMatrixComponentException {
        return new ArrayList<ComponentType>(this.loadedConnectorTypes.values());
    }

    public URL getExtensionPath() {
        String path = this.userPreferences.getProperty("dqp.extensions");
        if (this.valid(path)) {
            return this.getFullyQualifiedPath(path);
        }
        return null;
    }

    public boolean useExtensionClasspath() {
        return this.getExtensionPath() != null;
    }

    URL getDefaultExtensionPath() throws MetaMatrixComponentException {
        URL extPath = this.getExtensionPath();
        if (extPath != null) {
            return extPath;
        }
        return this.getFullyQualifiedPath("./extensions/");
    }

    public ExtensionModule getExtensionModule(String extModuleName) throws MetaMatrixComponentException {
        URL extModulePath = this.getFullyQualifiedPath(this.getDefaultExtensionPath(), extModuleName);
        return ExtensionModuleReader.loadExtensionModule(extModuleName, extModulePath);
    }

    public List getExtensionModules() throws MetaMatrixComponentException {
        URL extPath = this.getDefaultExtensionPath();
        return ExtensionModuleReader.loadExtensionModules(extPath);
    }

    public void saveExtensionModule(ExtensionModule extModule) throws MetaMatrixComponentException {
        URL extModuleURL = this.getFullyQualifiedPath(this.getDefaultExtensionPath(), extModule.getFullName());
        ExtensionModuleWriter.write(extModule, extModuleURL);
    }

    public void deleteExtensionModule(String extModuleName) throws MetaMatrixComponentException {
        URL extModuleURL = this.getFullyQualifiedPath(this.getDefaultExtensionPath(), extModuleName);
        ExtensionModuleWriter.deleteModule(extModuleURL);
    }

    public ConnectorBindingType getConnectorType(String connectorType) throws MetaMatrixComponentException {
        return (ConnectorBindingType)this.loadedConnectorTypes.get(connectorType);
    }

    public void saveConnectorType(ConnectorBindingType type) throws MetaMatrixComponentException {
        this.loadedConnectorTypes.put(type.getName(), this.addFullPropertyDefns(type));
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connector_type_save", new Object[]{type.getName()});
        this.configurationModel = ServerConfigFileWriter.addConnectorType(this.configurationModel, type);
        this.saveSystemConfiguration(this.configurationModel);
    }

    public void deleteConnectorType(String deployedConnectorType) throws MetaMatrixComponentException {
        ConnectorBindingType type = (ConnectorBindingType)this.loadedConnectorTypes.remove(deployedConnectorType);
        if (type != null) {
            if (this.isConnectorTypeInUse(type)) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.connector_type_in_use", new Object[]{deployedConnectorType}));
            }
        } else {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.connector_type_delete_failed", new Object[]{deployedConnectorType}));
        }
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connector_type_delete", new Object[]{deployedConnectorType});
        this.configurationModel = ServerConfigFileWriter.deleteConnectorType(this.configurationModel, type);
        this.saveSystemConfiguration(this.configurationModel);
    }

    boolean isConnectorTypeInUse(ConnectorBindingType type) {
        for (ConnectorBinding binding : this.loadedConnectorBindings.values()) {
            if (!binding.getComponentTypeID().equals((Object)type.getID())) continue;
            return true;
        }
        return false;
    }

    public void loadUDF() throws MetaMatrixComponentException {
        URL udfFile = this.getUDFFile();
        if (udfFile != null && this.exists(udfFile)) {
            URL[] urls = this.getCommonExtensionClasspath();
            try {
                this.udfSource = new UDFSource(udfFile, urls);
                FunctionLibraryManager.registerSource((FunctionMetadataSource)this.udfSource);
                DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.udf_load", new Object[]{udfFile, urls});
            }
            catch (IOException e) {
                LogManager.logError((String)"DQP", (Throwable)e, (String)e.getMessage());
            }
        }
    }

    boolean exists(URL url) {
        try {
            InputStream in = url.openStream();
            in.read();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void unloadUDF() {
        if (this.udfSource != null) {
            FunctionLibraryManager.deregisterSource((FunctionMetadataSource)this.udfSource);
            this.udfSource = null;
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.udf_unload", new Object[0]);
        }
    }

    @Override
    public void initializeService(Properties properties) throws ApplicationInitializationException {
        try {
            this.userPreferences = PropertiesUtils.clone((Properties)properties);
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.dqp_loading", new Object[]{this.getInstanceIdenifier()});
            this.initializeEncryption();
            this.configurationModel = this.getSystemConfiguration();
            ServerConfigFileReader configReader = this.loadServerConfigFile();
            this.userPreferences.putAll((Map<?, ?>)configReader.getSystemProperties());
            Map connectorBindings = configReader.getConnectorBindings();
            Map connectorTypes = configReader.getConnectorTypes();
            this.loadUDF();
            this.availableVDBFiles = this.loadVDBs();
            this.loadConnectorBindings(connectorBindings, connectorTypes);
            this.validateVDBs(this.loadedVDBs.values());
        }
        catch (MetaMatrixComponentException e) {
            throw new ApplicationInitializationException((Throwable)e);
        }
    }

    @Override
    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    @Override
    public void stopService() throws ApplicationLifecycleException {
        for (VDBArchive vdb : this.loadedVDBs.values()) {
            vdb.close();
        }
        this.loadedVDBs.clear();
        this.loadedConnectorBindings.clear();
        this.loadedConnectorTypes.clear();
        this.availableVDBFiles.clear();
        this.unloadUDF();
    }

    public URL[] getVDBLocations() {
        ArrayList<URL> vdbs = new ArrayList<URL>();
        String vdbProperty = this.userPreferences.getProperty("vdb.definition");
        if (vdbProperty != null && vdbProperty.length() != 0) {
            StringTokenizer st = new StringTokenizer(vdbProperty, VDB_LIST_SEPARATOR);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String vdbLocation = token.toLowerCase();
                URL vdbURL = null;
                if (!(vdbLocation.endsWith(VDB) || vdbLocation.endsWith(DEF) || vdbLocation.endsWith("/"))) {
                    token = token + "/";
                }
                vdbURL = this.getFullyQualifiedPath(token);
                vdbs.add(vdbURL);
            }
        }
        return vdbs.toArray(new URL[vdbs.size()]);
    }

    void loadConnectorBindings(Map configBindings, Map configTypes) throws MetaMatrixComponentException {
        this.loadedConnectorTypes = configTypes;
        for (String key : configBindings.keySet()) {
            BasicConnectorBinding binding = (BasicConnectorBinding)configBindings.get(key);
            if (binding.getDeployedName() == null) {
                binding.setDeployedName(binding.getFullName());
            }
            this.deployConnectorBinding(binding.getDeployedName(), (ConnectorBinding)binding);
        }
        for (VDBArchive vdb : this.loadedVDBs.values()) {
            BasicVDBDefn def = vdb.getConfigurationDef();
            for (ConnectorBindingType type : def.getConnectorTypes().values()) {
                if (this.loadedConnectorTypes.containsKey(type.getName())) continue;
                this.loadedConnectorTypes.put(type.getName(), this.addFullPropertyDefns(type));
            }
            for (BasicConnectorBinding binding : def.getConnectorBindings().values()) {
                String deployName = binding.getDeployedName();
                if (deployName == null) {
                    deployName = binding.getFullName();
                }
                if (this.loadedConnectorBindings.containsKey(deployName)) continue;
                this.deployConnectorBinding(deployName, (ConnectorBinding)binding);
            }
        }
    }

    private ComponentType addFullPropertyDefns(ConnectorBindingType type) {
        BasicComponentType baseType = (BasicComponentType)type;
        baseType.setComponentTypeDefinitions(this.configurationModel.getAllComponentTypeDefinitions((ComponentTypeID)baseType.getID()));
        return baseType;
    }

    private ConnectorBinding deployConnectorBinding(String deployedName, ConnectorBinding binding) throws MetaMatrixComponentException {
        ConnectorBinding previousBinding = this.getConnectorBinding(deployedName);
        if (previousBinding != null) {
            this.notifyConnectorBindingUnLoad(previousBinding.getDeployedName());
            this.loadedConnectorBindings.remove(previousBinding.getDeployedName());
        }
        BasicConnectorBinding deployedBinding = (BasicConnectorBinding)binding;
        deployedBinding.setDeployedName(deployedName);
        this.loadedConnectorBindings.put(deployedName, (ConnectorBinding)deployedBinding);
        this.notifyConnectorBindingLoad(deployedName);
        return deployedBinding;
    }

    HashMap<String, URL> loadVDBs() throws ApplicationInitializationException {
        HashMap<URL, VDBArchive> vdbFiles;
        try {
            vdbFiles = VDBConfigurationReader.loadVDBS(this.getVDBLocations());
        }
        catch (MetaMatrixComponentException e) {
            throw new ApplicationInitializationException((Throwable)e);
        }
        HashMap<String, URL> loadedVDBFiles = new HashMap<String, URL>();
        for (URL vdbURL : vdbFiles.keySet()) {
            VDBArchive vdb = vdbFiles.get(vdbURL);
            if (vdb == null) continue;
            if (this.loadedVDBs.get(this.vdbId(vdb)) != null) {
                throw new ApplicationInitializationException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.duplicate_vdb_found", new Object[]{vdbURL}));
            }
            this.loadedVDBs.put(this.vdbId(vdb), vdb);
            loadedVDBFiles.put(this.vdbId(vdb), vdbURL);
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.loaded_vdb", new Object[]{vdbURL});
        }
        return loadedVDBFiles;
    }

    ServerConfigFileReader loadServerConfigFile() throws ApplicationInitializationException {
        URL configFile = this.getConfigFile();
        try {
            if (configFile != null) {
                ServerConfigFileReader configReader = new ServerConfigFileReader(configFile);
                return configReader;
            }
            DQPEmbeddedPlugin.logError("EmbeddedConfigurationService.Server_Config_notdefined", null);
            throw new ApplicationInitializationException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.Server_Config_notdefined"));
        }
        catch (IOException e) {
            DQPEmbeddedPlugin.logError("EmbeddedConfigurationService.Server_Config_failedload", new Object[]{configFile});
            throw new ApplicationInitializationException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.Server_Config_failedload", new Object[]{configFile}));
        }
    }

    URL getFullyQualifiedPath(String file) {
        if (file != null) {
            try {
                URL bootStrapURL = (URL)this.userPreferences.get("dqp.propertiesFile");
                return URLHelper.buildURL((URL)bootStrapURL, (String)file);
            }
            catch (MalformedURLException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
        }
        throw new MetaMatrixRuntimeException("bad configuration");
    }

    URL getFullyQualifiedPath(URL context, String file) {
        if (file != null) {
            try {
                return URLHelper.buildURL((URL)context, (String)file);
            }
            catch (MalformedURLException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
        }
        throw new MetaMatrixRuntimeException("bad configuration");
    }

    void initializeEncryption() throws ApplicationInitializationException {
        try {
            URL keyStoreFile = this.getEncryptionKeyStore();
            if (keyStoreFile != null) {
                CryptoUtil.init((URL)keyStoreFile);
            }
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.init_encryption", new Object[0]);
        }
        catch (CryptoException ex) {
            throw new ApplicationInitializationException((Throwable)ex);
        }
    }

    public URL getEncryptionKeyStore() {
        String keyStoreFile = this.userPreferences.getProperty("dqp.keystore");
        if (this.valid(keyStoreFile)) {
            return this.getFullyQualifiedPath(keyStoreFile);
        }
        return null;
    }

    public ServerConnectionListener getConnectionListener() {
        return new ServerConnectionListener(){

            public void connectionAdded(ServerConnection connection) {
                EmbeddedConfigurationService.this.clientConnections.add(connection);
                String vdbName = connection.getLogonResult().getProductInfo("VirtualDatabaseName");
                String vdbVersion = connection.getLogonResult().getProductInfo("VirtualDatabaseVersion");
                String key = EmbeddedConfigurationService.this.vdbId(vdbName, vdbVersion);
                DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connectionAdded", new Object[]{vdbName, vdbVersion, connection.getLogonResult().getSessionID()});
                Integer useCount = (Integer)EmbeddedConfigurationService.this.inuseVDBs.get(key);
                if (useCount == null) {
                    EmbeddedConfigurationService.this.inuseVDBs.put(key, new Integer(1));
                } else {
                    EmbeddedConfigurationService.this.inuseVDBs.put(key, new Integer(useCount + 1));
                }
            }

            public void connectionRemoved(ServerConnection connection) {
                EmbeddedConfigurationService.this.clientConnections.remove(connection);
                String vdbName = connection.getLogonResult().getProductInfo("VirtualDatabaseName");
                String vdbVersion = connection.getLogonResult().getProductInfo("VirtualDatabaseVersion");
                String key = EmbeddedConfigurationService.this.vdbId(vdbName, vdbVersion);
                DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connectionRemoved", new Object[]{vdbName, vdbVersion, connection.getLogonResult().getSessionID()});
                Integer useCount = (Integer)EmbeddedConfigurationService.this.inuseVDBs.get(key);
                if (useCount != null) {
                    if (useCount - 1 == 0) {
                        EmbeddedConfigurationService.this.runVDBCleanUp(vdbName, vdbVersion);
                        EmbeddedConfigurationService.this.inuseVDBs.remove(key);
                    } else {
                        EmbeddedConfigurationService.this.inuseVDBs.put(key, new Integer(useCount - 1));
                    }
                }
            }
        };
    }

    public Set<ServerConnection> getClientConnections() {
        return new HashSet<ServerConnection>(this.clientConnections);
    }

    boolean canDeleteVDB(VDBArchive vdb) {
        Integer useCount = this.inuseVDBs.get(this.vdbId(vdb));
        return useCount == null || useCount == 0;
    }

    void runVDBCleanUp(String vdbName, String vdbVersion) {
        try {
            VDBArchive vdb = this.getVDB(vdbName, vdbVersion);
            if (vdb != null && vdb.getStatus() == 4) {
                this.deleteVDB(vdb);
            }
        }
        catch (MetaMatrixComponentException e) {
            DQPEmbeddedPlugin.logError((Exception)((Object)e), "EmbeddedConfigurationService.vdb_delete_failed", new Object[]{vdbName, vdbVersion});
        }
    }

    void validateVDBs(Collection<VDBArchive> vdbList) throws MetaMatrixComponentException {
        for (VDBArchive vdb : vdbList) {
            if (vdb.getStatus() == 3 || vdb.getStatus() == 3 || !this.isValidVDB(vdb) || !this.isFullyConfiguredVDB(vdb)) continue;
            vdb.setStatus((short)3);
            DQPEmbeddedPlugin.logInfo("VDBService.vdb_loded", new Object[]{vdb.getName(), vdb.getVersion()});
        }
    }

    public boolean isFullyConfiguredVDB(VDBArchive vdb) throws MetaMatrixComponentException {
        BasicVDBDefn def = vdb.getConfigurationDef();
        Collection models = def.getModels();
        for (ModelInfo model : models) {
            if (!model.isPhysical()) continue;
            if (model.getConnectorBindingNames().isEmpty()) {
                DQPEmbeddedPlugin.logWarning("VDBService.vdb_missing_bindings", new Object[]{vdb.getName(), vdb.getVersion()});
                return false;
            }
            String bindingName = (String)model.getConnectorBindingNames().get(0);
            ConnectorBinding binding = def.getConnectorBindingByName(bindingName);
            if (binding != null && this.getConnectorBinding(binding.getDeployedName()) != null) continue;
            DQPEmbeddedPlugin.logWarning("VDBService.vdb_missing_bindings", new Object[]{vdb.getName(), vdb.getVersion()});
            return false;
        }
        return true;
    }

    public void register(ConnectorBindingLifeCycleListener listener) {
        this.connectorBindingLifeCycleListeners.add(listener);
    }

    void notifyConnectorBindingLoad(String bindingName) {
        for (ConnectorBindingLifeCycleListener listener : this.connectorBindingLifeCycleListeners) {
            listener.loaded(bindingName);
        }
    }

    void notifyConnectorBindingUnLoad(String bindingName) {
        for (ConnectorBindingLifeCycleListener listener : this.connectorBindingLifeCycleListeners) {
            listener.unloaded(bindingName);
        }
    }

    public void register(VDBLifeCycleListener listener) {
        this.vdbLifeCycleListeners.add(listener);
    }

    void notifyVDBLoad(String vdbName, String vdbVersion) {
        for (VDBLifeCycleListener listener : this.vdbLifeCycleListeners) {
            listener.loaded(vdbName, vdbVersion);
        }
    }

    void notifyVDBUnLoad(String vdbName, String vdbVersion) {
        for (VDBLifeCycleListener listener : this.vdbLifeCycleListeners) {
            listener.unloaded(vdbName, vdbVersion);
        }
    }

    public boolean useDiskBuffering() {
        return Boolean.valueOf(this.userPreferences.getProperty("dqp.buffer.usedisk", "true"));
    }

    public File getDiskBufferDirectory() {
        File bufferDir = null;
        String bufferDirectory = this.userPreferences.getProperty("dqp.buffer.dir");
        if (this.valid(bufferDirectory)) {
            if (!bufferDirectory.endsWith("/")) {
                bufferDirectory = bufferDirectory + "/";
            }
            bufferDirectory = bufferDirectory + this.getInstanceIdenifier();
            URL bufferURL = this.getFullyQualifiedPath(bufferDirectory);
            bufferDir = new File(bufferURL.getPath());
        } else {
            bufferDir = new File(this.userPreferences.getProperty("mm.io.tmpdir"));
        }
        if (!bufferDir.exists()) {
            bufferDir.mkdirs();
        }
        return bufferDir;
    }

    public String getBufferMemorySize() {
        return this.userPreferences.getProperty("dqp.buffer.memory", "64");
    }

    public String getInstanceIdenifier() {
        return this.userPreferences.getProperty("dqp.identity");
    }

    public String getProcessorBatchSize() {
        return this.userPreferences.getProperty("dqp.buffer.processorBatchSize", "2000");
    }

    public String getConnectorBatchSize() {
        return this.userPreferences.getProperty("dqp.buffer.connectorBatchSize", "2000");
    }

    public void unregister(VDBLifeCycleListener listener) {
        this.vdbLifeCycleListeners.remove(listener);
    }

    public void unregister(ConnectorBindingLifeCycleListener listener) {
        this.connectorBindingLifeCycleListeners.remove(listener);
    }
}

