/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.classloader.URLFilteringClassLoader;
import com.metamatrix.common.comm.api.ResultsReceiver;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.protocol.MetaMatrixURLStreamHandlerFactory;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.configuration.ExtensionModuleReader;
import com.metamatrix.dqp.embedded.services.DefaultIndexConnectorBinding;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.message.AtomicRequestID;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.AtomicResultsMessage;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.service.ConnectorBindingLifeCycleListener;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.query.optimizer.capabilities.SourceCapabilities;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.connector.api.ConnectorException;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManager;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class EmbeddedDataService
extends EmbeddedBaseDQPService
implements DataService {
    private Map connectorIDs = new HashMap();
    private Map connectorMgrs = new HashMap();
    private AtomicInteger counter = new AtomicInteger();
    private Map loadedConnectorBindingsMap = new HashMap();
    private ApplicationEnvironment env;
    private ConnectorBindingLifeCycleListener listener = new ConnectorBindingLifeCycleListener(){

        public void loaded(String bindingName) {
            try {
                EmbeddedDataService.this.startConnectorBinding(bindingName);
            }
            catch (Exception e) {
                DQPEmbeddedPlugin.logError(e, "DataService.FailedStart", new Object[]{bindingName});
            }
        }

        public void unloaded(String bindingName) {
            try {
                EmbeddedDataService.this.stopConnectorBinding(bindingName);
            }
            catch (Exception e) {
                DQPEmbeddedPlugin.logError(e, "DataService.FailedStop", new Object[]{bindingName});
            }
        }
    };

    public ConnectorID selectConnector(String deployedConnectorBindingName) throws MetaMatrixComponentException {
        ConnectorID id = (ConnectorID)this.connectorIDs.get(deployedConnectorBindingName);
        if (id == null) {
            ConnectorBinding binding = this.getConnectorBinding(deployedConnectorBindingName);
            if (binding != null) {
                id = (ConnectorID)this.connectorIDs.get(binding.getDeployedName());
            }
            if (id == null) {
                throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Connector_State_invalid", new Object[]{deployedConnectorBindingName}));
            }
        }
        return id;
    }

    public void executeRequest(AtomicRequestMessage request, ConnectorID connector, ResultsReceiver<AtomicResultsMessage> resultListener) throws MetaMatrixComponentException {
        ConnectorManager mgr = this.getConnectorManager(connector);
        if (mgr == null) {
            throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector_manager_for_{0}_1", new Object[]{connector}));
        }
        mgr.executeRequest(resultListener, request);
    }

    public void cancelRequest(AtomicRequestID request, ConnectorID connectorId) throws MetaMatrixComponentException {
        ConnectorManager mgr = this.getConnectorManager(connectorId);
        if (mgr == null) {
            throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector_manager_for_{0}_1", new Object[]{connectorId}));
        }
        mgr.cancelRequest(request);
    }

    public void closeRequest(AtomicRequestID request, ConnectorID connectorId) throws MetaMatrixComponentException {
        ConnectorManager mgr = this.getConnectorManager(connectorId);
        if (mgr == null) {
            throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector_manager_for_{0}_1", new Object[]{connectorId}));
        }
        mgr.closeRequest(request);
    }

    public void requestBatch(AtomicRequestID request, ConnectorID connectorId) throws MetaMatrixComponentException {
        ConnectorManager mgr = this.getConnectorManager(connectorId);
        if (mgr == null) {
            throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector_manager_for_{0}_1", new Object[]{connectorId}));
        }
        mgr.requstMore(request);
    }

    public SourceCapabilities getCapabilities(RequestMessage request, DQPWorkContext dqpWorkContext, ConnectorID connector) throws MetaMatrixComponentException {
        ConnectorManager mgr = this.getConnectorManager(connector);
        if (mgr != null) {
            try {
                return mgr.getCapabilities(dqpWorkContext.getRequestID(request.getExecutionId()), request.getExecutionPayload(), dqpWorkContext);
            }
            catch (ConnectorException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
        }
        throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector_manager_for_{0}_1", new Object[]{connector}));
    }

    public Collection getConnectorBindingStatistics(String connectorBindingName) throws MetaMatrixComponentException {
        ConnectorManager mgr;
        ConnectorBinding binding = this.getConnectorBinding(connectorBindingName);
        if (binding != null && (mgr = this.getConnectorManager(binding)) != null) {
            return mgr.getQueueStatistics();
        }
        throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector_manager_for_{0}_1", new Object[]{connectorBindingName}));
    }

    public void clearConnectorBindingCache(String connectorBindingName) throws MetaMatrixComponentException {
        ConnectorManager mgr;
        ConnectorBinding binding = this.getConnectorBinding(connectorBindingName);
        if (binding != null && (mgr = this.getConnectorManager(binding)) != null) {
            mgr.clearCache();
            return;
        }
        throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector_manager_for_{0}_1", new Object[]{connectorBindingName}));
    }

    public void startConnectorBinding(String deployedConnectorBindingName) throws ApplicationLifecycleException, MetaMatrixComponentException {
        ConnectorBinding binding = this.getConnectorBinding(deployedConnectorBindingName);
        if (binding != null) {
            ConnectorManager mgr = this.getConnectorManager(binding);
            if (mgr != null && !mgr.started()) {
                mgr.start(this.env);
                ConnectorID connID = mgr.getConnectorID();
                this.connectorIDs.put(binding.getDeployedName(), connID);
                this.connectorMgrs.put(connID, mgr);
                this.loadedConnectorBindingsMap.put(binding.getDeployedName(), binding);
                DQPEmbeddedPlugin.logInfo("DataService.Connector_Started", new Object[]{binding.getDeployedName()});
            }
        } else {
            throw new ApplicationLifecycleException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector", new Object[]{deployedConnectorBindingName}));
        }
    }

    public void stopConnectorBinding(String deployedConnectorBindingName) throws ApplicationLifecycleException, MetaMatrixComponentException {
        ConnectorBinding binding = this.getConnectorBinding(deployedConnectorBindingName);
        if (binding != null) {
            ConnectorManager mgr = this.getConnectorManager(binding, false);
            if (mgr != null && mgr.started()) {
                mgr.stop();
                this.removeConnectorBinding(binding.getDeployedName());
                DQPEmbeddedPlugin.logInfo("DataService.Connector_Stopped", new Object[]{binding.getDeployedName()});
            }
        } else {
            throw new ApplicationLifecycleException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector", new Object[]{deployedConnectorBindingName}));
        }
    }

    public List getConnectorBindings() throws MetaMatrixComponentException {
        List list = this.getConfigurationService().getConnectorBindings();
        return list;
    }

    public Boolean getConnectorBindingState(String deployedConnectorBindingName) throws MetaMatrixComponentException {
        ConnectorManager mgr;
        ConnectorBinding binding = this.getConnectorBinding(deployedConnectorBindingName);
        if (binding != null && (mgr = this.getConnectorManager(binding)) != null) {
            return mgr.getStatus();
        }
        throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector", new Object[]{deployedConnectorBindingName}));
    }

    @Override
    public void initializeService(Properties props) throws ApplicationInitializationException {
    }

    @Override
    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        this.env = environment;
        this.getConfigurationService().register(this.listener);
        try {
            this.startConnectorBinding("SystemPhysical");
            ArrayList<ConnectorBinding> otherBindings = new ArrayList<ConnectorBinding>();
            List vdbs = this.getConfigurationService().getVDBs();
            for (VDBArchive vdb : vdbs) {
                BasicVDBDefn def = vdb.getConfigurationDef();
                if (vdb.getStatus() != 3 && vdb.getStatus() != 3) continue;
                for (ConnectorBinding binding : def.getConnectorBindings().values()) {
                    otherBindings.add(binding);
                }
            }
            Iterator i = otherBindings.iterator();
            while (i.hasNext()) {
                ConnectorBinding binding = null;
                try {
                    binding = (ConnectorBinding)i.next();
                    this.startConnectorBinding(binding.getDeployedName());
                }
                catch (ApplicationLifecycleException e) {
                    DQPEmbeddedPlugin.logError((Exception)((Object)e), "DataService.Connector_failed_start", new Object[]{binding.getDeployedName()});
                }
                catch (MetaMatrixComponentException e) {
                    DQPEmbeddedPlugin.logError((Exception)((Object)e), "DataService.Connector_failed_start", new Object[]{binding.getDeployedName()});
                }
            }
            DQPEmbeddedPlugin.logInfo("DataService.Started", null);
        }
        catch (MetaMatrixComponentException e) {
            DQPEmbeddedPlugin.logError((Exception)((Object)e), "DataService.Failed_To_Start", null);
            throw new ApplicationLifecycleException((Throwable)e);
        }
    }

    @Override
    public void stopService() throws ApplicationLifecycleException {
        this.getConfigurationService().unregister(this.listener);
        String[] connectorBindings = this.loadedConnectorBindingsMap.keySet().toArray(new String[this.loadedConnectorBindingsMap.keySet().size()]);
        for (int i = 0; i < connectorBindings.length; ++i) {
            try {
                this.stopConnectorBinding(connectorBindings[i]);
                continue;
            }
            catch (MetaMatrixComponentException e) {
                throw new ApplicationLifecycleException((Throwable)e);
            }
        }
        this.connectorMgrs.clear();
        this.connectorIDs.clear();
        this.loadedConnectorBindingsMap.clear();
        DQPEmbeddedPlugin.logInfo("DataService.Stopped", null);
    }

    ConnectorManager getConnectorManager(ConnectorBinding binding, boolean create) throws MetaMatrixComponentException {
        ConnectorID connectionId = (ConnectorID)this.connectorIDs.get(binding.getDeployedName());
        if (connectionId == null && create) {
            return this.createConnectorManger(binding);
        }
        return (ConnectorManager)this.connectorMgrs.get(connectionId);
    }

    ConnectorManager getConnectorManager(ConnectorBinding binding) throws MetaMatrixComponentException {
        return this.getConnectorManager(binding, true);
    }

    ConnectorManager getConnectorManager(ConnectorID connID) {
        if (connID != null) {
            return (ConnectorManager)this.connectorMgrs.get(connID);
        }
        return null;
    }

    public ConnectorBinding getConnectorBinding(String deployedConnectorBindingName) throws MetaMatrixComponentException {
        ConnectorBinding binding = (ConnectorBinding)this.loadedConnectorBindingsMap.get(deployedConnectorBindingName);
        if (binding == null) {
            binding = "SystemPhysical".equals(deployedConnectorBindingName) ? this.getSystemModelBinding() : this.getConfigurationService().getConnectorBinding(deployedConnectorBindingName);
        }
        return binding;
    }

    ConnectorManager createConnectorManger(ConnectorBinding binding) throws MetaMatrixComponentException {
        Properties connectorProperties = this.getDecryptedProperties(binding);
        String connectorId = String.valueOf(this.counter.getAndIncrement());
        connectorProperties.setProperty("ConnectorID", connectorId);
        connectorProperties.setProperty("ConnectorBindingName", binding.getFullName());
        try {
            ConnectorManager mgr = this.initConnectorManager(connectorProperties);
            mgr.initialize(connectorProperties);
            return mgr;
        }
        catch (Exception e) {
            DQPEmbeddedPlugin.logError(e, "DataService.Failed_Initialize_CM", new Object[]{binding.getDeployedName()});
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    private void removeConnectorBinding(String connectorBindingName) throws MetaMatrixComponentException, ApplicationLifecycleException {
        ConnectorID id = this.selectConnector(connectorBindingName);
        this.connectorMgrs.remove(id);
        this.connectorIDs.remove(connectorBindingName);
        this.loadedConnectorBindingsMap.remove(connectorBindingName);
    }

    Properties getDecryptedProperties(ConnectorBinding binding) throws MetaMatrixComponentException {
        ConnectorBindingType defaultType;
        Properties bindingProperties = binding.getProperties();
        Properties decryptedProperties = new Properties();
        ComponentTypeID id = binding.getComponentTypeID();
        ConnectorBindingType type = this.getConfigurationService().getConnectorType(id.getName());
        Properties props = null;
        props = this.getConfigurationService().getDefaultProperties(binding);
        if ((props == null || props.isEmpty()) && (defaultType = this.getConfigurationService().getConnectorType("Connector")) != null) {
            props = defaultType.getDefaultPropertyValues();
        }
        if (props != null && !props.isEmpty()) {
            decryptedProperties.putAll((Map<?, ?>)props);
        }
        decryptedProperties.putAll((Map<?, ?>)bindingProperties);
        for (String string : bindingProperties.keySet()) {
            if (!this.isMaskedProperty(string, (ComponentType)type)) continue;
            try {
                String value = this.decryptProperty(bindingProperties.getProperty(string));
                decryptedProperties.setProperty(string, value);
            }
            catch (CryptoException e) {
                DQPEmbeddedPlugin.logError((Exception)((Object)e), "DataService.decryption_failed", new Object[]{binding.getDeployedName(), string});
            }
        }
        return decryptedProperties;
    }

    protected boolean isMaskedProperty(String propName, ComponentType type) {
        ComponentTypeDefn typeDef;
        return type != null && (typeDef = type.getComponentTypeDefinition(propName)) != null && typeDef.getPropertyDefinition().isMasked();
    }

    protected String decryptProperty(String value) throws CryptoException {
        if (value != null && value.length() > 0 && CryptoUtil.isValueEncrypted((String)value)) {
            return CryptoUtil.stringDecrypt((String)value);
        }
        return value;
    }

    ConnectorBinding getSystemModelBinding() {
        return new DefaultIndexConnectorBinding();
    }

    ConnectorManager initConnectorManager(Properties connectorProperties) throws ApplicationLifecycleException {
        try {
            boolean useExtensionClassPath = this.getConfigurationService().useExtensionClasspath();
            String classPath = this.buildClasspath(connectorProperties);
            if (classPath == null || classPath.length() == 0) {
                useExtensionClassPath = false;
            }
            if (!useExtensionClassPath) {
                return new ConnectorManager();
            }
            DQPEmbeddedPlugin.logInfo("DataService.useClassloader", new Object[]{classPath});
            URL context = this.getConfigurationService().getExtensionPath();
            URL[] userPath = ExtensionModuleReader.resolveExtensionClasspath(classPath, context);
            URL[] commonExtensionPath = this.getConfigurationService().getCommonExtensionClasspath();
            ArrayList<URL> urlPath = new ArrayList<URL>();
            urlPath.addAll(Arrays.asList(userPath));
            if (commonExtensionPath != null) {
                urlPath.addAll(Arrays.asList(commonExtensionPath));
            }
            URLFilteringClassLoader classLoader = new URLFilteringClassLoader(urlPath.toArray(new URL[urlPath.size()]), Thread.currentThread().getContextClassLoader(), (URLStreamHandlerFactory)new MetaMatrixURLStreamHandlerFactory());
            ConnectorManager cm = new ConnectorManager();
            cm.setClassloader((ClassLoader)classLoader);
            return cm;
        }
        catch (Exception e) {
            throw new ApplicationLifecycleException((Throwable)e);
        }
    }

    private String buildClasspath(Properties connectorProperties) {
        StringBuilder sb = new StringBuilder();
        this.appendlasspath(connectorProperties.getProperty("ConnectorClassPath"), sb);
        this.appendlasspath(connectorProperties.getProperty("ConnectorTypeClassPath"), sb);
        return sb.toString();
    }

    private void appendlasspath(String path, StringBuilder builder) {
        if (path != null && path.length() > 0) {
            builder.append(path);
            if (!path.endsWith(";")) {
                builder.append(";");
            }
        }
    }
}

