/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.VDBLifeCycleListener;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.dqp.service.metadata.IndexSelectorSource;
import com.metamatrix.dqp.service.metadata.QueryMetadataCache;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import java.util.Properties;

public class EmbeddedMetadataService
extends EmbeddedBaseDQPService
implements MetadataService,
IndexSelectorSource {
    private QueryMetadataCache metadataCache = null;
    private VDBLifeCycleListener listener = new VDBLifeCycleListener(){

        public void loaded(String vdbName, String vdbVersion) {
        }

        public void unloaded(String vdbName, String vdbVersion) {
            EmbeddedMetadataService.this.metadataCache.removeFromCache(vdbName, vdbVersion);
        }
    };

    @Override
    public void initializeService(Properties properties) throws ApplicationInitializationException {
    }

    @Override
    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        try {
            ConfigurationService configSvc = this.getConfigurationService();
            this.metadataCache = new QueryMetadataCache(configSvc.getSystemVdb());
            configSvc.register(this.listener);
        }
        catch (MetaMatrixComponentException e) {
            throw new ApplicationLifecycleException((Throwable)e);
        }
    }

    @Override
    public void stopService() throws ApplicationLifecycleException {
        this.getConfigurationService().unregister(this.listener);
        this.metadataCache.clearCache();
    }

    public QueryMetadataInterface lookupMetadata(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        QueryMetadataInterface qmi = this.metadataCache.lookupMetadata(vdbName, vdbVersion);
        if (qmi == null) {
            VDBService vdbService = (VDBService)this.lookupService("dqp.vdb");
            return this.metadataCache.lookupMetadata(vdbName, vdbVersion, vdbService.getVDBResource(vdbName, vdbVersion));
        }
        return qmi;
    }

    public IObjectSource getMetadataObjectSource(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        VDBService vdbService = (VDBService)this.lookupService("dqp.vdb");
        return this.metadataCache.getCompositeMetadataObjectSource(vdbName, vdbVersion, vdbService);
    }
}

