/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.transaction.TransactionServer;
import com.metamatrix.dqp.transaction.XAServer;
import com.metamatrix.xa.arjuna.ArjunaTransactionProvider;
import java.util.Properties;
import org.teiid.dqp.internal.transaction.TransactionProvider;
import org.teiid.dqp.internal.transaction.TransactionServerImpl;

public class EmbeddedTransactionService
extends EmbeddedBaseDQPService
implements TransactionService {
    public static final String TRANSACTIONS_ENABLED = "metamatrix.xatxnmgr.enabled";
    private TransactionServerImpl arjunaTs = new TransactionServerImpl();
    private TransactionServer ts;

    @Override
    public void initializeService(Properties props) throws ApplicationInitializationException {
        try {
            props = new Properties(props);
            props.put("metamatrix.xatxnmgr.hostname", "dqp");
            props.put("metamatrix.xatxnmgr.vmname", props.getProperty("dqp.identity"));
            this.arjunaTs.init((TransactionProvider)ArjunaTransactionProvider.getInstance((Properties)props));
            Class[] interfaces = new Class[]{TransactionServer.class, XAServer.class};
            this.ts = (TransactionServer)LogManager.createLoggingProxy((String)"XA_TXN", (Object)this.arjunaTs, (Class[])interfaces, (int)5);
        }
        catch (XATransactionException e) {
            throw new ApplicationInitializationException((Throwable)e);
        }
    }

    @Override
    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    @Override
    public void stopService() throws ApplicationLifecycleException {
        this.arjunaTs.shutdown(true);
    }

    public TransactionServer getTransactionServer() {
        return this.ts;
    }

    public XAServer getXAServer() {
        return (XAServer)this.ts;
    }
}

