/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.SystemVdbUtility;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EmbeddedVDBService
extends EmbeddedBaseDQPService
implements VDBService {
    static final String[] VDB_STATUS = new String[]{"INCOMPLETE", "INACTIVE", "ACTIVE", "DELETED"};

    VDBArchive getVDB(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        VDBArchive vdb = this.getConfigurationService().getVDB(vdbName, vdbVersion);
        if (vdb == null) {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.VDB_does_not_exist._2", new Object[]{vdbName, vdbVersion}));
        }
        return vdb;
    }

    private boolean isSystemModel(String modelName) {
        return modelName.equalsIgnoreCase("SystemPhysical");
    }

    private ModelInfo getModel(VDBDefn vdb, String modelName) {
        Collection c = vdb.getModels();
        for (ModelInfo model : c) {
            if (!model.getName().equals(modelName)) continue;
            return model;
        }
        return null;
    }

    public List getConnectorBindingNames(String vdbName, String vdbVersion, String modelName) throws MetaMatrixComponentException {
        if (this.isSystemModel(modelName)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("SystemPhysical");
            return list;
        }
        VDBArchive vdb = this.getVDB(vdbName, vdbVersion);
        BasicVDBDefn def = vdb.getConfigurationDef();
        ModelInfo m = def.getModel(modelName);
        if (m == null) {
            ArrayList<String> bindingList = new ArrayList<String>();
            bindingList.add(modelName);
            return bindingList;
        }
        List localNames = m.getConnectorBindingNames();
        Map deployedBindingsMap = def.getConnectorBindings();
        ArrayList<String> matches = new ArrayList<String>();
        if (localNames != null && !localNames.isEmpty()) {
            for (String localName : localNames) {
                ConnectorBinding deployedBinding = (ConnectorBinding)deployedBindingsMap.get(localName);
                if (deployedBinding == null) continue;
                matches.add(deployedBinding.getDeployedName());
            }
        }
        return matches;
    }

    public int getModelVisibility(String vdbName, String vdbVersion, String modelName) throws MetaMatrixComponentException {
        if (this.isSystemModel(modelName)) {
            return 2;
        }
        if (SystemVdbUtility.isSystemModelWithSystemTableType((String)modelName)) {
            return 0;
        }
        VDBArchive vdb = this.getVDB(vdbName, vdbVersion);
        BasicVDBDefn def = vdb.getConfigurationDef();
        ModelInfo model = this.getModel((VDBDefn)def, modelName);
        if (model != null) {
            return model.getVisibility();
        }
        return 2;
    }

    public int getFileVisibility(String vdbName, String vdbVersion, String pathInVDB) throws MetaMatrixComponentException {
        String modelName = StringUtil.getFirstToken((String)StringUtil.getLastToken((String)pathInVDB, (String)"/"), (String)".");
        if (this.isSystemModel(modelName)) {
            return 2;
        }
        if (SystemVdbUtility.isSystemModelWithSystemTableType((String)modelName)) {
            return 0;
        }
        VDBArchive vdb = this.getVDB(vdbName, vdbVersion);
        BasicVDBDefn def = vdb.getConfigurationDef();
        ModelInfo model = this.getModel((VDBDefn)def, modelName);
        if (model != null) {
            return model.getVisibility();
        }
        return def.isVisible(pathInVDB) ? 0 : 2;
    }

    public InputStream getVDBResource(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        try {
            VDBArchive vdb = this.getVDB(vdbName, vdbVersion);
            return vdb.getInputStream();
        }
        catch (IOException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public List<String> getMultiSourceModels(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        VDBArchive vdb = this.getVDB(vdbName, vdbVersion);
        BasicVDBDefn def = vdb.getConfigurationDef();
        ArrayList<String> multiSourceModels = new ArrayList<String>();
        Collection models = def.getModels();
        for (BasicModelInfo model : models) {
            if (!model.isMultiSourceBindingEnabled()) continue;
            multiSourceModels.add(model.getName());
        }
        return multiSourceModels;
    }

    public List<VDBArchive> getAvailableVDBs() throws MetaMatrixComponentException {
        List fullList = this.getConfigurationService().getVDBs();
        ArrayList<VDBArchive> activeList = new ArrayList<VDBArchive>();
        for (VDBArchive vdb : fullList) {
            if (vdb.getStatus() == 4) continue;
            activeList.add(vdb);
        }
        return activeList;
    }

    public int getVDBStatus(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        VDBArchive vdb = this.getVDB(vdbName, vdbVersion);
        return vdb.getStatus();
    }

    public void changeVDBStatus(String vdbName, String vdbVersion, int status) throws MetaMatrixComponentException {
        VDBArchive vdb = this.getVDB(vdbName, vdbVersion);
        short currentStatus = vdb.getStatus();
        if (status != currentStatus) {
            VDBArchive sameVdb = vdb;
            if (!(currentStatus == 3 || status != 3 && status != 3 || this.isValidVDB(sameVdb) && this.getConfigurationService().isFullyConfiguredVDB(sameVdb))) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.vdb_missing_bindings", new Object[]{vdb.getName(), vdb.getVersion()}));
            }
            sameVdb.setStatus((short)status);
            if (status != sameVdb.getStatus()) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.vdb_change_status_failed", new Object[]{vdbName, vdbVersion, VDB_STATUS[currentStatus - 1], VDB_STATUS[status - 1]}));
            }
            this.getConfigurationService().saveVDB(vdb, vdb.getVersion());
            DQPEmbeddedPlugin.logInfo("VDBService.vdb_change_status", new Object[]{vdbName, vdbVersion, VDB_STATUS[currentStatus - 1], VDB_STATUS[status - 1]});
        }
    }

    public String getConnectorName(String connectorBindingID) {
        return connectorBindingID;
    }

    @Override
    public void initializeService(Properties properties) throws ApplicationInitializationException {
    }

    @Override
    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    @Override
    public void stopService() throws ApplicationLifecycleException {
    }
}

