/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.DQPConfigSource;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.ResourceFinder;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.jdbc.ConnectionListener;
import com.metamatrix.jdbc.EmbeddedConnection;
import com.metamatrix.jdbc.EmbeddedConnectionFactory;
import com.metamatrix.jdbc.EmbeddedGuiceModule;
import com.metamatrix.jdbc.EmbeddedSQLException;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.transport.LocalTransportHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.teiid.dqp.internal.process.DQPCore;

public class EmbeddedConnectionFactoryImpl
implements EmbeddedConnectionFactory {
    private static final int ACTIVE = 3;
    private boolean initialized = false;
    private LocalTransportHandler handler = null;
    private volatile boolean shutdownInProgress = false;
    private DQPCore dqp;
    private long starttime = -1L;
    private Thread shutdownThread;
    private EmbeddedConnectionListener listener = new EmbeddedConnectionListener();

    public Connection createConnection(Properties props) throws SQLException {
        try {
            this.initialize(props);
            this.checkConnectionProperties(props);
            ServerConnection serverConn = this.handler.createConnection(props);
            return new EmbeddedConnection(this, serverConn, props, this.listener);
        }
        catch (ConnectionException e) {
            throw new EmbeddedSQLException((Throwable)e);
        }
        catch (ApplicationInitializationException e) {
            throw new EmbeddedSQLException((Throwable)e);
        }
    }

    private synchronized void initialize(Properties props) throws ApplicationInitializationException {
        if (!this.initialized) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new EmbeddedGuiceModule(props)});
            ResourceFinder.setInjector((Injector)injector);
            DQPConfigSource configSource = (DQPConfigSource)injector.getInstance(DQPConfigSource.class);
            this.dqp = new DQPCore();
            this.dqp.start(configSource);
            ConfigurationService configService = (ConfigurationService)this.findService("dqp.configuration");
            this.handler = new LocalTransportHandler((ClientSideDQP)this.dqp);
            this.handler.registerListener(configService.getConnectionListener());
            this.shutdownThread = new ShutdownWork();
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            this.initialized = true;
            this.starttime = System.currentTimeMillis();
            DQPEmbeddedPlugin.logInfo("DQPEmbeddedManager.start_dqp", new Object[]{new Date(System.currentTimeMillis()).toString()});
        }
    }

    public synchronized boolean isAlive() {
        return this.dqp != null;
    }

    public long getStartTime() {
        return this.starttime;
    }

    public Properties getProperties() {
        if (this.isAlive()) {
            return ((ConfigurationService)this.findService("dqp.configuration")).getSystemProperties();
        }
        return null;
    }

    public synchronized DQPCore getDQP() {
        if (!this.isAlive()) {
            throw new MetaMatrixRuntimeException(JDBCPlugin.Util.getString("LocalTransportHandler.Transport_shutdown"));
        }
        return this.dqp;
    }

    public ApplicationService findService(String type) {
        return this.dqp.getEnvironment().findService(type);
    }

    public void shutdown() throws SQLException {
        this.shutdown(true);
    }

    private void shutdown(boolean undoShutdownHook) throws SQLException {
        if (undoShutdownHook) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        }
        if (!this.shutdownInProgress && this.initialized) {
            this.shutdownInProgress = true;
            this.listener.closeConnections();
            try {
                this.dqp.stop();
            }
            catch (ApplicationLifecycleException e) {
                LogManager.logWarning((String)"DQP", (Throwable)e, (String)e.getMessage());
            }
            this.dqp = null;
            this.handler = null;
            this.initialized = false;
            ResourceFinder.getCacheFactory().destroy();
            this.shutdownInProgress = false;
        }
    }

    private void checkConnectionProperties(Properties props) throws SQLException {
        String vdbName = props.getProperty("VirtualDatabaseName");
        String vdbVersion = props.getProperty("VirtualDatabaseVersion", "useLatestVDBVersion");
        try {
            VDBService service = (VDBService)this.findService("dqp.vdb");
            List vdbs = service.getAvailableVDBs();
            if (vdbVersion.equals("useLatestVDBVersion")) {
                vdbVersion = this.findLatestVersion(vdbName, vdbs);
            }
            props.setProperty("VirtualDatabaseVersion", vdbVersion);
            int status = service.getVDBStatus(vdbName, vdbVersion);
            if (status != 3) {
                throw new EmbeddedSQLException(JDBCPlugin.Util.getString("EmbeddedConnectionFactory.vdb_notactive", new Object[]{vdbName, vdbVersion}));
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new EmbeddedSQLException((Throwable)e, JDBCPlugin.Util.getString("EmbeddedConnectionFactory.vdb_notavailable", new Object[]{vdbName, vdbVersion}));
        }
    }

    String findLatestVersion(String vdbName, List<VDBArchive> vdbs) throws EmbeddedSQLException {
        int latestVersion = 0;
        for (VDBArchive vdb : vdbs) {
            if (!vdb.getName().equalsIgnoreCase(vdbName)) continue;
            latestVersion = Math.max(latestVersion, Integer.parseInt(vdb.getVersion()));
        }
        if (latestVersion != 0) {
            return String.valueOf(latestVersion);
        }
        throw new EmbeddedSQLException(JDBCPlugin.Util.getString("EmbeddedConnectionFactory.vdb_notavailable", new Object[]{vdbName, "useLatestVDBVersion"}));
    }

    private class EmbeddedConnectionListener
    implements ConnectionListener {
        HashMap connections = new HashMap();

        private EmbeddedConnectionListener() {
        }

        public void connectionAdded(String id, Connection connection) {
            this.connections.put(id, connection);
        }

        public void connectionRemoved(String id, Connection connection) {
            this.connections.remove(id);
        }

        private void closeConnections() throws SQLException {
            Exception firstException = null;
            while (this.connections.size() != 0) {
                try {
                    Iterator i = this.connections.keySet().iterator();
                    if (!i.hasNext()) continue;
                    Connection connection = (Connection)this.connections.get(i.next());
                    connection.close();
                }
                catch (Exception ex) {
                    if (firstException != null) continue;
                    firstException = ex;
                }
            }
            if (firstException != null) {
                throw new EmbeddedSQLException(firstException);
            }
        }
    }

    class ShutdownWork
    extends Thread {
        ShutdownWork() {
            super("embedded-shudown-thread");
        }

        @Override
        public void run() {
            try {
                EmbeddedConnectionFactoryImpl.this.shutdown(false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

