/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.metamatrix.cache.CacheFactory;
import com.metamatrix.cache.jboss.JBossCacheFactory;
import com.metamatrix.common.application.DQPConfigSource;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.dqp.embedded.EmbeddedConfigSource;
import com.metamatrix.jdbc.CacheProvider;
import com.metamatrix.jdbc.LogConfigurationProvider;
import com.metamatrix.jdbc.LogListernerProvider;
import java.util.Properties;
import org.jboss.cache.Cache;

public class EmbeddedGuiceModule
extends AbstractModule {
    private Properties props;

    public EmbeddedGuiceModule(Properties props) {
        this.props = props;
    }

    protected void configure() {
        this.bind(Cache.class).toProvider(CacheProvider.class).in(Scopes.SINGLETON);
        this.bind(CacheFactory.class).to(JBossCacheFactory.class).in(Scopes.SINGLETON);
        this.bind(DQPConfigSource.class).toInstance((Object)new EmbeddedConfigSource(this.props));
        this.bind(LogConfiguration.class).toProvider(LogConfigurationProvider.class).in(Scopes.SINGLETON);
        this.bind(LogListener.class).toProvider(LogListernerProvider.class).in(Scopes.SINGLETON);
        this.binder().requestStaticInjection(new Class[]{LogManager.class});
    }
}

