/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.metamatrix.common.application.DQPConfigSource;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;

@Singleton
class LogConfigurationProvider
implements Provider<LogConfiguration> {
    @Inject
    DQPConfigSource configSource;

    LogConfigurationProvider() {
    }

    public LogConfiguration get() {
        String logLevel = this.configSource.getProperties().getProperty("dqp.logLevel");
        int level = 0;
        if (logLevel != null && logLevel.trim().length() > 0) {
            try {
                level = Integer.parseInt(logLevel);
            }
            catch (NumberFormatException e) {
                throw new MetaMatrixRuntimeException(DQPEmbeddedPlugin.Util.getString("DQPComponent.Unable_to_parse_level") + logLevel);
            }
        }
        return new BasicLogConfiguration(level);
    }
}

