/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.metamatrix.common.application.DQPConfigSource;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.log.FileLimitSizeLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.log.NullLogWriter;
import com.metamatrix.core.log.SystemLogWriter;
import com.metamatrix.internal.core.log.PlatformLog;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

@Singleton
class LogListernerProvider
implements Provider<LogListener> {
    private static final String STDOUT = "STDOUT";
    @Inject
    DQPConfigSource configSource;

    LogListernerProvider() {
    }

    public LogListener get() {
        URL dqpURL = (URL)this.configSource.getProperties().get("bootstrapFile");
        String logFile = this.configSource.getProperties().getProperty("dqp.logFile");
        String instanceId = this.configSource.getProperties().getProperty("dqp.identity", "0");
        try {
            String dqpURLString = dqpURL.toString();
            dqpURL = URLHelper.buildURL((String)dqpURLString);
            if (logFile != null) {
                if (logFile.equalsIgnoreCase(STDOUT)) {
                    PlatformLog log = new PlatformLog();
                    log.addListener((LogListener)new SystemLogWriter());
                    return log;
                }
                String modifiedLogFileName = logFile;
                int dotIndex = logFile.lastIndexOf(46);
                modifiedLogFileName = dotIndex != -1 ? logFile.substring(0, dotIndex) + "_" + instanceId + "." + logFile.substring(dotIndex + 1) : logFile + "_" + instanceId;
                URL logURL = URLHelper.buildURL((URL)dqpURL, (String)modifiedLogFileName);
                File file = new File(logURL.getPath());
                PlatformLog log = new PlatformLog();
                log.addListener((LogListener)new FileLimitSizeLogWriter(file, false));
                return log;
            }
            return new NullLogWriter();
        }
        catch (MalformedURLException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }
}

