/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.transport;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.client.ExceptionUtil;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionListener;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class LocalServerConnection
implements ServerConnection {
    private final LogonResult result;
    private boolean shutdown;
    private DQPWorkContext workContext;
    private ClientSideDQP dqp;
    private ServerConnectionListener listener;

    public LocalServerConnection(MetaMatrixSessionID sessionId, Properties connectionProperties, ClientSideDQP dqp, ServerConnectionListener listener) {
        this.result = new LogonResult(sessionId, connectionProperties.getProperty("user"), connectionProperties, -1L, "local");
        this.workContext = new DQPWorkContext();
        this.workContext.setSessionId(this.result.getSessionID());
        this.workContext.setVdbName(connectionProperties.getProperty("VirtualDatabaseName"));
        this.workContext.setVdbVersion(connectionProperties.getProperty("VirtualDatabaseVersion"));
        DQPWorkContext.setWorkContext((DQPWorkContext)this.workContext);
        this.dqp = dqp;
        this.listener = listener;
        if (this.listener != null) {
            this.listener.connectionAdded((ServerConnection)this);
        }
    }

    public <T> T getService(Class<T> iface) {
        if (iface != ClientSideDQP.class) {
            throw new IllegalArgumentException("unknown service");
        }
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ClientSideDQP.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
                if (!LocalServerConnection.this.isOpen()) {
                    throw ExceptionUtil.convertException((Method)arg1, (Throwable)new MetaMatrixComponentException(JDBCPlugin.Util.getString("LocalTransportHandler.session_inactive")));
                }
                DQPWorkContext.setWorkContext((DQPWorkContext)LocalServerConnection.this.workContext);
                try {
                    return arg1.invoke((Object)LocalServerConnection.this.dqp, arg2);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        });
    }

    public boolean isOpen() {
        return !this.shutdown;
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        if (this.listener != null) {
            this.listener.connectionRemoved((ServerConnection)this);
        }
        this.shutdown = true;
    }

    public LogonResult getLogonResult() {
        return this.result;
    }
}

