/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.transport;

import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.api.ServerConnectionListener;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.jdbc.transport.LocalServerConnection;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;

public class LocalTransportHandler
implements ServerConnectionFactory {
    private AtomicLong SESSION_ID = new AtomicLong(1L);
    private ConnectionListenerList listenerList = new ConnectionListenerList();
    private ClientSideDQP dqp;

    public LocalTransportHandler(ClientSideDQP dqp) throws ApplicationInitializationException {
        this.dqp = dqp;
    }

    public ServerConnection createConnection(Properties connectionProperties) throws ConnectionException {
        return new LocalServerConnection(new MetaMatrixSessionID(this.SESSION_ID.getAndIncrement()), connectionProperties, this.dqp, this.listenerList);
    }

    public synchronized void registerListener(ServerConnectionListener listener) {
        this.listenerList.add(listener);
    }

    private final class ConnectionListenerList
    extends ArrayList<ServerConnectionListener>
    implements ServerConnectionListener {
        private ConnectionListenerList() {
        }

        public void connectionAdded(ServerConnection connection) {
            for (ServerConnectionListener l : this) {
                l.connectionAdded(connection);
            }
        }

        public void connectionRemoved(ServerConnection connection) {
            for (ServerConnectionListener l : this) {
                l.connectionRemoved(connection);
            }
        }
    }
}

