/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.TransactionMetadata;
import org.teiid.adminapi.jboss.VDBMetadataMapper;

public class TestTransactionMetadata {
    private static final String describe = "{\n    \"session-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"Session Identifier\",\n        \"required\" : true\n    },\n    \"txn-created-time\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"LONG\"\n        },\n        \"description\" : \"Transaction created time\",\n        \"required\" : true\n    },\n    \"txn-scope\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"LONG\"\n        },\n        \"description\" : \"Transaction scope (Request, Local, Global)\",\n        \"required\" : true\n    },\n    \"txn-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"Transaction Identifier (XID)\",\n        \"required\" : true\n    }\n}";

    @Test
    public void testMapping() {
        TransactionMetadata tm = new TransactionMetadata();
        tm.setAssociatedSession("x");
        tm.setCreatedTime(1234L);
        tm.setId("tnx-id");
        tm.setScope("scope");
        ModelNode node = VDBMetadataMapper.TransactionMetadataMapper.INSTANCE.wrap(tm, new ModelNode());
        TransactionMetadata tm1 = VDBMetadataMapper.TransactionMetadataMapper.INSTANCE.unwrap(node);
        Assert.assertEquals((Object)tm.getAssociatedSession(), (Object)tm1.getAssociatedSession());
        Assert.assertEquals((long)tm.getCreatedTime(), (long)tm1.getCreatedTime());
        Assert.assertEquals((Object)tm.getId(), (Object)tm1.getId());
        Assert.assertEquals((Object)tm.getScope(), (Object)tm1.getScope());
    }

    @Test
    public void testDescribe() {
        ModelNode n = VDBMetadataMapper.TransactionMetadataMapper.INSTANCE.describe(new ModelNode());
        Assert.assertEquals((Object)describe, (Object)n.toJSONString(false));
    }
}

