/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.jboss.VDBMetadataMapper;

public class TestRequestMetadata {
    public static final String desc = "{\n    \"execution-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"LONG\"\n        },\n        \"description\" : \"Unique Identifier for Request\",\n        \"required\" : true\n    },\n    \"session-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"Session Identifier\",\n        \"required\" : true\n    },\n    \"start-time\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"LONG\"\n        },\n        \"description\" : \"Start time for the request\",\n        \"required\" : true\n    },\n    \"command\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"Executing Command\",\n        \"required\" : true\n    },\n    \"source-request\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"BOOLEAN\"\n        },\n        \"description\" : \"Is this Connector level request\",\n        \"required\" : true\n    },\n    \"node-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"INT\"\n        },\n        \"description\" : \"Node Identifier\",\n        \"required\" : false\n    },\n    \"transaction-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"Get Transaction XID if transaction involved\",\n        \"required\" : false\n    },\n    \"processing-state\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"State of the Request\",\n        \"required\" : true\n    },\n    \"thread-state\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"Thread state\",\n        \"required\" : true\n    }\n}";

    @Test
    public void testMapping() {
        RequestMetadata request = this.buildRequest();
        ModelNode node = VDBMetadataMapper.RequestMetadataMapper.INSTANCE.wrap(request, new ModelNode());
        RequestMetadata actual = VDBMetadataMapper.RequestMetadataMapper.INSTANCE.unwrap(node);
        Assert.assertEquals((Object)request, (Object)actual);
        Assert.assertEquals((Object)request.getState(), (Object)actual.getState());
    }

    private RequestMetadata buildRequest() {
        RequestMetadata request = new RequestMetadata();
        request.setState(Request.ProcessingState.PROCESSING);
        request.setCommand("select * from foo");
        request.setExecutionId(1234L);
        request.setName("request-name");
        request.setSessionId("session-id");
        request.setSourceRequest(false);
        request.setStartTime(12345L);
        request.setTransactionId("transaction-id");
        request.setThreadState(Request.ThreadState.RUNNING);
        return request;
    }

    @Test
    public void testDescribe() {
        Assert.assertEquals((Object)desc, (Object)VDBMetadataMapper.RequestMetadataMapper.INSTANCE.describe(new ModelNode()).toJSONString(false));
    }
}

