/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.index;

import com.metamatrix.connector.metadata.index.IndexCriteriaBuilder;
import com.metamatrix.connector.metadata.index.MetadataInCriteria;
import com.metamatrix.connector.metadata.index.MetadataLiteralCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class TestIndexCriteriaBuilder
extends TestCase {
    public TestIndexCriteriaBuilder(String name) {
        super(name);
    }

    public void helpAddToCriteria(Map criteria, String fieldName, Object fieldValue) {
        MetadataLiteralCriteria literalCriteria = new MetadataLiteralCriteria(fieldName, fieldValue);
        criteria.put(fieldName.toUpperCase(), literalCriteria);
    }

    public void helpAddToInCriteria(Map criteria, String fieldName, Collection fieldValues) {
        MetadataInCriteria literalCriteria = new MetadataInCriteria(fieldName, fieldValues);
        criteria.put(fieldName.toUpperCase(), literalCriteria);
    }

    public void testDataTypeCriteriaPrefix1() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "DatatypeID", "dataTypeUUID");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"DATATYPES.INDEX", criteria);
        String expectedPrefix = "M\u00a0datatypeuuid\u00a0";
        TestIndexCriteriaBuilder.assertNotNull((Object)matchPrefix);
        TestIndexCriteriaBuilder.assertEquals((String)matchPrefix, (String)expectedPrefix);
    }

    public void testDataTypeCriteriaPrefix2() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "BasetypeID", "baseTypeUUID");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"DATATYPES.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testDataTypeCriteriaPrefix3() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "DatatypeID", "dataType?UUID");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"DATATYPES.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testDataTypeCriteriaPrefix4() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "DatatypeID", "dataType*UUID");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"DATATYPES.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testDataTypeCriteria1() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "DatatypeID", "dataTypeUUID");
        this.helpAddToCriteria(criteria, "BasetypeID", "baseTypeUUID");
        this.helpAddToCriteria(criteria, "RuntimeTypeName", "runtTypeName");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"DATATYPES.INDEX", criteria);
        String expectedPattern = "M\u00a0dataTypeUUID\u00a0baseTypeUUID\u00a0Name\u00a0UUID\u00a0nameInSource\u00a0*\u00a0*\u00a0runtTypeName\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testDataTypeCriteria2() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "BasetypeID", "baseTypeUUID");
        this.helpAddToCriteria(criteria, "RuntimeTypeName", "runtTypeName");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"DATATYPES.INDEX", criteria);
        String expectedPattern = "M\u00a0*\u00a0baseTypeUUID\u00a0Name\u00a0UUID\u00a0nameInSource\u00a0*\u00a0*\u00a0runtTypeName\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testPropertyCriteriaPrefix1() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "PropertyName", "propName");
        this.helpAddToCriteria(criteria, "PropertyValue", "propValue");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"PROPERTIES.INDEX", criteria);
        String expectedPrefix = "X\u00a0uuid\u00a0";
        TestIndexCriteriaBuilder.assertNotNull((Object)matchPrefix);
        TestIndexCriteriaBuilder.assertEquals((String)matchPrefix, (String)expectedPrefix);
    }

    public void testPropertyCriteriaPrefix2() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "PropertyName", "propName");
        this.helpAddToCriteria(criteria, "PropertyValue", "propValue");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"PROPERTIES.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testPropertyCriteriaPrefix3() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "PropertyName", "propName");
        this.helpAddToCriteria(criteria, "PropertyValue", "propValue");
        this.helpAddToCriteria(criteria, "UUID", "UU?ID");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"PROPERTIES.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testPropertyCriteriaPrefix4() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "PropertyName", "propName");
        this.helpAddToCriteria(criteria, "PropertyValue", "propValue");
        this.helpAddToCriteria(criteria, "UUID", "UU*ID");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"PROPERTIES.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testPropertyCriteria1() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "PropertyName", "propName");
        this.helpAddToCriteria(criteria, "PropertyValue", "propValue");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"PROPERTIES.INDEX", criteria);
        String expectedPattern = "X\u00a0UUID\u00a0propName\u00a0propValue\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testPropertyCriteria2() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "PropertyName", "propName");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"PROPERTIES.INDEX", criteria);
        String expectedPattern = "X\u00a0UUID\u00a0propName\u00a0*\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testModelCriteriaPrefix1() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"MODELS.INDEX", criteria);
        String expectedPrefix = "A\u00a0NAME\u00a0";
        TestIndexCriteriaBuilder.assertNotNull((Object)matchPrefix);
        TestIndexCriteriaBuilder.assertEquals((String)matchPrefix, (String)expectedPrefix);
    }

    public void testModelCriteriaPrefix2() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"MODELS.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testModelCriteriaPrefix3() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Na?me");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"MODELS.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testModelCriteriaPrefix4() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Nam*e");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"MODELS.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testModelCriteria1() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "FullName", "MyModel");
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"MODELS.INDEX", criteria);
        String expectedPattern = "A\u00a0*\u00a0UUID\u00a0MyModel\u00a0nameInSource\u00a0parentUUID\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testModelCriteria2() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "MyModel");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"MODELS.INDEX", criteria);
        String expectedPattern = "A\u00a0*\u00a0UUID\u00a0MyModel\u00a0nameInSource\u00a0parentUUID\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testModelCriteria3() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "MyModel");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"MODELS.INDEX", criteria);
        String expectedPattern = "A\u00a0*\u00a0UUID\u00a0MyModel\u00a0nameInSource\u00a0parentUUID\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testHeaderCriteriaPrefix1() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "FullName", "MyModel.Name");
        this.helpAddToCriteria(criteria, "ModelName", "MyModel");
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"COLUMNS.INDEX", criteria);
        String expectedPrefix = "G\u00a0MYMODEL.NAME\u00a0";
        TestIndexCriteriaBuilder.assertNotNull((Object)matchPrefix);
        TestIndexCriteriaBuilder.assertEquals((String)matchPrefix, (String)expectedPrefix);
    }

    public void testHeaderCriteriaPrefix2() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "ModelName", "MyModel");
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"COLUMNS.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testHeaderCriteriaPrefix3() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "FullName", "*");
        this.helpAddToCriteria(criteria, "ModelName", "MyModel");
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"COLUMNS.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testHeaderCriteriaPrefix4() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "FullName", "?");
        this.helpAddToCriteria(criteria, "ModelName", "MyModel");
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPrefix = IndexCriteriaBuilder.getMatchPrefix((String)"COLUMNS.INDEX", criteria);
        TestIndexCriteriaBuilder.assertNull((Object)matchPrefix);
    }

    public void testHeaderCriteria1() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "FullName", "MyModel.Name");
        this.helpAddToCriteria(criteria, "ModelName", "MyModel");
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"COLUMNS.INDEX", criteria);
        String expectedPattern = "G\u00a0*\u00a0UUID\u00a0MyModel.Name\u00a0nameInSource\u00a0parentUUID\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testHeaderCriteria2() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "ModelName", "MyModel");
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"COLUMNS.INDEX", criteria);
        String expectedPattern = "G\u00a0*\u00a0UUID\u00a0MyModel.*.Name\u00a0nameInSource\u00a0parentUUID\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testHeaderCriteria3() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        this.helpAddToCriteria(criteria, "Name", "Name");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"COLUMNS.INDEX", criteria);
        String expectedPattern = "G\u00a0*\u00a0UUID\u00a0*.Name\u00a0nameInSource\u00a0parentUUID\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testHeaderCriteria4() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "ModelName", "MyModel");
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"COLUMNS.INDEX", criteria);
        String expectedPattern = "G\u00a0*\u00a0UUID\u00a0MyModel.*\u00a0nameInSource\u00a0parentUUID\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testHeaderCriteria5() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        this.helpAddToCriteria(criteria, "UUID", "UUID");
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"COLUMNS.INDEX", criteria);
        String expectedPattern = "G\u00a0*\u00a0UUID\u00a0*\u00a0nameInSource\u00a0parentUUID\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testNoCriteriaPrefix() {
        HashMap criteria = new HashMap();
        String matchPattern = IndexCriteriaBuilder.getMatchPrefix((String)"COLUMNS.INDEX", criteria);
        String expectedPattern = "G\u00a0";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testNoCriteriaPattern() {
        HashMap criteria = new HashMap();
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"COLUMNS.INDEX", criteria);
        String expectedPattern = "G\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testNullCriteriaPrefix() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "FullName", null);
        String matchPattern = IndexCriteriaBuilder.getMatchPrefix((String)"COLUMNS.INDEX", criteria);
        String expectedPattern = "G\u00a0 \u00a0";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testNullCriteriaPattern() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "FullName", null);
        String matchPattern = IndexCriteriaBuilder.getMatchPattern((String)"COLUMNS.INDEX", criteria);
        String expectedPattern = "G\u00a0*\u00a0*\u00a0 \u00a0*\u00a0*\u00a0*";
        TestIndexCriteriaBuilder.assertEquals((String)matchPattern, (String)expectedPattern);
    }

    public void testGetMetadataLiteralCriteria1() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "ModelName", "MyModel");
        this.helpAddToCriteria(criteria, "ParentUUID", "parentUUID");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        ArrayList<String> criteriaValues = new ArrayList<String>();
        criteriaValues.add("uuid1");
        criteriaValues.add("uuid2");
        criteriaValues.add("uuid3");
        this.helpAddToInCriteria(criteria, "UUID", criteriaValues);
        Collection criteriaMaps = IndexCriteriaBuilder.getLiteralCriteria(criteria);
        TestIndexCriteriaBuilder.assertEquals((int)3, (int)criteriaMaps.size());
    }

    public void testGetMetadataLiteralCriteria2() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "ModelName", "MyModel");
        this.helpAddToCriteria(criteria, "NameInSource", "nameInSource");
        ArrayList<String> criteriaValues = new ArrayList<String>();
        criteriaValues.add("uuid1");
        criteriaValues.add("uuid2");
        criteriaValues.add("uuid3");
        this.helpAddToInCriteria(criteria, "UUID", criteriaValues);
        ArrayList<String> criteriaValues2 = new ArrayList<String>();
        criteriaValues2.add("parentUUID1");
        criteriaValues2.add("parentUUID2");
        criteriaValues2.add("parentUUID3");
        this.helpAddToInCriteria(criteria, "ParentUUID", criteriaValues);
        Collection criteriaMaps = IndexCriteriaBuilder.getLiteralCriteria(criteria);
        TestIndexCriteriaBuilder.assertEquals((int)9, (int)criteriaMaps.size());
    }

    public void testGetMetadataLiteralCriteria3() {
        HashMap criteria = new HashMap();
        this.helpAddToCriteria(criteria, "ModelName", "MyModel");
        ArrayList<String> criteriaValues = new ArrayList<String>();
        criteriaValues.add("uuid1");
        criteriaValues.add("uuid2");
        criteriaValues.add("uuid3");
        this.helpAddToInCriteria(criteria, "UUID", criteriaValues);
        ArrayList<String> criteriaValues2 = new ArrayList<String>();
        criteriaValues2.add("parentUUID1");
        criteriaValues2.add("parentUUID2");
        criteriaValues2.add("parentUUID3");
        this.helpAddToInCriteria(criteria, "ParentUUID", criteriaValues);
        ArrayList<String> criteriaValues3 = new ArrayList<String>();
        criteriaValues3.add("nameInSource1");
        criteriaValues3.add("nameInSource2");
        this.helpAddToInCriteria(criteria, "NameInSource", criteriaValues3);
        Collection criteriaMaps = IndexCriteriaBuilder.getLiteralCriteria(criteria);
        TestIndexCriteriaBuilder.assertEquals((int)18, (int)criteriaMaps.size());
    }
}

