/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.index;

import com.metamatrix.connector.metadata.RuntimeVdbRecord;
import com.metamatrix.connector.metadata.index.FakeVDBService;
import com.metamatrix.connector.metadata.index.MetadataConnectorMetadata;
import com.metamatrix.connector.metadata.index.MetadataLiteralCriteria;
import com.metamatrix.connector.metadata.index.VdbMetadataContext;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.metadata.runtime.ModelRecord;
import com.metamatrix.modeler.internal.core.index.CompositeIndexSelector;
import com.metamatrix.modeler.internal.core.index.RuntimeIndexSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMetadataConnectorMetadata
extends TestCase {
    public static final String TEST_FILE_NAME = UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb";
    private static final String TEST_VDB_NAME = "Parts";
    private static final String TEST_VDB_VERSION = "1";

    public TestMetadataConnectorMetadata(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("TestMetadataConnectorMetadata");
        suite.addTestSuite(TestMetadataConnectorMetadata.class);
        return new TestSetup((Test)suite);
    }

    public MetadataConnectorMetadata helpGetMetadata(String vdbFilePath, String vdbName, String vdbVersion, VDBService service) throws Exception {
        ArrayList<RuntimeIndexSelector> selectors = new ArrayList<RuntimeIndexSelector>();
        selectors.add(new RuntimeIndexSelector(vdbFilePath));
        CompositeIndexSelector composite = new CompositeIndexSelector(selectors);
        VdbMetadataContext context = new VdbMetadataContext((IndexSelector)composite);
        context.setVdbName(vdbName);
        context.setVdbVersion(vdbVersion);
        context.setVdbService(service);
        return new MetadataConnectorMetadata(context);
    }

    public VDBService helpGetVdbService() {
        return new FakeVDBService();
    }

    public void testGetFileRecords() throws Exception {
        String entityPath = "/parts/partsmd/PartsSupplier.xmi";
        FakeVDBService service = (FakeVDBService)this.helpGetVdbService();
        service.publicFiles.add(entityPath);
        MetadataLiteralCriteria literalcriteria = new MetadataLiteralCriteria("getPathInVdb", (Object)entityPath);
        HashMap<String, MetadataLiteralCriteria> criteria = new HashMap<String, MetadataLiteralCriteria>();
        criteria.put("getPathInVdb".toUpperCase(), literalcriteria);
        MetadataConnectorMetadata metadata = this.helpGetMetadata(TEST_FILE_NAME, TEST_VDB_NAME, TEST_VDB_VERSION, service);
        Collection records = metadata.getObjects("FILES.INDEX", criteria);
        TestMetadataConnectorMetadata.assertNotNull((Object)records);
        TestMetadataConnectorMetadata.assertEquals((int)1, (int)records.size());
    }

    public void testGetPublicModelRecords() throws Exception {
        String modelName = "PartsSupplier";
        FakeVDBService service = (FakeVDBService)this.helpGetVdbService();
        service.publicModels.add(modelName);
        MetadataLiteralCriteria literalcriteria = new MetadataLiteralCriteria("FullName", (Object)modelName);
        HashMap<String, MetadataLiteralCriteria> criteria = new HashMap<String, MetadataLiteralCriteria>();
        criteria.put("FullName".toUpperCase(), literalcriteria);
        MetadataConnectorMetadata metadata = this.helpGetMetadata(TEST_FILE_NAME, TEST_VDB_NAME, TEST_VDB_VERSION, service);
        Collection records = metadata.getObjects("MODELS.INDEX", criteria);
        TestMetadataConnectorMetadata.assertNotNull((Object)records);
        TestMetadataConnectorMetadata.assertEquals((int)1, (int)records.size());
        ModelRecord modelRecord = (ModelRecord)records.iterator().next();
        TestMetadataConnectorMetadata.assertTrue((boolean)modelRecord.isVisible());
    }

    public void testGetPrivateModelRecords() throws Exception {
        String modelName = "PartsSupplier";
        FakeVDBService service = (FakeVDBService)this.helpGetVdbService();
        MetadataLiteralCriteria literalcriteria = new MetadataLiteralCriteria("FullName", (Object)modelName);
        HashMap<String, MetadataLiteralCriteria> criteria = new HashMap<String, MetadataLiteralCriteria>();
        criteria.put("FullName".toUpperCase(), literalcriteria);
        MetadataConnectorMetadata metadata = this.helpGetMetadata(TEST_FILE_NAME, TEST_VDB_NAME, TEST_VDB_VERSION, service);
        Collection records = metadata.getObjects("MODELS.INDEX", criteria);
        TestMetadataConnectorMetadata.assertNotNull((Object)records);
        TestMetadataConnectorMetadata.assertEquals((int)1, (int)records.size());
        ModelRecord modelRecord = (ModelRecord)records.iterator().next();
        TestMetadataConnectorMetadata.assertTrue((!modelRecord.isVisible() ? 1 : 0) != 0);
    }

    public void testGetWrappedVdbRecords() throws Exception {
        FakeVDBService service = (FakeVDBService)this.helpGetVdbService();
        HashMap criteria = new HashMap();
        MetadataConnectorMetadata metadata = this.helpGetMetadata(TEST_FILE_NAME, TEST_VDB_NAME, TEST_VDB_VERSION, service);
        Collection records = metadata.getObjects("VDBS.INDEX", criteria);
        TestMetadataConnectorMetadata.assertNotNull((Object)records);
        TestMetadataConnectorMetadata.assertEquals((int)1, (int)records.size());
        RuntimeVdbRecord vdbRecord = (RuntimeVdbRecord)records.iterator().next();
        TestMetadataConnectorMetadata.assertEquals((String)TEST_VDB_NAME, (String)vdbRecord.getVdbRuntimeName());
    }

    public void testGetRecordsWithFalseCriteria() throws Exception {
        String modelName = "PartsSupplier";
        FakeVDBService service = (FakeVDBService)this.helpGetVdbService();
        service.publicModels.add(modelName);
        MetadataLiteralCriteria literalcriteria = new MetadataLiteralCriteria("FullName", (Object)modelName);
        literalcriteria.setFieldFunction("UPPER");
        HashMap<String, MetadataLiteralCriteria> criteria = new HashMap<String, MetadataLiteralCriteria>();
        criteria.put("FullName".toUpperCase(), literalcriteria);
        MetadataConnectorMetadata metadata = this.helpGetMetadata(TEST_FILE_NAME, TEST_VDB_NAME, TEST_VDB_VERSION, service);
        Collection records = metadata.getObjects("MODELS.INDEX", criteria);
        TestMetadataConnectorMetadata.assertNotNull((Object)records);
        TestMetadataConnectorMetadata.assertEquals((int)0, (int)records.size());
    }
}

