/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.index;

import com.metamatrix.connector.metadata.index.FakeVDBService;
import com.metamatrix.connector.metadata.index.MetadataLiteralCriteria;
import com.metamatrix.connector.metadata.index.MetadataResultsPostProcessor;
import com.metamatrix.connector.metadata.index.VdbMetadataContext;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.metadata.runtime.impl.ColumnRecordImpl;
import com.metamatrix.metadata.runtime.impl.ModelRecordImpl;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestMetadataResultsPostProcessor
extends TestCase {
    public TestMetadataResultsPostProcessor(String name) {
        super(name);
    }

    public MetadataResultsPostProcessor helpGetProcessor() {
        VdbMetadataContext context = new VdbMetadataContext();
        context.setVdbName("testvdb");
        context.setVdbVersion("1");
        return new MetadataResultsPostProcessor(context);
    }

    public VDBService helpGetVdbService() {
        return new FakeVDBService();
    }

    public void testFilterCaseMisMatch() {
        String modelName = "PartsSupplier";
        MetadataLiteralCriteria literalcriteria = new MetadataLiteralCriteria("FullName", (Object)modelName);
        HashMap<String, MetadataLiteralCriteria> criteria = new HashMap<String, MetadataLiteralCriteria>();
        criteria.put("FullName".toUpperCase(), literalcriteria);
        ModelRecordImpl modelRecord = new ModelRecordImpl();
        modelRecord.setFullName(modelName.toUpperCase());
        MetadataResultsPostProcessor processor = this.helpGetProcessor();
        MetadataRecord filteredRecord = processor.filterBySearchCriteria((MetadataRecord)modelRecord, criteria);
        TestMetadataResultsPostProcessor.assertNull((Object)filteredRecord);
    }

    public void testFilterWildCardMatch() {
        String modelName = "PartsSupplier";
        MetadataLiteralCriteria literalcriteria = new MetadataLiteralCriteria("FullName", (Object)"*Supplie?");
        HashMap<String, MetadataLiteralCriteria> criteria = new HashMap<String, MetadataLiteralCriteria>();
        criteria.put("FullName".toUpperCase(), literalcriteria);
        ModelRecordImpl modelRecord = new ModelRecordImpl();
        modelRecord.setFullName(modelName);
        MetadataResultsPostProcessor processor = this.helpGetProcessor();
        MetadataRecord filteredRecord = processor.filterBySearchCriteria((MetadataRecord)modelRecord, criteria);
        TestMetadataResultsPostProcessor.assertNotNull((Object)filteredRecord);
    }

    public void testFilterNullMatch() {
        Object uuid = null;
        MetadataLiteralCriteria literalcriteria = new MetadataLiteralCriteria("UUID", uuid);
        HashMap<String, MetadataLiteralCriteria> criteria = new HashMap<String, MetadataLiteralCriteria>();
        criteria.put("UUID".toUpperCase(), literalcriteria);
        ColumnRecordImpl columnRecord = new ColumnRecordImpl();
        columnRecord.setFullName("testname.name");
        columnRecord.setUUID(null);
        MetadataResultsPostProcessor processor = this.helpGetProcessor();
        MetadataRecord filteredRecord = processor.filterBySearchCriteria((MetadataRecord)columnRecord, criteria);
        TestMetadataResultsPostProcessor.assertNotNull((Object)filteredRecord);
    }

    public void testFilterNullMisMatch() {
        Object uuid = null;
        MetadataLiteralCriteria literalcriteria = new MetadataLiteralCriteria("UUID", uuid);
        HashMap<String, MetadataLiteralCriteria> criteria = new HashMap<String, MetadataLiteralCriteria>();
        criteria.put("UUID".toUpperCase(), literalcriteria);
        ColumnRecordImpl columnRecord = new ColumnRecordImpl();
        columnRecord.setFullName("testname.name");
        columnRecord.setUUID("uuid");
        MetadataResultsPostProcessor processor = this.helpGetProcessor();
        MetadataRecord filteredRecord = processor.filterBySearchCriteria((MetadataRecord)columnRecord, criteria);
        TestMetadataResultsPostProcessor.assertNull((Object)filteredRecord);
    }
}

