/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.service.metadata;

import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.dqp.service.metadata.IndexMetadataService;
import com.metamatrix.dqp.service.metadata.QueryMetadataCache;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class TestIndexMetadataService
extends TestCase {
    private QueryMetadataInterface metadata;

    public TestIndexMetadataService(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filePath = UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb";
        QueryMetadataCache sharedCache = new QueryMetadataCache(Thread.currentThread().getContextClassLoader().getResource("System.vdb"));
        IndexMetadataService metadataService = new IndexMetadataService(sharedCache);
        ApplicationEnvironment env = new ApplicationEnvironment();
        VDBService vdbService = (VDBService)Mockito.mock(VDBService.class);
        Mockito.stub((Object)vdbService.getVDBResource("PartsSupplier", "1")).toReturn((Object)new FileInputStream(filePath));
        env.bindService("dqp.vdb", (ApplicationService)vdbService);
        metadataService.start(env);
        this.metadata = metadataService.lookupMetadata("PartsSupplier", "1");
    }

    public void testGetElementID() throws Exception {
        TestIndexMetadataService.assertNotNull((Object)this.getElementID());
    }

    public void testGetGroupIDForElementID() throws Exception {
        TestIndexMetadataService.assertNotNull((Object)this.metadata.getGroupIDForElementID(this.getElementID()));
    }

    public void testGetFullName() throws Exception {
        Object groupID = this.metadata.getGroupIDForElementID(this.getElementID());
        String groupName = this.metadata.getFullName(groupID);
        TestIndexMetadataService.assertEquals((String)"PartsSupplier.PARTSSUPPLIER.PARTS", (String)groupName);
    }

    public void testGetNameInSource() throws Exception {
        String nameInSource = this.metadata.getNameInSource(this.getElementID());
        TestIndexMetadataService.assertEquals((String)"PART_ID", (String)nameInSource);
    }

    public void testGetFullNameForModel() throws Exception {
        Object modelID = this.metadata.getModelID(this.getElementID());
        TestIndexMetadataService.assertNotNull((Object)modelID);
        String modelName = this.metadata.getFullName(modelID);
        TestIndexMetadataService.assertEquals((String)"PartsSupplier", (String)modelName);
    }

    public void testGetFullNameForModelLookupByGroupID() throws Exception {
        Object groupID = this.metadata.getGroupIDForElementID(this.getElementID());
        Object modelID = this.metadata.getModelID(groupID);
        TestIndexMetadataService.assertNotNull((Object)modelID);
        String modelName = this.metadata.getFullName(modelID);
        TestIndexMetadataService.assertEquals((String)"PartsSupplier", (String)modelName);
    }

    public void testGetGroupIDCaseInsensitive() throws Exception {
        Object groupID = this.metadata.getGroupID("PartsSupplier.PARTSSUPPLIEr.PARTs");
        String groupName = this.metadata.getFullName(groupID);
        TestIndexMetadataService.assertEquals((String)"PartsSupplier.PARTSSUPPLIER.PARTS", (String)groupName);
    }

    public void testGetFullElementName() throws Exception {
        String name = this.metadata.getFullElementName("PartsSupplier.PartsSupplier.PARTS", "PART_ID");
        TestIndexMetadataService.assertEquals((String)"PartsSupplier.PartsSupplier.PARTS.PART_ID", (String)name);
    }

    public void testGetElementIDsInGroupID() throws Exception {
        Object groupID = this.getGroupID();
        List eIDs = this.metadata.getElementIDsInGroupID(groupID);
        TestIndexMetadataService.assertEquals((int)4, (int)eIDs.size());
    }

    public void testGroupSize() throws Exception {
        Collection groups = this.metadata.getGroupsForPartialName("PARTS");
        TestIndexMetadataService.assertEquals((int)1, (int)groups.size());
    }

    public void testIsVirtualGroup() throws Exception {
        Object groupID = this.getGroupID();
        TestIndexMetadataService.assertFalse((boolean)this.metadata.isVirtualGroup(groupID));
    }

    private Object getElementID() throws Exception {
        return this.metadata.getElementID("PartsSupplier.PARTSSUPPLIER.PARTS.PART_ID");
    }

    public Object getGroupID() throws Exception {
        return this.metadata.getGroupID("PartsSupplier.PARTSSUPPLIER.PARTS");
    }
}

