/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.metadata.runtime.model.BasicModel;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;

public class TestModelClasses
extends TestCase {
    public TestModelClasses(String name) {
        super(name);
    }

    public void testModel1() throws Exception {
        BasicModelID id = new BasicModelID("model", "1");
        BasicVirtualDatabaseID vdbid = new BasicVirtualDatabaseID("vdb", "1");
        BasicModel m = new BasicModel(id, vdbid);
        m = this.buildModel(m, 0, 0, 0);
        this.validateModel(m, 0, 0, 0);
    }

    public void testModel2() throws Exception {
        BasicModelID id = new BasicModelID("model", "2");
        BasicVirtualDatabaseID vdbid = new BasicVirtualDatabaseID("vdb", "2");
        BasicModel m = new BasicModel(id, vdbid);
        m = this.buildModel(m, 2, 1, 0);
        this.validateModel(m, 2, 1, 0);
    }

    public void testModel3() throws Exception {
        BasicModelID id = new BasicModelID("model", "2");
        BasicVirtualDatabaseID vdbid = new BasicVirtualDatabaseID("vdb", "2");
        BasicModelInfo bmi = new BasicModelInfo("basicmodelinfoX");
        bmi = this.buildModelInfo(bmi, 2, 3);
        this.validateModelInfo(bmi, 2, 3);
        BasicModel m = new BasicModel(id, vdbid, (ModelInfo)bmi);
        this.validateModel(m, 2, 0, bmi.getModelType());
    }

    public void testModelInfo1() throws Exception {
        BasicModelInfo bmi = new BasicModelInfo("basicmodelinfo1");
        bmi = this.buildModelInfo(bmi, 0, 0);
        this.validateModelInfo(bmi, 0, 0);
    }

    public void testModelInfo2() throws Exception {
        BasicModelInfo bmi = new BasicModelInfo("basicmodelinfo1");
        bmi = this.buildModelInfo(bmi, 2, 3);
        this.validateModelInfo(bmi, 2, 3);
    }

    private BasicModel buildModel(BasicModel m, int bindings, int props, int modelType) throws Exception {
        int x;
        m.setDescription("model description");
        m.setGUID("guid");
        m.setIsVisible(true);
        m.setModelType(modelType);
        m.setModelURI("uri");
        m.setProperties(new Properties());
        m.enableMutliSourceBindings(false);
        m.setVersionDate(new Date());
        m.setVersionedBy("versionedby");
        m.setVisibility((short)0);
        for (x = 0; x < bindings; ++x) {
            m.addConnectorBindingName("connectorbinding" + x);
        }
        for (x = 0; x < props; ++x) {
            m.addProperty("name" + x, "property" + x);
        }
        return m;
    }

    private void validateModel(BasicModel m, int bindings, int props, int modelType) throws Exception {
        if (m.getConnectorBindingNames().size() != bindings) {
            TestModelClasses.fail((String)("Model " + m.getID() + " should have had " + bindings + " connector bindings"));
        }
        if (props > 0 && m.getProperties().size() != props) {
            TestModelClasses.fail((String)("Model " + m.getID() + " should have had " + props + " properties"));
        } else if (props == 0 && m.getProperties() != null && m.getProperties().size() != props) {
            TestModelClasses.fail((String)("Model " + m.getID() + " should have had " + props + " properties"));
        }
        TestModelClasses.assertNotNull((Object)m.getDateVersioned());
        TestModelClasses.assertNotNull((Object)m.getDescription());
        TestModelClasses.assertNotNull((Object)m.getFullName());
        TestModelClasses.assertNotNull((Object)m.getGUID());
        TestModelClasses.assertNotNull((Object)m.getID());
        TestModelClasses.assertEquals((int)modelType, (int)m.getModelType());
        TestModelClasses.assertNotNull((Object)m.getModelTypeName());
        TestModelClasses.assertNotNull((Object)m.getModelURI());
        TestModelClasses.assertNotNull((Object)m.getName());
        TestModelClasses.assertNotNull((Object)m.getNameInSource());
        TestModelClasses.assertNotNull((Object)m.getVersion());
        TestModelClasses.assertNotNull((Object)m.getVersionedBy());
        TestModelClasses.assertNotNull((Object)m.getVirtualDatabaseID());
        TestModelClasses.assertEquals((short)0, (short)m.getVisibility());
    }

    private BasicModelInfo buildModelInfo(BasicModelInfo bmi, int bindings, int files) {
        bmi.setIsVisible(true);
        if (files > 0) {
            bmi.setModelType(10);
        } else {
            bmi.setModelType(0);
        }
        bmi.setModelURI("uri");
        bmi.setUuid("uuid");
        bmi.setVersion("1");
        bmi.setDescription("desc");
        bmi.setVersionDate(new Date());
        bmi.setVersionedBy("versionedBY");
        bmi.setVisibility((short)0);
        bmi.enableMutliSourceBindings(false);
        for (int x = 0; x < bindings; ++x) {
            bmi.addConnectorBindingByName("uuid" + x);
        }
        HashMap<String, String> fm = new HashMap<String, String>(files);
        for (int x = 0; x < files; ++x) {
            fm.put("filename" + x, "filename" + x);
        }
        bmi.setDDLFiles(fm);
        return bmi;
    }

    private void validateModelInfo(BasicModelInfo m, int bindings, int files) {
        TestModelClasses.assertNotNull((Object)m.getDateVersioned());
        TestModelClasses.assertNotNull((Object)m.getName());
        TestModelClasses.assertNotNull((Object)m.getUUID());
        if (files > 0) {
            TestModelClasses.assertEquals((int)10, (int)m.getModelType());
        } else {
            TestModelClasses.assertEquals((int)0, (int)m.getModelType());
        }
        TestModelClasses.assertNotNull((Object)m.getModelTypeName());
        TestModelClasses.assertNotNull((Object)m.getModelURI());
        TestModelClasses.assertNotNull((Object)m.getName());
        TestModelClasses.assertNotNull((Object)m.getDescription());
        TestModelClasses.assertNotNull((Object)m.getVersion());
        TestModelClasses.assertNotNull((Object)m.getVersionedBy());
        TestModelClasses.assertNotNull((Object)m.getDateVersioned());
        TestModelClasses.assertEquals((short)0, (short)m.getVisibility());
        if (m.getConnectorBindingNames().size() != bindings) {
            TestModelClasses.fail((String)("Model " + m.getName() + " should have had " + bindings + " connector bindings, but found " + m.getConnectorBindingNames().size()));
        }
        TestModelClasses.assertEquals((int)files, (int)m.getDDLFileNames().length);
    }
}

