/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.service.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.connector.metadata.IndexFile;
import com.metamatrix.connector.metadata.MultiObjectSource;
import com.metamatrix.connector.metadata.PropertyFileObjectSource;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.internal.core.index.CompositeIndexSelector;
import com.metamatrix.modeler.internal.core.index.RuntimeIndexSelector;
import com.metamatrix.modeler.transformation.metadata.ServerMetadataFactory;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.vdb.runtime.VDBKey;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class QueryMetadataCache {
    private Map vdbToQueryMetadata = new HashMap();
    private Map vdbToCompositeSelector = new HashMap();
    private Map vdbToRuntimeSelector = new HashMap();
    private final RuntimeIndexSelector systemVDBSelector;
    private boolean isCacheValid = true;

    public QueryMetadataCache(URL systemVdbUrl) throws MetaMatrixComponentException {
        try {
            this.systemVDBSelector = this.getRuntimeIndexSelector(systemVdbUrl);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", new Object[]{"System.vdb"}));
        }
    }

    public QueryMetadataCache(byte[] sysemVdbContent) throws MetaMatrixComponentException {
        try {
            this.systemVDBSelector = this.getRuntimeIndexSelector("System.vdb", sysemVdbContent);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", new Object[]{"System.vdb"}));
        }
    }

    public QueryMetadataCache(String filePath) throws MetaMatrixComponentException {
        try {
            URL systemVdbUrl = new URL("file:///" + filePath);
            this.systemVDBSelector = this.getRuntimeIndexSelector(systemVdbUrl);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", new Object[]{"System.vdb"}));
        }
    }

    public boolean isValid() {
        return this.isCacheValid;
    }

    public IndexSelector getCompositeSelector(String vdbName, String vdbVersion) {
        this.assertIsValidCache();
        VDBKey vdbID = this.toVdbID(vdbName, vdbVersion);
        return (IndexSelector)this.vdbToCompositeSelector.get(vdbID);
    }

    public IObjectSource getCompositeMetadataObjectSource(String vdbName, String vdbVersion, VDBService vdbService) {
        IndexSelector indexSelector = this.getCompositeSelector(vdbName, vdbVersion);
        IndexFile indexFile = new IndexFile(indexSelector, vdbName, vdbVersion, vdbService);
        PropertyFileObjectSource propertyFileSource = new PropertyFileObjectSource();
        MultiObjectSource multiObjectSource = new MultiObjectSource(indexFile, ".properties", propertyFileSource);
        return multiObjectSource;
    }

    public QueryMetadataInterface lookupMetadata(String vdbName, String vdbVersion) {
        this.assertIsValidCache();
        VDBKey vdbID = this.toVdbID(vdbName, vdbVersion);
        QueryMetadataInterfaceHolder qmiHolder = (QueryMetadataInterfaceHolder)this.vdbToQueryMetadata.get(vdbID);
        if (qmiHolder != null) {
            return qmiHolder.getQueryMetadataInteface();
        }
        return null;
    }

    public QueryMetadataInterface lookupMetadata(String vdbName, String vdbVersion, byte[] vdbContent) throws MetaMatrixComponentException {
        QueryMetadataInterfaceHolder qmiHolder = this.createMetadataHolder(vdbName, vdbVersion);
        return qmiHolder.getQueryMetadataInteface(vdbContent);
    }

    public QueryMetadataInterface lookupMetadata(String vdbName, String vdbVersion, InputStream vdbContent) throws MetaMatrixComponentException {
        QueryMetadataInterfaceHolder qmiHolder = this.createMetadataHolder(vdbName, vdbVersion);
        return qmiHolder.getQueryMetadataInteface(vdbContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryMetadataInterfaceHolder createMetadataHolder(String vdbName, String vdbVersion) {
        this.assertIsValidCache();
        VDBKey vdbID = this.toVdbID(vdbName, vdbVersion);
        QueryMetadataInterfaceHolder qmiHolder = null;
        Map map = this.vdbToQueryMetadata;
        synchronized (map) {
            qmiHolder = (QueryMetadataInterfaceHolder)this.vdbToQueryMetadata.get(vdbID);
            if (qmiHolder == null) {
                qmiHolder = new QueryMetadataInterfaceHolder(vdbID, vdbName);
                this.vdbToQueryMetadata.put(vdbID, qmiHolder);
            }
        }
        return qmiHolder;
    }

    private void assertIsValidCache() {
        if (!this.isValid()) {
            throw new MetaMatrixRuntimeException(DQPPlugin.Util.getString("QueryMetadataCache.cache_not_valid"));
        }
    }

    private QueryMetadataInterface loadMetadata(VDBKey vdbID, RuntimeIndexSelector runtimeSelector) throws MetaMatrixComponentException {
        this.assertIsValidCache();
        this.vdbToRuntimeSelector.put(vdbID, runtimeSelector);
        ArrayList<RuntimeIndexSelector> selectors = new ArrayList<RuntimeIndexSelector>(2);
        selectors.add(runtimeSelector);
        if (this.systemVDBSelector != null && this.systemVDBSelector.isValid()) {
            selectors.add(this.systemVDBSelector);
        }
        CompositeIndexSelector composite = new CompositeIndexSelector(selectors);
        this.vdbToCompositeSelector.put(vdbID, composite);
        QueryMetadataInterface result = ServerMetadataFactory.getInstance().createCachingServerMetadata(composite);
        return result;
    }

    private RuntimeIndexSelector getRuntimeIndexSelector(String vdbName, byte[] vdbContents) {
        RuntimeIndexSelector runtimeSelector = null;
        try {
            String vdbFileName = vdbName + '.' + "vdb";
            runtimeSelector = new RuntimeIndexSelector(vdbFileName, vdbContents);
            runtimeSelector.getIndexes();
        }
        catch (IOException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", new Object[]{vdbName}));
        }
        return runtimeSelector;
    }

    private RuntimeIndexSelector getRuntimeIndexSelector(String vdbName, InputStream vdbContents) {
        RuntimeIndexSelector runtimeSelector = null;
        try {
            String vdbFileName = vdbName + '.' + "vdb";
            runtimeSelector = new RuntimeIndexSelector(vdbFileName, vdbContents);
            runtimeSelector.getIndexes();
        }
        catch (IOException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", new Object[]{vdbName}));
        }
        return runtimeSelector;
    }

    private RuntimeIndexSelector getRuntimeIndexSelector(URL path) {
        RuntimeIndexSelector runtimeSelector = null;
        try {
            runtimeSelector = new RuntimeIndexSelector(path);
            runtimeSelector.getIndexes();
        }
        catch (IOException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", new Object[]{path}));
        }
        return runtimeSelector;
    }

    public void clearCache() {
        LogManager.logTrace((String)"DQP", (Object[])new Object[]{"QueryMetadataCache Clearing VDB cache"});
        this.isCacheValid = false;
        this.vdbToQueryMetadata.clear();
        for (RuntimeIndexSelector selector : this.vdbToRuntimeSelector.values()) {
            selector.setValid(false);
            selector.clearVDB();
        }
        this.vdbToRuntimeSelector.clear();
        if (this.systemVDBSelector != null) {
            this.systemVDBSelector.setValid(false);
            this.systemVDBSelector.clearVDB();
        }
        this.vdbToCompositeSelector.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String vdbName, String vdbVersion) {
        LogManager.logTrace((String)"DQP", (Object[])new Object[]{"QueryMetadataCache Removing vdb from cache", vdbName, vdbVersion});
        if (vdbName != null && vdbVersion != null) {
            VDBKey vdbID = this.toVdbID(vdbName, vdbVersion);
            QueryMetadataInterfaceHolder qmiHolder = null;
            RuntimeIndexSelector selector = null;
            Map map = this.vdbToQueryMetadata;
            synchronized (map) {
                qmiHolder = (QueryMetadataInterfaceHolder)this.vdbToQueryMetadata.get(vdbID);
                if (qmiHolder != null) {
                    this.vdbToQueryMetadata.remove(vdbID);
                }
                this.vdbToCompositeSelector.remove(vdbID);
                selector = (RuntimeIndexSelector)this.vdbToRuntimeSelector.remove(vdbID);
            }
            if (selector != null) {
                selector.clearVDB();
            }
        }
    }

    private VDBKey toVdbID(String vdbName, String vdbVersion) {
        return new VDBKey(vdbName, vdbVersion);
    }

    public QueryMetadataInterface testLoadMetadata(String vdbName, String vdbVersion, String filePath) throws MetaMatrixComponentException {
        VDBKey vdbID = this.toVdbID(vdbName, vdbVersion);
        try {
            return this.loadMetadata(vdbID, this.getRuntimeIndexSelector(new URL("file:///" + filePath)));
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    protected class QueryMetadataInterfaceHolder {
        private final VDBKey vdbId;
        private final String vdbName;
        private QueryMetadataInterface qmi;

        protected QueryMetadataInterfaceHolder(VDBKey vdbId, String vdbName) {
            this.vdbId = vdbId;
            this.vdbName = vdbName;
        }

        protected QueryMetadataInterface getQueryMetadataInteface() {
            return this.qmi;
        }

        protected synchronized QueryMetadataInterface getQueryMetadataInteface(byte[] vdbContent) throws MetaMatrixComponentException {
            if (this.qmi == null) {
                this.qmi = QueryMetadataCache.this.loadMetadata(this.vdbId, QueryMetadataCache.this.getRuntimeIndexSelector(this.vdbName, vdbContent));
            }
            return this.qmi;
        }

        protected synchronized QueryMetadataInterface getQueryMetadataInteface(InputStream vdbContent) throws MetaMatrixComponentException {
            if (this.qmi == null) {
                this.qmi = QueryMetadataCache.this.loadMetadata(this.vdbId, QueryMetadataCache.this.getRuntimeIndexSelector(this.vdbName, vdbContent));
            }
            return this.qmi;
        }
    }
}

