/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.internal.core.index.CodeByteStream;
import com.metamatrix.internal.core.index.IndexBlock;
import com.metamatrix.internal.core.index.Util;
import com.metamatrix.internal.core.index.WordEntry;
import java.io.UTFDataFormatException;

public class GammaCompressedIndexBlock
extends IndexBlock {
    CodeByteStream writeCodeStream = new CodeByteStream();
    CodeByteStream readCodeStream = new CodeByteStream(this.field.buffer());
    char[] prevWord = null;
    int offset = 0;

    public GammaCompressedIndexBlock(int blockSize) {
        super(blockSize);
    }

    @Override
    public boolean addEntry(WordEntry entry) {
        this.writeCodeStream.reset();
        this.encodeEntry(entry, this.prevWord, this.writeCodeStream);
        if (this.offset + this.writeCodeStream.byteLength() > this.blockSize - 2) {
            return false;
        }
        byte[] bytes = this.writeCodeStream.toByteArray();
        this.field.put(this.offset, bytes);
        this.offset += bytes.length;
        this.prevWord = entry.getWord();
        return true;
    }

    protected void encodeEntry(WordEntry entry, char[] prevWord, CodeByteStream codeStream) {
        char[] word = entry.getWord();
        int prefixLen = prevWord == null ? 0 : Math.min(Util.prefixLength(prevWord, word), 255);
        codeStream.writeByte(prefixLen);
        codeStream.writeUTF(word, prefixLen, word.length);
        int n = entry.getNumRefs();
        codeStream.writeGamma(n);
        int prevRef = 0;
        for (int i = 0; i < n; ++i) {
            int ref = entry.getRef(i);
            if (ref <= prevRef) {
                throw new IllegalArgumentException();
            }
            codeStream.writeGamma(ref - prevRef);
            prevRef = ref;
        }
    }

    @Override
    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.offset = 0;
            this.prevWord = null;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.offset == 0;
    }

    @Override
    public boolean nextEntry(WordEntry entry) {
        try {
            this.readCodeStream.reset(this.field.buffer(), this.offset);
            int prefixLength = this.readCodeStream.readByte();
            char[] word = this.readCodeStream.readUTF();
            if (this.prevWord != null && prefixLength > 0) {
                char[] temp = new char[prefixLength + word.length];
                System.arraycopy(this.prevWord, 0, temp, 0, Math.min(prefixLength, this.prevWord.length));
                System.arraycopy(word, 0, temp, Math.min(prefixLength, this.prevWord.length), word.length);
                word = temp;
            }
            if (word.length == 0) {
                return false;
            }
            entry.reset(word);
            int n = this.readCodeStream.readGamma();
            int prevRef = 0;
            for (int i = 0; i < n; ++i) {
                int ref = prevRef + this.readCodeStream.readGamma();
                if (ref < prevRef) {
                    throw new InternalError();
                }
                entry.addRef(ref);
                prevRef = ref;
            }
            this.offset = this.readCodeStream.byteLength();
            this.prevWord = word;
            return true;
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.offset = 0;
        this.prevWord = null;
    }
}

