/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.internal.core.index.Util;
import java.util.Arrays;

public class WordEntry
implements Comparable<WordEntry> {
    protected char[] fWord;
    protected int fNumRefs;
    protected int[] fRefs;

    public WordEntry() {
        this(new char[0]);
    }

    public WordEntry(char[] word) {
        this.fWord = word;
        this.fNumRefs = 0;
        this.fRefs = new int[1];
    }

    public int addRef(int fileNum) {
        if (this.fNumRefs > 0 && this.fRefs[this.fNumRefs - 1] == fileNum) {
            return 0;
        }
        if (this.fNumRefs < this.fRefs.length) {
            this.fRefs[this.fNumRefs++] = fileNum;
            return 0;
        }
        int newSize = this.fNumRefs < 4 ? 4 : this.fNumRefs * 2;
        this.fRefs = new int[newSize];
        System.arraycopy(this.fRefs, 0, this.fRefs, 0, this.fNumRefs);
        this.fRefs[this.fNumRefs++] = fileNum;
        return (newSize - this.fNumRefs + 1) * 4;
    }

    public void addRefs(int[] refs) {
        int[] newRefs = new int[this.fNumRefs + refs.length];
        int pos1 = 0;
        int pos2 = 0;
        int posNew = 0;
        int r1 = 0;
        int r2 = 0;
        while (pos1 < this.fNumRefs || pos2 < refs.length) {
            int compare;
            if (pos1 >= this.fNumRefs) {
                r2 = refs[pos2];
                compare = -1;
            } else if (pos2 >= refs.length) {
                compare = 1;
                r1 = this.fRefs[pos1];
            } else {
                r1 = this.fRefs[pos1];
                r2 = refs[pos2];
                compare = r2 - r1;
            }
            if (compare > 0) {
                newRefs[posNew] = r1;
                ++posNew;
                ++pos1;
                continue;
            }
            if (r2 != 0) {
                newRefs[posNew] = r2;
                ++posNew;
            }
            ++pos2;
        }
        this.fRefs = newRefs;
        this.fNumRefs = posNew;
    }

    public int footprint() {
        return 20 + (8 + this.fWord.length * 2) + (8 + this.fRefs.length * 4);
    }

    public int getNumRefs() {
        return this.fNumRefs;
    }

    public int getRef(int i) {
        if (i < this.fNumRefs) {
            return this.fRefs[i];
        }
        throw new IndexOutOfBoundsException();
    }

    public int[] getRefs() {
        int[] result = new int[this.fNumRefs];
        System.arraycopy(this.fRefs, 0, result, 0, this.fNumRefs);
        return result;
    }

    public char[] getWord() {
        return this.fWord;
    }

    public void mapRefs(int[] mappings) {
        int position = 0;
        for (int i = 0; i < this.fNumRefs; ++i) {
            int map = mappings[this.fRefs[i]];
            if (map == -1 || map == 0) continue;
            this.fRefs[position++] = map;
        }
        this.fNumRefs = position;
        this.fRefs = new int[this.fNumRefs];
        System.arraycopy(this.fRefs, 0, this.fRefs, 0, this.fNumRefs);
        Arrays.sort(this.fRefs);
    }

    public void reset(char[] word) {
        int i = this.fNumRefs;
        while (i-- > 0) {
            this.fRefs[i] = 0;
        }
        this.fNumRefs = 0;
        this.fWord = word;
    }

    public String toString() {
        return new String(this.fWord);
    }

    @Override
    public int compareTo(WordEntry other) {
        return Util.compare(this.fWord, other.fWord);
    }
}

