/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.metadata.runtime.api.ElementID;
import com.metamatrix.metadata.runtime.api.Group;
import com.metamatrix.metadata.runtime.api.KeyID;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.model.BasicGroupID;
import com.metamatrix.metadata.runtime.model.BasicMetadataObject;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class BasicGroup
extends BasicMetadataObject
implements Group {
    private String path;
    private String description;
    private boolean isPhysical = true;
    private boolean isSystem = false;
    private short tableType = Short.MIN_VALUE;
    private String queryPlan;
    private boolean hasQueryPlan;
    private String updateQueryPlan;
    private boolean hasUpdateQueryPlan;
    private boolean updateAllowed;
    private String insertQueryPlan;
    private boolean hasInsertQueryPlan;
    private boolean insertAllowed;
    private String deleteQueryPlan;
    private boolean hasDeleteQueryPlan;
    private boolean deleteAllowed;
    private String alias;
    private transient Collection keys = new HashSet();
    private transient List elements = new ArrayList();
    private boolean sup_UPDATE;
    private boolean isVirtualDocument;
    private Collection xmlSchemas;

    public BasicGroup(BasicGroupID groupID, BasicVirtualDatabaseID virtualDBID) {
        super(groupID, virtualDBID);
    }

    @Override
    public String getPath() {
        if (this.path != null) {
            return this.path;
        }
        return this.getID().getPath();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
        MetadataID id = super.getID();
        if (id != null && id instanceof BasicGroupID) {
            ((BasicGroupID)id).setAlias(alias);
        }
    }

    @Override
    public boolean isPhysical() {
        return this.isPhysical;
    }

    @Override
    public short getTableType() {
        return this.tableType;
    }

    @Override
    public Collection getKeyIDs() {
        return this.keys;
    }

    @Override
    public List getElementIDs() {
        return this.elements;
    }

    @Override
    public boolean isSystemTable() {
        return this.isSystem;
    }

    public boolean hasQueryPlan() {
        return this.hasQueryPlan;
    }

    @Override
    public String getQueryPlan() {
        return this.queryPlan;
    }

    @Override
    public String getMappingDocument() {
        return this.queryPlan;
    }

    @Override
    public boolean supportsUpdate() {
        return this.sup_UPDATE;
    }

    @Override
    public boolean isVirtualDocument() {
        return this.isVirtualDocument;
    }

    @Override
    public Collection getXMLSchemas() {
        if (this.xmlSchemas == null) {
            this.xmlSchemas = Collections.EMPTY_SET;
        }
        return this.xmlSchemas;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIsPhysical(boolean isPhysical) {
        this.isPhysical = isPhysical;
    }

    public void setIsSystem(boolean isSystem) {
        this.isSystem = isSystem;
    }

    public void setQueryPlan(String plan) {
        this.queryPlan = plan;
    }

    public void setTableType(short type) {
        this.tableType = type;
        this.isVirtualDocument = this.tableType != 0 && this.tableType != 1 && this.tableType != 5;
    }

    public void setKeyIDs(Collection keys) {
        this.keys = keys;
    }

    public void clearKeyIDs() {
        if (this.keys != null) {
            this.keys.clear();
        }
    }

    public void setElementIDs(List elements) {
        this.elements = elements;
    }

    public void clearElementIDs() {
        if (this.elements != null) {
            this.elements.clear();
        }
    }

    public void addKeyID(KeyID keyID) {
        if (this.keys == null) {
            this.keys = new HashSet();
        }
        this.keys.add(keyID);
    }

    public boolean containsKeyID(KeyID keyID) {
        if (this.keys == null) {
            return false;
        }
        return this.keys.contains(keyID);
    }

    public void removeKeyID(KeyID keyID) {
        if (this.keys != null) {
            this.keys.remove(keyID);
        }
    }

    public void addElementID(ElementID elementID) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        if (!this.elements.contains(elementID)) {
            this.elements.add(elementID);
        }
    }

    public void addElementID(int position, ElementID elementID) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        if (!this.elements.contains(elementID) && position > 0) {
            this.elements.add(position - 1, elementID);
        } else if (this.elements.contains(elementID) && position > 0) {
            this.elements.set(position - 1, elementID);
        }
    }

    public boolean containsElementID(ElementID elementID) {
        if (this.elements == null) {
            return false;
        }
        return this.elements.contains(elementID);
    }

    public void removeElementID(ElementID elementID) {
        if (this.elements != null) {
            this.elements.remove(elementID);
        }
    }

    public void setHasQueryPlan(boolean hasQueryPlan) {
        this.hasQueryPlan = hasQueryPlan;
    }

    public void setMappingDocument(String document) {
        this.queryPlan = document;
    }

    public void setSupportsUpdate(boolean sup_UPDATE) {
        this.sup_UPDATE = sup_UPDATE;
    }

    public void setXMLSchemas(Collection xmlSchemas) {
        this.xmlSchemas = xmlSchemas;
    }

    @Override
    public String getDeleteQueryPlan() {
        return this.deleteQueryPlan;
    }

    @Override
    public String getInsertQueryPlan() {
        return this.insertQueryPlan;
    }

    @Override
    public String getUpdateQueryPlan() {
        return this.updateQueryPlan;
    }

    public void setDeleteQueryPlan(String deleteQueryPlan) {
        this.deleteQueryPlan = deleteQueryPlan;
    }

    public void setInsertQueryPlan(String insertQueryPlan) {
        this.insertQueryPlan = insertQueryPlan;
    }

    public void setUpdateQueryPlan(String updateQueryPlan) {
        this.updateQueryPlan = updateQueryPlan;
    }

    public void setHasDeleteQueryPlan(boolean hasDeleteQueryPlan) {
        this.hasDeleteQueryPlan = hasDeleteQueryPlan;
    }

    public boolean hasDeleteQueryPlan() {
        return this.hasDeleteQueryPlan;
    }

    public void setHasInsertQueryPlan(boolean hasInsertQueryPlan) {
        this.hasInsertQueryPlan = hasInsertQueryPlan;
    }

    public boolean hasInsertQueryPlan() {
        return this.hasInsertQueryPlan;
    }

    public void setHasUpdateQueryPlan(boolean hasUpdateQueryPlan) {
        this.hasUpdateQueryPlan = hasUpdateQueryPlan;
    }

    public boolean hasUpdateQueryPlan() {
        return this.hasUpdateQueryPlan;
    }

    @Override
    public boolean isDeleteAllowed() {
        return this.deleteAllowed;
    }

    @Override
    public boolean isInsertAllowed() {
        return this.insertAllowed;
    }

    @Override
    public boolean isUpdateAllowed() {
        return this.updateAllowed;
    }

    public void setDeleteAllowed(boolean deleteAllowed) {
        this.deleteAllowed = deleteAllowed;
    }

    public void setInsertAllowed(boolean insertAllowed) {
        this.insertAllowed = insertAllowed;
    }

    public void setUpdateAllowed(boolean updateAllowed) {
        this.updateAllowed = updateAllowed;
    }

    @Override
    public String toString() {
        StringBuffer sw = new StringBuffer();
        sw.append("Group: " + this.getName());
        sw.append("\n\tSupportsUpdates: " + this.supportsUpdate());
        sw.append("\n\tisVirtual " + this.isVirtualDocument());
        sw.append("\n\tisPhysical: " + this.isPhysical());
        sw.append("\n\tIsSystem: " + this.isSystemTable());
        return sw.toString();
    }
}

