/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.metadata.runtime.api.DataType;
import com.metamatrix.metadata.runtime.api.ProcedureID;
import com.metamatrix.metadata.runtime.api.ProcedureParameter;
import com.metamatrix.metadata.runtime.model.BasicProcedureID;

public class BasicProcedureParameter
implements ProcedureParameter {
    private BasicProcedureID procID;
    private DataType dataType;
    private short parameterType;
    private boolean isOptional;
    private int position;
    private int resultSetPosition;
    private String name;
    private String defaultValue;

    public BasicProcedureParameter(String name, BasicProcedureID procedureID, DataType dType, short paramType, int paramPosition, int resultSetPosition, boolean isOpitional) {
        this.procID = procedureID;
        this.dataType = dType;
        this.parameterType = paramType;
        this.position = paramPosition;
        this.name = name;
        this.isOptional = isOpitional;
        this.resultSetPosition = resultSetPosition;
    }

    public BasicProcedureParameter(String name) {
        this.name = name;
    }

    public BasicProcedureParameter(String name, BasicProcedureID procedureID) {
        this.name = name;
        this.procID = procedureID;
    }

    public String getNameInSource() {
        return this.getName();
    }

    @Override
    public DataType getDataType() {
        if (this.dataType.getType() == 2) {
            return this.dataType;
        }
        if (this.dataType.getRuntimeType() != null) {
            return this.dataType.getRuntimeType();
        }
        return this.dataType;
    }

    public DataType getActualDataType() {
        return this.dataType;
    }

    @Override
    public short getParameterType() {
        return this.parameterType;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getResultSetPosition() {
        return this.resultSetPosition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setIsOptional(boolean optional) {
        this.isOptional = optional;
    }

    public void setPosition(int pos) {
        this.position = pos;
    }

    public void setParameterType(short type) {
        this.parameterType = type;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setResultSetPosition(int resultSetPosition) {
        this.resultSetPosition = resultSetPosition;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public ProcedureID getProcID() {
        return this.procID;
    }

    public void setProcID(BasicProcedureID procID) {
        this.procID = procID;
    }

    public String toString() {
        return this.name;
    }
}

