/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.util;

import com.metamatrix.metadata.runtime.api.ElementID;
import com.metamatrix.metadata.runtime.api.GroupID;
import com.metamatrix.metadata.runtime.api.KeyID;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.ProcedureID;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;

public class RuntimeIDParser {
    private static final String PERIOD = ".";
    private static final String BLANK = "";

    public static String getPath(MetadataID id) {
        if (id instanceof VirtualDatabaseID || id instanceof ModelID) {
            return BLANK;
        }
        int startIDX = 1;
        int endIDX = -1;
        int size = id.getNameComponents().size();
        if (id instanceof GroupID || id instanceof ProcedureID) {
            if (size <= 2) {
                return BLANK;
            }
            endIDX = size - 1;
        } else if (id instanceof ElementID || id instanceof KeyID) {
            if (size <= 3) {
                return BLANK;
            }
            endIDX = size - 2;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = startIDX; i < endIDX; ++i) {
            if (i > startIDX) {
                sb.append(PERIOD);
            }
            sb.append(id.getNameComponent(i));
        }
        return sb.toString();
    }

    public static String getGroupName(MetadataID id) {
        if (id instanceof ElementID || id instanceof KeyID) {
            int size = id.getNameComponents().size();
            return id.getNameComponent(size - 2);
        }
        return BLANK;
    }

    public static String getGroupFullName(MetadataID id) {
        if (id instanceof ElementID || id instanceof KeyID) {
            int size = id.getNameComponents().size();
            return id.getFullName().substring(0, id.getFullName().indexOf(id.getNameComponent(size - 1)) - 1);
        }
        return BLANK;
    }
}

