/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.types;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatatypeConstants {
    public static final String BUILTIN_DATATYPES_URI = "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance";
    public static final String SCHEMA_FOR_ENTERPRISE_DATATYPES_URI_2005 = "http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes";
    public static final String PREFIX_FOR_ENTERPRISE_DATATYPES_URI_2005 = "mmedt";
    public static final String DATATYPES_ZIP_FILE_NAME = "builtInDatatypes.zip";
    public static final String DATATYPES_INDEX_FILE_NAME = "builtInDataTypes.INDEX";
    public static final String DATATYPES_MODEL_FILE_NAME = "builtInDataTypes.xsd";
    public static final String DATATYPES_MODEL_FILE_NAME_WITHOUT_EXTENSION = "builtInDataTypes";
    public static final String URI_REFERENCE_DELIMITER = "#";
    public static ObjectID BUILTIN_DATATYPES_MODEL_UUID = null;
    public static ObjectID XML_SCHEMA_UUID_1999 = null;
    public static ObjectID XML_MAGIC_SCHEMA_UUID_1999 = null;
    public static ObjectID XML_SCHEMA_INSTANCE_UUID_1999 = null;
    public static ObjectID XML_SCHEMA_UUID_2000_10 = null;
    public static ObjectID XML_MAGIC_SCHEMA_UUID_2000_10 = null;
    public static ObjectID XML_SCHEMA_INSTANCE_UUID_2000_10 = null;
    public static ObjectID XML_SCHEMA_UUID_2001 = null;
    public static ObjectID XML_MAGIC_SCHEMA_UUID_2001 = null;
    public static ObjectID XML_SCHEMA_INSTANCE_UUID_2001 = null;
    private static final Map RUNTIME_TO_BUILTIN_MAP = new HashMap();
    private static final List RUNTIME_TYPE_NAMES = new ArrayList();
    private static final List BUILTIN_TYPE_NAMES = new ArrayList();
    private static final List METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES = new ArrayList();
    private static final List PRIMITIVE_BUILTIN_TYPE_NAMES = new ArrayList();

    public static String getDatatypeNamefromRuntimeType(String runtimeTypeName) {
        return (String)RUNTIME_TO_BUILTIN_MAP.get(runtimeTypeName);
    }

    public static Collection getRuntimeTypeNames() {
        return Collections.unmodifiableCollection(RUNTIME_TYPE_NAMES);
    }

    public static Collection getBuiltInTypeNames() {
        return Collections.unmodifiableCollection(BUILTIN_TYPE_NAMES);
    }

    public static Collection getPrimitivedBuiltInTypeNames() {
        return Collections.unmodifiableCollection(PRIMITIVE_BUILTIN_TYPE_NAMES);
    }

    public static Collection getMetaMatrixExtendedBuiltInTypeNames() {
        return Collections.unmodifiableCollection(METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES);
    }

    private static void loadRuntimeTypeToBuildInConversionMap() {
        RUNTIME_TO_BUILTIN_MAP.put("string", "string");
        RUNTIME_TO_BUILTIN_MAP.put("boolean", "boolean");
        RUNTIME_TO_BUILTIN_MAP.put("byte", "byte");
        RUNTIME_TO_BUILTIN_MAP.put("short", "short");
        RUNTIME_TO_BUILTIN_MAP.put("char", "char");
        RUNTIME_TO_BUILTIN_MAP.put("integer", "int");
        RUNTIME_TO_BUILTIN_MAP.put("long", "long");
        RUNTIME_TO_BUILTIN_MAP.put("biginteger", "biginteger");
        RUNTIME_TO_BUILTIN_MAP.put("float", "float");
        RUNTIME_TO_BUILTIN_MAP.put("double", "double");
        RUNTIME_TO_BUILTIN_MAP.put("bigdecimal", "bigdecimal");
        RUNTIME_TO_BUILTIN_MAP.put("date", "date");
        RUNTIME_TO_BUILTIN_MAP.put("time", "time");
        RUNTIME_TO_BUILTIN_MAP.put("timestamp", "timestamp");
        RUNTIME_TO_BUILTIN_MAP.put("object", "object");
        RUNTIME_TO_BUILTIN_MAP.put("blob", "blob");
        RUNTIME_TO_BUILTIN_MAP.put("clob", "clob");
        RUNTIME_TO_BUILTIN_MAP.put("xml", "XMLLiteral");
    }

    private static void loadRuntimeTypeNames() {
        RUNTIME_TYPE_NAMES.add("string");
        RUNTIME_TYPE_NAMES.add("boolean");
        RUNTIME_TYPE_NAMES.add("byte");
        RUNTIME_TYPE_NAMES.add("short");
        RUNTIME_TYPE_NAMES.add("char");
        RUNTIME_TYPE_NAMES.add("integer");
        RUNTIME_TYPE_NAMES.add("long");
        RUNTIME_TYPE_NAMES.add("biginteger");
        RUNTIME_TYPE_NAMES.add("float");
        RUNTIME_TYPE_NAMES.add("double");
        RUNTIME_TYPE_NAMES.add("bigdecimal");
        RUNTIME_TYPE_NAMES.add("date");
        RUNTIME_TYPE_NAMES.add("time");
        RUNTIME_TYPE_NAMES.add("timestamp");
        RUNTIME_TYPE_NAMES.add("object");
        RUNTIME_TYPE_NAMES.add("blob");
        RUNTIME_TYPE_NAMES.add("clob");
        RUNTIME_TYPE_NAMES.add("xml");
    }

    private static void loadMetaMatrixExtentedBuiltInTypeNames() {
        METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES.add("char");
        METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES.add("biginteger");
        METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES.add("bigdecimal");
        METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES.add("timestamp");
        METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES.add("object");
        METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES.add("null");
        METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES.add("blob");
        METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES.add("clob");
        METAMATRIX_EXTENDED_BUILTIN_TYPE_NAMES.add("XMLLiteral");
    }

    private static void loadPrimitiveBuiltInTypeNames() {
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("string");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("boolean");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("float");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("double");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("date");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("time");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("NOTATION");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("QName");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("anyURI");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("base64Binary");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("dateTime");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("decimal");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("duration");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("gDay");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("gMonthDay");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("gMonth");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("gYearMonth");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("gYear");
        PRIMITIVE_BUILTIN_TYPE_NAMES.add("hexBinary");
    }

    private static void loadBuiltInTypeNames() {
        BUILTIN_TYPE_NAMES.add("string");
        BUILTIN_TYPE_NAMES.add("boolean");
        BUILTIN_TYPE_NAMES.add("byte");
        BUILTIN_TYPE_NAMES.add("short");
        BUILTIN_TYPE_NAMES.add("char");
        BUILTIN_TYPE_NAMES.add("int");
        BUILTIN_TYPE_NAMES.add("long");
        BUILTIN_TYPE_NAMES.add("biginteger");
        BUILTIN_TYPE_NAMES.add("float");
        BUILTIN_TYPE_NAMES.add("double");
        BUILTIN_TYPE_NAMES.add("bigdecimal");
        BUILTIN_TYPE_NAMES.add("date");
        BUILTIN_TYPE_NAMES.add("time");
        BUILTIN_TYPE_NAMES.add("timestamp");
        BUILTIN_TYPE_NAMES.add("object");
        BUILTIN_TYPE_NAMES.add("integer");
        BUILTIN_TYPE_NAMES.add("null");
        BUILTIN_TYPE_NAMES.add("blob");
        BUILTIN_TYPE_NAMES.add("clob");
        BUILTIN_TYPE_NAMES.add("ENTITIES");
        BUILTIN_TYPE_NAMES.add("ENTITY");
        BUILTIN_TYPE_NAMES.add("IDREFS");
        BUILTIN_TYPE_NAMES.add("IDREF");
        BUILTIN_TYPE_NAMES.add("ID");
        BUILTIN_TYPE_NAMES.add("NCName");
        BUILTIN_TYPE_NAMES.add("NMTOKENS");
        BUILTIN_TYPE_NAMES.add("NMTOKEN");
        BUILTIN_TYPE_NAMES.add("NOTATION");
        BUILTIN_TYPE_NAMES.add("Name");
        BUILTIN_TYPE_NAMES.add("QName");
        BUILTIN_TYPE_NAMES.add("anyType");
        BUILTIN_TYPE_NAMES.add("anySimpleType");
        BUILTIN_TYPE_NAMES.add("anyURI");
        BUILTIN_TYPE_NAMES.add("base64Binary");
        BUILTIN_TYPE_NAMES.add("dateTime");
        BUILTIN_TYPE_NAMES.add("decimal");
        BUILTIN_TYPE_NAMES.add("duration");
        BUILTIN_TYPE_NAMES.add("gDay");
        BUILTIN_TYPE_NAMES.add("gMonthDay");
        BUILTIN_TYPE_NAMES.add("gMonth");
        BUILTIN_TYPE_NAMES.add("gYearMonth");
        BUILTIN_TYPE_NAMES.add("gYear");
        BUILTIN_TYPE_NAMES.add("hexBinary");
        BUILTIN_TYPE_NAMES.add("language");
        BUILTIN_TYPE_NAMES.add("negativeInteger");
        BUILTIN_TYPE_NAMES.add("nonNegativeInteger");
        BUILTIN_TYPE_NAMES.add("nonPositiveInteger");
        BUILTIN_TYPE_NAMES.add("normalizedString");
        BUILTIN_TYPE_NAMES.add("positiveInteger");
        BUILTIN_TYPE_NAMES.add("token");
        BUILTIN_TYPE_NAMES.add("unsignedByte");
        BUILTIN_TYPE_NAMES.add("unsignedInt");
        BUILTIN_TYPE_NAMES.add("unsignedLong");
        BUILTIN_TYPE_NAMES.add("unsignedShort");
        BUILTIN_TYPE_NAMES.add("XMLLiteral");
    }

    public static boolean isSchemaEnterpriseDatatypeNamespace(String namespace) {
        return SCHEMA_FOR_ENTERPRISE_DATATYPES_URI_2005.equals(namespace);
    }

    public static boolean isSchemaEnterpriseDatatypeNamespacePrefix(String prefix) {
        return PREFIX_FOR_ENTERPRISE_DATATYPES_URI_2005.equals(prefix);
    }

    static {
        DatatypeConstants.loadRuntimeTypeToBuildInConversionMap();
        DatatypeConstants.loadRuntimeTypeNames();
        DatatypeConstants.loadBuiltInTypeNames();
        DatatypeConstants.loadMetaMatrixExtentedBuiltInTypeNames();
        DatatypeConstants.loadPrimitiveBuiltInTypeNames();
        Collections.sort(RUNTIME_TYPE_NAMES, String.CASE_INSENSITIVE_ORDER);
        try {
            BUILTIN_DATATYPES_MODEL_UUID = UUID.stringToObject((String)"6b862080-3019-1e20-921b-eeee28353879");
        }
        catch (InvalidIDException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        try {
            XML_SCHEMA_UUID_1999 = UUID.stringToObject((String)"1da96d2e-fc8c-1f0b-aa25-a4ec5e156765");
            XML_MAGIC_SCHEMA_UUID_1999 = UUID.stringToObject((String)"2343c130-fc8c-1f0b-aa25-a4ec5e156765");
            XML_SCHEMA_INSTANCE_UUID_1999 = UUID.stringToObject((String)"26f5d0c4-fc8c-1f0b-aa25-a4ec5e156765");
            XML_SCHEMA_UUID_2000_10 = UUID.stringToObject((String)"60624ce0-fc7a-1f0b-a813-96dd78086d7a");
            XML_MAGIC_SCHEMA_UUID_2000_10 = UUID.stringToObject((String)"624a93b9-fc7a-1f0b-a813-96dd78086d7a");
            XML_SCHEMA_INSTANCE_UUID_2000_10 = UUID.stringToObject((String)"632f7658-fc7a-1f0b-a813-96dd78086d7a");
            XML_SCHEMA_UUID_2001 = UUID.stringToObject((String)"b017498c-fc82-1f0b-9301-8cc12cf53072");
            XML_MAGIC_SCHEMA_UUID_2001 = UUID.stringToObject((String)"a8a3ee88-fc82-1f0b-9301-8cc12cf53072");
            XML_SCHEMA_INSTANCE_UUID_2001 = UUID.stringToObject((String)"ac653e49-fc82-1f0b-9301-8cc12cf53072");
        }
        catch (InvalidIDException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    public static final class RuntimeTypeNames {
        public static final String STRING = "string";
        public static final String BOOLEAN = "boolean";
        public static final String BYTE = "byte";
        public static final String SHORT = "short";
        public static final String CHAR = "char";
        public static final String INTEGER = "integer";
        public static final String LONG = "long";
        public static final String BIG_INTEGER = "biginteger";
        public static final String FLOAT = "float";
        public static final String DOUBLE = "double";
        public static final String BIG_DECIMAL = "bigdecimal";
        public static final String DATE = "date";
        public static final String TIME = "time";
        public static final String TIMESTAMP = "timestamp";
        public static final String OBJECT = "object";
        public static final String NULL = "null";
        public static final String BLOB = "blob";
        public static final String CLOB = "clob";
        public static final String XML = "xml";
    }

    public static final class BuiltInNames {
        public static final String STRING = "string";
        public static final String BOOLEAN = "boolean";
        public static final String BYTE = "byte";
        public static final String SHORT = "short";
        public static final String INTEGER = "integer";
        public static final String LONG = "long";
        public static final String FLOAT = "float";
        public static final String DOUBLE = "double";
        public static final String DATE = "date";
        public static final String TIME = "time";
        public static final String ENTITIES = "ENTITIES";
        public static final String ENTITY = "ENTITY";
        public static final String IDREFS = "IDREFS";
        public static final String IDREF = "IDREF";
        public static final String ID = "ID";
        public static final String NCNAME = "NCName";
        public static final String NMTOKENS = "NMTOKENS";
        public static final String NMTOKEN = "NMTOKEN";
        public static final String NOTATION = "NOTATION";
        public static final String NAME = "Name";
        public static final String QNAME = "QName";
        public static final String ANY_TYPE = "anyType";
        public static final String ANY_SIMPLE_TYPE = "anySimpleType";
        public static final String ANY_URI = "anyURI";
        public static final String BASE64_BINARY = "base64Binary";
        public static final String DATE_TIME = "dateTime";
        public static final String DECIMAL = "decimal";
        public static final String DURATION = "duration";
        public static final String GDAY = "gDay";
        public static final String GMONTH_DAY = "gMonthDay";
        public static final String GMONTH = "gMonth";
        public static final String GYEAR_MONTH = "gYearMonth";
        public static final String GYEAR = "gYear";
        public static final String HEX_BINARY = "hexBinary";
        public static final String INT = "int";
        public static final String LANGUAGE = "language";
        public static final String NEGATIVE_INTEGER = "negativeInteger";
        public static final String NON_NEGATIVE_INTEGER = "nonNegativeInteger";
        public static final String NON_POSITIVE_INTEGER = "nonPositiveInteger";
        public static final String NORMALIZED_STRING = "normalizedString";
        public static final String POSITIVE_INTEGER = "positiveInteger";
        public static final String TOKEN = "token";
        public static final String UNSIGNED_BYTE = "unsignedByte";
        public static final String UNSIGNED_INT = "unsignedInt";
        public static final String UNSIGNED_LONG = "unsignedLong";
        public static final String UNSIGNED_SHORT = "unsignedShort";
        public static final String CHAR = "char";
        public static final String BIG_INTEGER = "biginteger";
        public static final String BIG_DECIMAL = "bigdecimal";
        public static final String TIMESTAMP = "timestamp";
        public static final String OBJECT = "object";
        public static final String NULL = "null";
        public static final String BLOB = "blob";
        public static final String CLOB = "clob";
        public static final String XML_LITERAL = "XMLLiteral";
    }

    public static final class PrimitiveBuiltInNames {
        public static final String STRING = "string";
        public static final String BOOLEAN = "boolean";
        public static final String FLOAT = "float";
        public static final String DOUBLE = "double";
        public static final String DATE = "date";
        public static final String TIME = "time";
        public static final String NOTATION = "NOTATION";
        public static final String QNAME = "QName";
        public static final String ANY_URI = "anyURI";
        public static final String BASE64_BINARY = "base64Binary";
        public static final String DATE_TIME = "dateTime";
        public static final String DECIMAL = "decimal";
        public static final String DURATION = "duration";
        public static final String GDAY = "gDay";
        public static final String GMONTH_DAY = "gMonthDay";
        public static final String GMONTH = "gMonth";
        public static final String GYEAR_MONTH = "gYearMonth";
        public static final String GYEAR = "gYear";
        public static final String HEX_BINARY = "hexBinary";
    }

    public static final class MetaMatrixExtendedBuiltInNames {
        public static final String CHAR = "char";
        public static final String BIG_INTEGER = "biginteger";
        public static final String BIG_DECIMAL = "bigdecimal";
        public static final String TIMESTAMP = "timestamp";
        public static final String OBJECT = "object";
        public static final String NULL = "null";
        public static final String BLOB = "blob";
        public static final String CLOB = "clob";
        public static final String XML_LITERAL = "XMLLiteral";
    }
}

