/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.CharOperation;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.index.BlocksIndexInput;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.metadata.runtime.impl.RecordFactory;
import com.metamatrix.modeler.core.index.IndexConstants;
import com.metamatrix.modeler.core.index.IndexSelector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SimpleIndexUtil {
    public static final boolean CASE_SENSITIVE_INDEX_FILE_NAMES = false;

    public static String getIndexFilePath(String indexDirectoryPath, String indexFileName) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(indexDirectoryPath);
        if (!indexDirectoryPath.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(indexFileName);
        return sb.toString();
    }

    public static IEntryResult[] queryIndex(Index[] indexes, char[] pattern, char fieldDelimiter) throws MetaMatrixCoreException {
        int i;
        boolean isCaseSensitive = false;
        ArrayList<IEntryResult> queryResult = new ArrayList<IEntryResult>();
        try {
            for (i = 0; i < indexes.length; ++i) {
                IEntryResult[] partialResults = indexes[i].queryEntriesMatching(pattern, false);
                if (partialResults != null) {
                    partialResults = SimpleIndexUtil.addContinuationRecords(indexes[i], partialResults);
                }
                if (partialResults == null) continue;
                queryResult.addAll(Arrays.asList(partialResults));
            }
        }
        catch (IOException e) {
            throw new MetaMatrixCoreException((Throwable)e);
        }
        int n = queryResult.size();
        for (i = 0; i < n; ++i) {
            IEntryResult record = (IEntryResult)queryResult.get(i);
            if (record != null && SimpleIndexUtil.entryMatches(record.getWord(), pattern, fieldDelimiter)) continue;
            queryResult.remove(record);
        }
        return queryResult.toArray(new IEntryResult[queryResult.size()]);
    }

    private static boolean entryMatches(char[] record, char[] pattern, char fieldDelimiter) {
        boolean isCaseSensitive = false;
        if (record == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        String delimiter = String.valueOf(fieldDelimiter);
        List recordTokens = StringUtil.split((String)new String(record), (String)delimiter);
        List patternTokens = StringUtil.split((String)new String(pattern), (String)delimiter);
        if (patternTokens.size() > recordTokens.size()) {
            return false;
        }
        int n = patternTokens.size();
        for (int i = 0; i < n; ++i) {
            char[] recordToken;
            char[] patternToken = ((String)patternTokens.get(i)).toCharArray();
            if (CharOperation.match(patternToken, recordToken = ((String)recordTokens.get(i)).toCharArray(), false)) continue;
            return false;
        }
        return true;
    }

    public static IEntryResult[] queryIndex(Index[] indexes, char[] pattern, boolean isPrefix, boolean returnFirstMatch) throws MetaMatrixCoreException {
        return SimpleIndexUtil.queryIndex(null, indexes, pattern, isPrefix, true, returnFirstMatch);
    }

    public static IEntryResult[] queryIndex(ProgressMonitor monitor, Index[] indexes, char[] pattern, boolean isPrefix, boolean returnFirstMatch) throws MetaMatrixCoreException {
        return SimpleIndexUtil.queryIndex(monitor, indexes, pattern, isPrefix, true, returnFirstMatch);
    }

    public static IEntryResult[] queryIndex(ProgressMonitor monitor, Index[] indexes, char[] pattern, boolean isPrefix, boolean isCaseSensitive, boolean returnFirstMatch) throws MetaMatrixCoreException {
        ArrayList<IEntryResult> queryResult = new ArrayList<IEntryResult>();
        if (monitor != null) {
            monitor.beginTask(null, indexes.length);
        }
        try {
            for (int i = 0; i < indexes.length; ++i) {
                if (monitor != null) {
                    monitor.worked(1);
                }
                IEntryResult[] partialResults = null;
                partialResults = isPrefix ? indexes[i].queryEntries(pattern, isCaseSensitive) : indexes[i].queryEntriesMatching(pattern, isCaseSensitive);
                if (partialResults != null) {
                    partialResults = SimpleIndexUtil.addContinuationRecords(indexes[i], partialResults);
                }
                if (partialResults != null) {
                    for (int j = 0; j < partialResults.length; ++j) {
                        IEntryResult result = partialResults[j];
                        if (result == null || result.getWord()[0] == '&') continue;
                        queryResult.add(partialResults[j]);
                    }
                }
                if (!returnFirstMatch || queryResult.size() <= 0) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new MetaMatrixCoreException((Throwable)e);
        }
        return queryResult.toArray(new IEntryResult[queryResult.size()]);
    }

    public static IEntryResult[] queryIndex(ProgressMonitor monitor, Index[] indexes, Collection patterns, boolean isPrefix, boolean isCaseSensitive, boolean returnFirstMatch) throws MetaMatrixCoreException {
        ArrayList<IEntryResult> queryResult = new ArrayList<IEntryResult>();
        if (monitor != null) {
            monitor.beginTask(null, indexes.length);
        }
        BlocksIndexInput input = null;
        try {
            block9: for (int i = 0; i < indexes.length; ++i) {
                if (monitor != null) {
                    monitor.worked(1);
                }
                input = new BlocksIndexInput(indexes[i].getIndexFile());
                IEntryResult[] partialResults = null;
                Iterator patternIter = patterns.iterator();
                while (patternIter.hasNext()) {
                    char[] pattern = ((String)patternIter.next()).toCharArray();
                    partialResults = isPrefix ? input.queryEntriesPrefixedBy(pattern, isCaseSensitive) : input.queryEntriesMatching(pattern, isCaseSensitive);
                    if (partialResults != null) {
                        partialResults = SimpleIndexUtil.addContinuationRecords(indexes[i], partialResults);
                    }
                    if (partialResults != null) {
                        for (int j = 0; j < partialResults.length; ++j) {
                            char[] recordWord;
                            IEntryResult record = partialResults[j];
                            if (record == null || (recordWord = partialResults[j].getWord())[0] == '&') continue;
                            if (!isPrefix) {
                                if (!SimpleIndexUtil.entryMatches(recordWord, pattern, '\u00a0')) continue;
                                queryResult.add(partialResults[j]);
                                continue;
                            }
                            queryResult.add(partialResults[j]);
                        }
                    }
                    if (returnFirstMatch && queryResult.size() > 0) continue block9;
                    input.close();
                }
            }
        }
        catch (IOException e) {
            throw new MetaMatrixCoreException((Throwable)e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException io) {}
        }
        return queryResult.toArray(new IEntryResult[queryResult.size()]);
    }

    private static IEntryResult[] addContinuationRecords(Index index, IEntryResult[] partialResults) throws IOException {
        int blockSize = 8160;
        IEntryResult[] results = partialResults;
        for (int i = 0; i < results.length; ++i) {
            IEntryResult partialResult = results[i];
            char[] word = partialResult.getWord();
            if (word.length < 8160 || word[8159] != '&') continue;
            String objectID = RecordFactory.extractUUIDString(partialResult);
            String patternStr = "&" + word[0] + '\u00a0' + objectID + '\u00a0';
            IEntryResult[] continuationResults = index.queryEntries(patternStr.toCharArray(), true);
            if (continuationResults == null || continuationResults.length <= 0) continue;
            results[i] = RecordFactory.joinEntryResults(partialResult, continuationResults, 8160);
        }
        return results;
    }

    public static boolean indexFileExists(String indexFilePath) {
        if (indexFilePath == null) {
            return false;
        }
        String filePath = indexFilePath.replace('/', File.separatorChar);
        File indexFile = new File(filePath);
        return SimpleIndexUtil.indexFileExists(indexFile);
    }

    public static boolean indexFileExists(File indexFile) {
        if (!indexFile.isDirectory() && indexFile.exists()) {
            return SimpleIndexUtil.isIndexFile(indexFile.getName());
        }
        return false;
    }

    public static boolean isModelIndex(String indexFileName) {
        if (!SimpleIndexUtil.isIndexFile(indexFileName)) {
            return false;
        }
        return !IndexConstants.INDEX_NAME.isKnownIndex(indexFileName);
    }

    public static boolean isIndexFile(String indexFileName) {
        String extension;
        return !StringUtil.isEmpty((String)indexFileName) && (extension = FileUtils.getExtension((String)indexFileName)) != null && (extension.equals("INDEX") || extension.equals("SEARCH_INDEX"));
    }

    public static boolean isIndexFile(File indexFile) {
        if (indexFile != null && indexFile.isFile()) {
            return SimpleIndexUtil.isIndexFile(indexFile.getName());
        }
        return false;
    }

    public static Index[] getIndexes(String indexName, IndexSelector selector) throws MetaMatrixCoreException {
        ArgCheck.isNotEmpty((String)indexName);
        try {
            Index[] indexes = selector.getIndexes();
            ArrayList<Index> tmp = new ArrayList<Index>(indexes.length);
            for (int i = 0; i < indexes.length; ++i) {
                String indexFileName;
                Index coreIndex = indexes[i];
                if (coreIndex == null || !indexName.equals(indexFileName = indexes[i].getIndexFile().getName())) continue;
                tmp.add(coreIndex);
            }
            return tmp.toArray(new Index[tmp.size()]);
        }
        catch (IOException e) {
            throw new MetaMatrixCoreException((Throwable)e);
        }
    }

    public static String getIndexFileNameForRecordType(char recordType) {
        switch (recordType) {
            case 'G': {
                return "COLUMNS.INDEX";
            }
            case 'B': {
                return "TABLES.INDEX";
            }
            case 'A': {
                return "MODELS.INDEX";
            }
            case 'C': 
            case 'E': 
            case 'F': {
                return "PROCEDURES.INDEX";
            }
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': {
                return "KEYS.INDEX";
            }
            case 'P': {
                return "SELECT_TRANSFORM.INDEX";
            }
            case 'Q': {
                return "INSERT_TRANSFORM.INDEX";
            }
            case 'R': {
                return "UPDATE_TRANSFORM.INDEX";
            }
            case 'S': {
                return "DELETE_TRANSFORM.INDEX";
            }
            case 'T': {
                return "PROC_TRANSFORM.INDEX";
            }
            case 'U': {
                return "MAPPING_TRANSFORM.INDEX";
            }
            case 'M': {
                return "DATATYPES.INDEX";
            }
            case 'V': {
                return "VDBS.INDEX";
            }
            case 'W': {
                return "ANNOTATION.INDEX";
            }
            case 'X': {
                return "PROPERTIES.INDEX";
            }
            case 'Z': {
                return "FILES.INDEX";
            }
        }
        throw new IllegalArgumentException("Unkown record type " + recordType);
    }

    public static String getRecordTypeForIndexFileName(String indexName) {
        int recordType;
        if (indexName.equalsIgnoreCase("COLUMNS.INDEX")) {
            recordType = 71;
        } else if (indexName.equalsIgnoreCase("TABLES.INDEX")) {
            recordType = 66;
        } else if (indexName.equalsIgnoreCase("MODELS.INDEX")) {
            recordType = 65;
        } else if (indexName.equalsIgnoreCase("DATATYPES.INDEX")) {
            recordType = 77;
        } else if (indexName.equalsIgnoreCase("VDBS.INDEX")) {
            recordType = 86;
        } else if (indexName.equalsIgnoreCase("ANNOTATION.INDEX")) {
            recordType = 87;
        } else if (indexName.equalsIgnoreCase("PROPERTIES.INDEX")) {
            recordType = 88;
        } else if (indexName.equalsIgnoreCase("SELECT_TRANSFORM.INDEX")) {
            recordType = 80;
        } else if (indexName.equalsIgnoreCase("INSERT_TRANSFORM.INDEX")) {
            recordType = 81;
        } else if (indexName.equalsIgnoreCase("UPDATE_TRANSFORM.INDEX")) {
            recordType = 82;
        } else if (indexName.equalsIgnoreCase("DELETE_TRANSFORM.INDEX")) {
            recordType = 83;
        } else if (indexName.equalsIgnoreCase("PROC_TRANSFORM.INDEX")) {
            recordType = 84;
        } else if (indexName.equalsIgnoreCase("MAPPING_TRANSFORM.INDEX")) {
            recordType = 85;
        } else if (indexName.equalsIgnoreCase("FILES.INDEX")) {
            recordType = 90;
        } else {
            return null;
        }
        return "" + (char)recordType;
    }

    public static String getPrefixPattern(char recordType, String uuid) {
        String patternStr = "" + recordType + '\u00a0';
        if (uuid != null && !uuid.equals("")) {
            patternStr = patternStr + uuid.trim() + '\u00a0';
        }
        return patternStr;
    }

    public static interface ProgressMonitor {
        public void beginTask(String var1, int var2);

        public void worked(int var1);
    }
}

