/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cdk.api;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.teiid.cdk.CommandBuilder;
import org.teiid.dqp.internal.datamgr.metadata.RuntimeMetadataImpl;
import org.teiid.language.Command;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.function.UDFSource;
import org.teiid.query.function.metadata.FunctionMethod;
import org.teiid.query.metadata.BasicQueryMetadataWrapper;
import org.teiid.query.metadata.QueryMetadataInterface;

public class TranslationUtility {
    private QueryMetadataInterface metadata;

    public TranslationUtility(String vdbFile) {
        this.metadata = VDBMetadataFactory.getVDBMetadata(vdbFile);
    }

    public TranslationUtility(URL url) {
        try {
            this.metadata = VDBMetadataFactory.getVDBMetadata(url, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TranslationUtility(QueryMetadataInterface metadata) {
        this.metadata = metadata;
    }

    public Command parseCommand(String sql, boolean generateAliases, boolean supportsGroupAliases) {
        CommandBuilder commandBuilder = new CommandBuilder(this.metadata);
        return commandBuilder.getCommand(sql, generateAliases, supportsGroupAliases);
    }

    public Command parseCommand(String sql) {
        CommandBuilder commandBuilder = new CommandBuilder(this.metadata);
        return commandBuilder.getCommand(sql);
    }

    public RuntimeMetadata createRuntimeMetadata() {
        return new RuntimeMetadataImpl(this.metadata);
    }

    public void setUDF(final Collection<FunctionMethod> methods) {
        this.metadata = new BasicQueryMetadataWrapper(this.metadata){

            public FunctionLibrary getFunctionLibrary() {
                return new FunctionLibrary(SystemFunctionManager.getSystemFunctions(), new FunctionTree((FunctionMetadataSource)new UDFSource(methods)));
            }
        };
    }
}

