/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.LRUCache;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.CompositeMetadataStore;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.TransformationMetadata;
import org.teiid.metadata.index.IndexMetadataFactory;
import org.teiid.query.function.metadata.FunctionMetadataReader;

public class VDBMetadataFactory {
    public static LRUCache<URL, TransformationMetadata> VDB_CACHE = new LRUCache(10);

    public static TransformationMetadata getVDBMetadata(String vdbFile) {
        try {
            return VDBMetadataFactory.getVDBMetadata(new File(vdbFile).toURI().toURL(), null);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public static MetadataStore getSystemVDBMetadataStore() {
        try {
            IndexMetadataFactory imf = VDBMetadataFactory.loadMetadata(Thread.currentThread().getContextClassLoader().getResource("System.vdb"));
            return imf.getMetadataStore();
        }
        catch (Exception e) {
            throw new TeiidRuntimeException("System VDB not found");
        }
    }

    public static TransformationMetadata getVDBMetadata(URL vdbURL, URL udfFile) throws IOException {
        TransformationMetadata vdbmetadata = (TransformationMetadata)VDB_CACHE.get((Object)vdbURL);
        if (vdbmetadata != null) {
            return vdbmetadata;
        }
        try {
            IndexMetadataFactory imf = VDBMetadataFactory.loadMetadata(vdbURL);
            List methods = null;
            if (udfFile != null) {
                methods = FunctionMetadataReader.loadFunctionMethods((InputStream)udfFile.openStream());
            }
            MetadataStore system = VDBMetadataFactory.loadMetadata(Thread.currentThread().getContextClassLoader().getResource("System.vdb")).getMetadataStore();
            vdbmetadata = new TransformationMetadata(null, new CompositeMetadataStore(Arrays.asList(system, imf.getMetadataStore())), (Map)imf.getEntriesPlusVisibilities(), (Collection)methods);
            VDB_CACHE.put((Object)vdbURL, (Object)vdbmetadata);
            return vdbmetadata;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static IndexMetadataFactory loadMetadata(URL vdbURL) throws IOException, MalformedURLException, URISyntaxException {
        if (vdbURL.getProtocol().equals("jar")) {
            InputStream is = vdbURL.openStream();
            File temp = File.createTempFile("temp", ".vdb", new File(UnitTestUtil.getTestScratchPath()));
            temp.deleteOnExit();
            FileUtils.write((InputStream)is, (File)temp);
            vdbURL = temp.toURI().toURL();
        }
        return new IndexMetadataFactory(vdbURL);
    }
}

