/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.index;

import java.util.ArrayList;
import org.teiid.core.index.IDocument;
import org.teiid.internal.core.index.IndexedFile;

public final class IndexedFileHashedArray {
    private IndexedFile[] elements;
    private int elementSize;
    private int threshold;
    private int lastId;
    private ArrayList replacedElements;

    public IndexedFileHashedArray(int size) {
        if (size < 7) {
            size = 7;
        }
        this.elements = new IndexedFile[2 * size + 1];
        this.elementSize = 0;
        this.threshold = size + 1;
        this.lastId = 0;
        this.replacedElements = null;
    }

    public IndexedFile add(IDocument document) {
        return this.add(new IndexedFile(document, ++this.lastId));
    }

    private IndexedFile add(IndexedFile file) {
        IndexedFile current;
        int length = this.elements.length;
        String path = file.getPath();
        int index = (path.hashCode() & Integer.MAX_VALUE) % length;
        while ((current = this.elements[index]) != null) {
            if (current.getPath().equals(path)) {
                if (this.replacedElements == null) {
                    this.replacedElements = new ArrayList(5);
                }
                this.replacedElements.add(current);
                this.elements[index] = file;
                return this.elements[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.elements[index] = file;
        if (++this.elementSize > this.threshold) {
            this.grow();
        }
        return file;
    }

    public IndexedFile[] asArray() {
        IndexedFile[] array = new IndexedFile[this.lastId];
        for (IndexedFile current : this.elements) {
            if (current == null) continue;
            array[current.fileNumber - 1] = current;
        }
        if (this.replacedElements != null) {
            int length = this.replacedElements.size();
            for (int i = 0; i < length; ++i) {
                IndexedFile current;
                array[current.fileNumber - 1] = current = (IndexedFile)this.replacedElements.get(i);
            }
        }
        return array;
    }

    public IndexedFile get(String path) {
        IndexedFile current;
        int length = this.elements.length;
        int index = (path.hashCode() & Integer.MAX_VALUE) % length;
        while ((current = this.elements[index]) != null) {
            if (current.getPath().equals(path)) {
                return current;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    private void grow() {
        IndexedFileHashedArray newArray = new IndexedFileHashedArray(this.elementSize * 2);
        int length = this.elements.length;
        for (int i = 0; i < length; ++i) {
            if (this.elements[i] == null) continue;
            newArray.add(this.elements[i]);
        }
        this.elements = newArray.elements;
        this.elementSize = newArray.elementSize;
        this.threshold = newArray.threshold;
    }

    public int size() {
        return this.elementSize + (this.replacedElements == null ? 0 : this.replacedElements.size());
    }

    public String toString() {
        String s = "";
        IndexedFile[] files = this.asArray();
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            s = s + files[i].toString() + "\n";
        }
        return s;
    }
}

