/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.index;

import java.io.UTFDataFormatException;
import java.util.Arrays;
import org.teiid.internal.core.index.IndexBlock;
import org.teiid.internal.core.index.WordEntry;

public class SimpleIndexBlock
extends IndexBlock {
    protected int offset = 0;

    public SimpleIndexBlock(int blockSize) {
        super(blockSize);
    }

    @Override
    public boolean addEntry(WordEntry entry) {
        int n;
        int offset = this.offset;
        char[] word = entry.getWord();
        int sizeEstimate = 2 + word.length * 3 + 4 + (n = entry.getNumRefs()) * 4;
        if (offset + sizeEstimate > this.blockSize - 2) {
            return false;
        }
        offset += this.field.putUTF(offset, word);
        this.field.putInt4(offset, n);
        offset += 4;
        for (int i = 0; i < n; ++i) {
            this.field.putInt4(offset, entry.getRef(i));
            offset += 4;
        }
        this.offset = offset;
        return true;
    }

    public WordEntry findEntry(char[] word) {
        try {
            int byteLen;
            int offset = 0;
            while ((byteLen = this.field.getUInt2(offset)) != 0) {
                char[] tempWord = this.field.getUTF(offset);
                offset += byteLen + 2;
                if (Arrays.equals(tempWord, word)) {
                    WordEntry entry = new WordEntry(word);
                    int n = this.field.getInt4(offset);
                    offset += 4;
                    for (int i = 0; i < n; ++i) {
                        int ref = this.field.getInt4(offset);
                        offset += 4;
                        entry.addRef(ref);
                    }
                    return entry;
                }
                int n = this.field.getInt4(offset);
                offset += 4 + 4 * n;
            }
            return null;
        }
        catch (UTFDataFormatException e) {
            return null;
        }
    }

    @Override
    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.offset = 0;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.offset == 0;
    }

    @Override
    public boolean nextEntry(WordEntry entry) {
        try {
            int offset = this.offset;
            int byteLen = this.field.getUInt2(offset);
            if (byteLen == 0) {
                return false;
            }
            char[] word = this.field.getUTF(offset);
            entry.reset(word);
            int n = this.field.getInt4(offset += byteLen + 2);
            offset += 4;
            for (int i = 0; i < n; ++i) {
                int ref = this.field.getInt4(offset);
                offset += 4;
                entry.addRef(ref);
            }
            this.offset = offset;
            return true;
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.offset = 0;
    }
}

