/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.index.IEntryResult;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.StringUtil;
import org.teiid.internal.core.index.EntryResult;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.index.TransformationRecordImpl;

public class RecordFactory {
    public static final int INDEX_RECORD_BLOCK_SIZE = 8160;
    public static final int NONVERSIONED_RECORD_INDEX_VERSION = 0;
    public static final int DELIMITER_INDEX_VERSION = 1;
    public static final int TABLE_MATERIALIZATION_INDEX_VERSION = 2;
    public static final int COLUMN_NATIVE_TYPE_INDEX_VERSION = 3;
    public static final int COLUMN_INPUT_PARAMETER_FLAG_INDEX_VERSION = 4;
    public static final int ANNOTATION_TAGS_INDEX_VERSION = 5;
    public static final int TRANSFORMATION_UUID_INDEX_VERSION = 6;
    public static final int COLUMN_NULL_DISTINCT_INDEX_VERSION = 7;
    public static final int PRIMITIVE_TYPE_ID_INDEX_VERSION = 8;
    public static final int PROCEDURE_UPDATE_COUNT_VERSION = 9;
    public static final int CURRENT_INDEX_VERSION = 9;
    private int version = 0;

    public List<AbstractMetadataRecord> getMetadataRecord(IEntryResult[] queryResult) {
        ArrayList<AbstractMetadataRecord> records = new ArrayList<AbstractMetadataRecord>(queryResult.length);
        for (int i = 0; i < queryResult.length; ++i) {
            AbstractMetadataRecord record = this.getMetadataRecord(queryResult[i].getWord());
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    private AbstractMetadataRecord getMetadataRecord(char[] record) {
        if (record == null || record.length == 0) {
            return null;
        }
        switch (record[0]) {
            case 'A': {
                return this.createModelRecord(record);
            }
            case 'B': {
                return this.createTableRecord(record);
            }
            case 'D': {
                return null;
            }
            case 'E': {
                return this.createProcedureRecord(record);
            }
            case 'F': {
                return this.createProcedureParameterRecord(record);
            }
            case 'G': {
                return this.createColumnRecord(record);
            }
            case 'H': {
                return this.createColumnSetRecord(record, (ColumnSet)new KeyRecord(KeyRecord.Type.AccessPattern));
            }
            case 'L': {
                return this.createColumnSetRecord(record, (ColumnSet)new KeyRecord(KeyRecord.Type.Index));
            }
            case 'C': {
                return this.createColumnSetRecord(record, new ColumnSet());
            }
            case 'I': {
                return this.createColumnSetRecord(record, (ColumnSet)new KeyRecord(KeyRecord.Type.Unique));
            }
            case 'K': {
                return this.createColumnSetRecord(record, (ColumnSet)new KeyRecord(KeyRecord.Type.Primary));
            }
            case 'J': {
                return this.createForeignKeyRecord(record);
            }
            case 'M': {
                return this.createDatatypeRecord(record);
            }
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': {
                return this.createTransformationRecord(record);
            }
        }
        throw new IllegalArgumentException("Invalid record type for creating MetadataRecord " + record[0]);
    }

    public static IEntryResult joinEntryResults(IEntryResult result, IEntryResult[] continuationResults, int blockSize) {
        char[] baseResult = result.getWord();
        if (baseResult.length < blockSize || baseResult[blockSize - 1] != '&') {
            return result;
        }
        String baseStr = new String(baseResult);
        String objectID = RecordFactory.extractUUIDString(result);
        StringBuffer sb = new StringBuffer();
        sb.append(baseStr.substring(0, blockSize - 1));
        IEntryResult[] sortedResults = RecordFactory.sortContinuationResults(objectID, continuationResults);
        for (int i = 0; i < sortedResults.length; ++i) {
            int beginIndex;
            char[] continuation = sortedResults[i].getWord();
            int segNumber = RecordFactory.getContinuationSegmentNumber(objectID, sortedResults[i]);
            for (int j = beginIndex = objectID.length() + Integer.toString(segNumber).length() + 5; j < continuation.length; ++j) {
                if (j >= blockSize - 1) continue;
                sb.append(continuation[j]);
            }
        }
        return new EntryResult(sb.toString().toCharArray(), result.getFileReferences());
    }

    private static IEntryResult[] sortContinuationResults(String objectID, IEntryResult[] continuationResults) {
        if (continuationResults.length < 10) {
            return continuationResults;
        }
        IEntryResult[] sortedResults = new IEntryResult[continuationResults.length];
        for (int i = 0; i < continuationResults.length; ++i) {
            int segNumber = RecordFactory.getContinuationSegmentNumber(objectID, continuationResults[i]);
            sortedResults[segNumber - 1] = continuationResults[i];
        }
        return sortedResults;
    }

    public static int getContinuationSegmentNumber(String objectID, IEntryResult continuationResult) {
        char[] record = continuationResult.getWord();
        int segNumber = -1;
        int index = objectID.length() + 4;
        if (record[index + 1] == '\u00a0') {
            segNumber = Character.getNumericValue(record[index]);
        } else if (record[index + 2] == '\u00a0') {
            char[] temp = new char[]{record[index], record[index + 1]};
            String segCount = new String(temp);
            segNumber = Integer.parseInt(segCount);
        } else if (record[index + 3] == '\u00a0') {
            char[] temp = new char[]{record[index], record[index + 1], record[index + 2]};
            String segCount = new String(temp);
            segNumber = Integer.parseInt(segCount);
        }
        return segNumber;
    }

    public static String extractUUIDString(IEntryResult result) {
        char[] word = result.getWord();
        String baseStr = new String(word);
        int beginIndex = baseStr.indexOf("mmuuid");
        int endIndex = word.length;
        Assertion.assertTrue((beginIndex != -1 ? 1 : 0) != 0);
        for (int i = beginIndex; i < word.length; ++i) {
            if (word[i] != '\u00a0') continue;
            endIndex = i;
            break;
        }
        Assertion.assertTrue((beginIndex < endIndex ? 1 : 0) != 0);
        return baseStr.substring(beginIndex, endIndex);
    }

    public Schema createModelRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        Schema model = new Schema();
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)model, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        int n = ++tokenIndex;
        ++tokenIndex;
        model.setPhysical(Integer.parseInt((String)tokens.get(n)) == 0);
        model.setPrimaryMetamodelUri(this.getObjectValue((String)tokens.get(tokenIndex++)));
        char[] supportFlags = ((String)tokens.get(tokenIndex++)).toCharArray();
        model.setVisible(this.getBooleanValue(supportFlags[0]));
        this.setRecordFooterValues((AbstractMetadataRecord)model, tokens, tokenIndex);
        return model;
    }

    public TransformationRecordImpl createTransformationRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        TransformationRecordImpl transform = new TransformationRecordImpl();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 2;
        this.getObjectValue((String)tokens.get(tokenIndex++));
        if (this.includeTransformationUUID(indexVersion)) {
            transform.setUUID(this.getObjectValue((String)tokens.get(tokenIndex++)));
        }
        transform.setTransformation(this.getObjectValue((String)tokens.get(tokenIndex++)));
        List<String> bindings = this.getStrings((String)tokens.get(tokenIndex++), indexVersion);
        transform.setBindings(bindings);
        List<String> schemaPaths = this.getStrings((String)tokens.get(tokenIndex++), indexVersion);
        transform.setSchemaPaths(schemaPaths);
        this.setRecordFooterValues(transform, tokens, tokenIndex);
        return transform;
    }

    protected static short getKeyTypeForRecordType(char recordType) {
        switch (recordType) {
            case 'I': {
                return 2;
            }
            case 'L': {
                return 5;
            }
            case 'H': {
                return 4;
            }
            case 'K': {
                return 0;
            }
            case 'J': {
                return 1;
            }
            case 'C': {
                return -1;
            }
        }
        throw new IllegalArgumentException("Invalid record type, for key" + recordType);
    }

    public Table createTableRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        Table table = new Table();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)table, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        table.setCardinality(Integer.parseInt((String)tokens.get(tokenIndex++)));
        table.setTableType(Table.Type.values()[Integer.parseInt((String)tokens.get(tokenIndex++))]);
        char[] supportFlags = ((String)tokens.get(tokenIndex++)).toCharArray();
        table.setVirtual(this.getBooleanValue(supportFlags[0]));
        table.setSystem(this.getBooleanValue(supportFlags[1]));
        table.setSupportsUpdate(this.getBooleanValue(supportFlags[2]));
        if (this.includeMaterializationFlag(indexVersion)) {
            table.setMaterialized(this.getBooleanValue(supportFlags[3]));
        }
        int n = ++tokenIndex;
        ++tokenIndex;
        String id = this.getObjectValue((String)tokens.get(n));
        if (id != null) {
            KeyRecord pk = new KeyRecord(KeyRecord.Type.Primary);
            pk.setUUID(id);
            table.setPrimaryKey(pk);
        }
        tokenIndex += 4;
        if (this.includeMaterializationFlag(indexVersion)) {
            Table matTable = new Table();
            matTable.setUUID((String)tokens.get(tokenIndex++));
            table.setMaterializedTable(matTable);
            matTable = new Table();
            matTable.setUUID((String)tokens.get(tokenIndex++));
            table.setMaterializedStageTable(matTable);
        }
        this.setRecordFooterValues((AbstractMetadataRecord)table, tokens, tokenIndex);
        return table;
    }

    private static List<Column> createColumns(List<String> uuids) {
        ArrayList<Column> columns = new ArrayList<Column>(uuids.size());
        for (String uuid : uuids) {
            Column column = new Column();
            column.setUUID(uuid);
            columns.add(column);
        }
        return columns;
    }

    public Column createColumnRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        Column column = new Column();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)column, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        char[] supportFlags = ((String)tokens.get(tokenIndex++)).toCharArray();
        column.setSelectable(this.getBooleanValue(supportFlags[0]));
        column.setUpdatable(this.getBooleanValue(supportFlags[1]));
        column.setAutoIncremented(this.getBooleanValue(supportFlags[2]));
        column.setCaseSensitive(this.getBooleanValue(supportFlags[3]));
        column.setSigned(this.getBooleanValue(supportFlags[4]));
        column.setCurrency(this.getBooleanValue(supportFlags[5]));
        column.setFixedLength(this.getBooleanValue(supportFlags[6]));
        column.setNullType(BaseColumn.NullType.values()[Integer.parseInt((String)tokens.get(tokenIndex++))]);
        column.setSearchType(Column.SearchType.values()[3 - Integer.parseInt((String)tokens.get(tokenIndex++))]);
        column.setLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setScale(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setPrecision(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setPosition(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setCharOctetLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setRadix(Integer.parseInt((String)tokens.get(tokenIndex++)));
        if (this.includeColumnNullDistinctValues(indexVersion)) {
            column.setDistinctValues(Integer.parseInt((String)tokens.get(tokenIndex++)));
            column.setNullValues(Integer.parseInt((String)tokens.get(tokenIndex++)));
        }
        column.setMinimumValue(this.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setMaximumValue(this.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setFormat(this.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setRuntimeType(this.getObjectValue((String)tokens.get(tokenIndex++)));
        if (this.includeColumnNativeType(indexVersion)) {
            column.setNativeType(this.getObjectValue((String)tokens.get(tokenIndex++)));
        }
        column.setDatatypeUUID(this.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setDefaultValue(this.getObjectValue((String)tokens.get(tokenIndex++)));
        this.setRecordFooterValues((AbstractMetadataRecord)column, tokens, tokenIndex);
        return column;
    }

    public ColumnSet createColumnSetRecord(char[] record, ColumnSet columnSet) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)columnSet, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        List<String> uuids = this.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        columnSet.setColumns(RecordFactory.createColumns(uuids));
        if (record[0] == 'I' || record[0] == 'K') {
            this.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        }
        this.setRecordFooterValues((AbstractMetadataRecord)columnSet, tokens, tokenIndex);
        return columnSet;
    }

    public ForeignKey createForeignKeyRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ForeignKey fkRecord = new ForeignKey();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)fkRecord, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        List<String> uuids = this.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        fkRecord.setColumns(RecordFactory.createColumns(uuids));
        fkRecord.setUniqueKeyID(this.getObjectValue((String)tokens.get(tokenIndex++)));
        this.setRecordFooterValues((AbstractMetadataRecord)fkRecord, tokens, tokenIndex);
        return fkRecord;
    }

    public Datatype createDatatypeRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        Datatype dt = new Datatype();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        int n = ++tokenIndex;
        dt.setDatatypeID(this.getObjectValue((String)tokens.get(n)));
        int n2 = ++tokenIndex;
        dt.setBasetypeID(this.getObjectValue((String)tokens.get(n2)));
        int n3 = ++tokenIndex;
        ++tokenIndex;
        String fullName = (String)tokens.get(n3);
        int indx = fullName.lastIndexOf("#");
        if (indx > -1) {
            fullName = fullName.substring(indx + 1);
        } else {
            indx = fullName.lastIndexOf(46);
            if (indx > -1) {
                fullName = fullName.substring(indx + 1);
            }
        }
        dt.setName(fullName);
        dt.setUUID(this.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setNameInSource(this.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setVarietyType(Datatype.Variety.values()[Short.parseShort((String)tokens.get(tokenIndex++))]);
        this.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        dt.setRuntimeTypeName(this.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setJavaClassName(this.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setType(Datatype.Type.values()[Short.parseShort((String)tokens.get(tokenIndex++))]);
        dt.setSearchType(Column.SearchType.values()[3 - Integer.parseInt((String)tokens.get(tokenIndex++))]);
        dt.setNullType(BaseColumn.NullType.values()[Integer.parseInt((String)tokens.get(tokenIndex++))]);
        char[] booleanValues = ((String)tokens.get(tokenIndex++)).toCharArray();
        dt.setSigned(this.getBooleanValue(booleanValues[0]));
        dt.setAutoIncrement(this.getBooleanValue(booleanValues[1]));
        dt.setCaseSensitive(this.getBooleanValue(booleanValues[2]));
        dt.setLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        dt.setPrecisionLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        dt.setScale(Integer.parseInt((String)tokens.get(tokenIndex++)));
        dt.setRadix(Integer.parseInt((String)tokens.get(tokenIndex++)));
        if (this.includePrimitiveTypeIdValue(indexVersion)) {
            dt.setPrimitiveTypeID(this.getObjectValue((String)tokens.get(tokenIndex++)));
        }
        this.setRecordFooterValues((AbstractMetadataRecord)dt, tokens, tokenIndex);
        return dt;
    }

    public Procedure createProcedureRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        Procedure procRd = new Procedure();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)procRd, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        char[] booleanValues = ((String)tokens.get(tokenIndex++)).toCharArray();
        procRd.setFunction(this.getBooleanValue(booleanValues[0]));
        procRd.setVirtual(this.getBooleanValue(booleanValues[1]));
        List<String> uuids = this.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        ArrayList<ProcedureParameter> columns = new ArrayList<ProcedureParameter>(uuids.size());
        for (String uuid : uuids) {
            ProcedureParameter column = new ProcedureParameter();
            column.setUUID(uuid);
            columns.add(column);
        }
        procRd.setParameters(columns);
        String rsId = this.getObjectValue((String)tokens.get(tokenIndex++));
        if (rsId != null) {
            ColumnSet cs = new ColumnSet();
            cs.setUUID(rsId);
            procRd.setResultSet(cs);
        }
        if (RecordFactory.includeProcedureUpdateCount(indexVersion)) {
            procRd.setUpdateCount(Integer.parseInt((String)tokens.get(tokenIndex++)));
        }
        this.setRecordFooterValues((AbstractMetadataRecord)procRd, tokens, tokenIndex);
        return procRd;
    }

    public ProcedureParameter createProcedureParameterRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ProcedureParameter paramRd = new ProcedureParameter();
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)paramRd, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        paramRd.setDefaultValue(this.getObjectValue((String)tokens.get(tokenIndex++)));
        paramRd.setRuntimeType(this.getObjectValue((String)tokens.get(tokenIndex++)));
        paramRd.setDatatypeUUID(this.getObjectValue((String)tokens.get(tokenIndex++)));
        paramRd.setLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setRadix(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setScale(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setNullType(BaseColumn.NullType.values()[Integer.parseInt((String)tokens.get(tokenIndex++))]);
        paramRd.setPrecision(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setPosition(Integer.parseInt((String)tokens.get(tokenIndex++)));
        ProcedureParameter.Type type = null;
        switch (Short.parseShort((String)tokens.get(tokenIndex++))) {
            case 0: {
                type = ProcedureParameter.Type.In;
                break;
            }
            case 2: {
                type = ProcedureParameter.Type.InOut;
                break;
            }
            case 1: {
                type = ProcedureParameter.Type.Out;
                break;
            }
            case 3: {
                type = ProcedureParameter.Type.ReturnValue;
            }
        }
        paramRd.setType(type);
        char[] flags = ((String)tokens.get(tokenIndex++)).toCharArray();
        paramRd.setOptional(this.getBooleanValue(flags[0]));
        this.setRecordFooterValues((AbstractMetadataRecord)paramRd, tokens, tokenIndex);
        return paramRd;
    }

    int getIndexVersion(char[] record) {
        if (this.version == 0) {
            int beginIndex;
            int endIndex;
            for (int i = beginIndex = (endIndex = record.length) - 6 > 0 ? endIndex - 6 : 1; i < endIndex; ++i) {
                if (record[i] != '\u00a1') continue;
                char versionPart1 = record[i + 1];
                char versionPart2 = record[i + 2];
                if (!Character.isDigit(versionPart1) || !Character.isDigit(versionPart2)) continue;
                this.version = Character.digit(versionPart1, 10) * 10 + Character.digit(versionPart2, 10);
            }
        }
        return this.version;
    }

    public String getObjectValue(String str) {
        if (str != null && str.length() == 1 && str.charAt(0) == ' ') {
            return null;
        }
        return str;
    }

    public boolean getBooleanValue(char b) {
        return b == '1';
    }

    public List<String> getIDs(String values, int indexVersionNumber) {
        if (StringUtil.isEmpty((String)values)) {
            return Collections.EMPTY_LIST;
        }
        if (values.length() == 1 && values.charAt(0) == ' ') {
            return Collections.EMPTY_LIST;
        }
        char listDelimiter = this.getListDelimiter(indexVersionNumber);
        List tokens = StringUtil.split((String)values, (String)String.valueOf(listDelimiter));
        ArrayList<String> result = new ArrayList<String>(tokens.size());
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = this.getObjectValue((String)iter.next());
            if (token == null) continue;
            result.add(token);
        }
        return result;
    }

    public List<String> getStrings(String values, int indexVersionNumber) {
        if (StringUtil.isEmpty((String)values)) {
            return Collections.emptyList();
        }
        if (values.length() == 1 && values.charAt(0) == ' ') {
            return Collections.emptyList();
        }
        char listDelimiter = this.getListDelimiter(indexVersionNumber);
        List tokens = StringUtil.split((String)values, (String)String.valueOf(listDelimiter));
        ArrayList<String> result = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            if (token == null) continue;
            result.add(token);
        }
        return result;
    }

    public char getListDelimiter(int indexVersionNumber) {
        if (indexVersionNumber < 1) {
            return ',';
        }
        return '\u001f';
    }

    public boolean includeMaterializationFlag(int indexVersionNumber) {
        return indexVersionNumber >= 2;
    }

    public boolean includeMaterializedTables(int indexVersionNumber) {
        return indexVersionNumber >= 2;
    }

    public boolean includeColumnNativeType(int indexVersionNumber) {
        return indexVersionNumber >= 3;
    }

    public boolean includeColumnNullDistinctValues(int indexVersionNumber) {
        return indexVersionNumber >= 7;
    }

    public boolean includePrimitiveTypeIdValue(int indexVersionNumber) {
        return indexVersionNumber >= 8;
    }

    public boolean includeInputParameterFlag(int indexVersionNumber) {
        return indexVersionNumber >= 4;
    }

    public boolean includeAnnotationProperties(int indexVersionNumber) {
        return indexVersionNumber < 5;
    }

    public boolean includeTransformationUUID(int indexVersionNumber) {
        return indexVersionNumber >= 6;
    }

    private static boolean includeProcedureUpdateCount(int indexVersionNumber) {
        return indexVersionNumber >= 9;
    }

    private void setRecordHeaderValues(AbstractMetadataRecord record, String recordType, String upperName, String objectID, String fullName, String nameInSource, String parentObjectID) {
        record.setUUID(this.getObjectValue(objectID));
        if (fullName != null) {
            String name = fullName;
            if (record instanceof ProcedureParameter || record instanceof KeyRecord) {
                name = RecordFactory.getShortName(fullName);
            } else {
                int index = fullName.indexOf(46);
                if (index > 0) {
                    name = fullName.substring(index + 1);
                }
            }
            record.setName(name);
        }
        record.setNameInSource(this.getObjectValue(nameInSource));
    }

    static String getShortName(String fullName) {
        int index = fullName.lastIndexOf(46);
        if (index > 0) {
            fullName = fullName.substring(index + 1);
        }
        return fullName;
    }

    private void setRecordFooterValues(AbstractMetadataRecord record, List tokens, int tokenIndex) {
        if (record instanceof TransformationRecordImpl) {
            ((TransformationRecordImpl)record).setResourcePath(this.getOptionalToken(tokens, tokenIndex));
        }
        ++tokenIndex;
        if (record.getName() == null) {
            record.setName(this.getOptionalToken(tokens, tokenIndex++));
        }
        this.getOptionalToken(tokens, tokenIndex++);
    }

    public String getOptionalToken(List tokens, int tokenIndex) {
        if (tokens.size() > tokenIndex) {
            return (String)tokens.get(tokenIndex);
        }
        return null;
    }
}

