/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.query.metadata.TransformationMetadata;

public class TestMultipleModelIndexes {
    @Test
    public void testMultiple() throws Exception {
        TransformationMetadata tm = VDBMetadataFactory.getVDBMetadata(UnitTestUtil.getTestDataPath() + "/ZZZ.vdb");
        Collection names = tm.getGroupsForPartialName("PRODUCTDATA");
        Assert.assertEquals((long)1L, (long)names.size());
        names = tm.getGroupsForPartialName("PARTS");
        Assert.assertEquals((long)1L, (long)names.size());
        Table t = tm.getGroupID((String)names.iterator().next());
        Assert.assertNotNull((Object)((Column)t.getColumns().get(0)).getDatatype());
    }

    @Test
    public void testSchemaLoad() throws Exception {
        TransformationMetadata tm = VDBMetadataFactory.getVDBMetadata(UnitTestUtil.getTestDataPath() + "/Test.vdb");
        Table t = tm.getGroupID("Northwind.Northwind.dbo.Employees");
        Assert.assertFalse((boolean)t.isVirtual());
    }

    @Test
    public void test71Schema() throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(UnitTestUtil.getTestDataFile((String)"schema.ser")));
        Schema schema = (Schema)ois.readObject();
        Assert.assertNotNull((Object)schema.getFunctions());
    }
}

