/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.virtual.VirtualFile;
import org.teiid.core.index.IDocument;
import org.teiid.internal.core.index.BlocksIndexOutput;
import org.teiid.internal.core.index.IndexOutput;
import org.teiid.internal.core.index.IndexedFile;
import org.teiid.internal.core.index.IndexedFileHashedArray;
import org.teiid.internal.core.index.WordEntry;

public class InMemoryIndex {
    protected List<WordEntry> words;
    protected IndexedFileHashedArray files;
    protected long footprint;
    private WordEntry[] sortedWordEntries;
    private IndexedFile[] sortedFiles;

    public InMemoryIndex() {
        this.init();
    }

    public IndexedFile addDocument(IDocument document) {
        IndexedFile indexedFile = this.files.add(document);
        this.footprint += (long)(indexedFile.footprint() + 4);
        this.sortedFiles = null;
        return indexedFile;
    }

    protected void addRef(char[] word, int fileNum) {
        WordEntry entry = new WordEntry(word);
        entry.addRef(fileNum);
        this.words.add(entry);
        this.sortedWordEntries = null;
        this.footprint += (long)entry.footprint();
    }

    public void addRef(IndexedFile indexedFile, char[] word) {
        this.addRef(word, indexedFile.getFileNumber());
    }

    public long getFootprint() {
        return this.footprint;
    }

    public IndexedFile getIndexedFile(String path) {
        return this.files.get(path);
    }

    public int getNumFiles() {
        return this.files.size();
    }

    public int getNumWords() {
        return this.words.size();
    }

    protected IndexedFile[] getSortedFiles() {
        if (this.sortedFiles == null) {
            Object[] indexedFiles = this.files.asArray();
            Arrays.sort(indexedFiles);
            this.sortedFiles = indexedFiles;
        }
        return this.sortedFiles;
    }

    protected WordEntry[] getSortedWordEntries() {
        if (this.sortedWordEntries == null) {
            Object[] words = this.words.toArray(new WordEntry[this.words.size()]);
            Arrays.sort(words);
            this.sortedWordEntries = words;
        }
        return this.sortedWordEntries;
    }

    public void init() {
        this.words = new ArrayList<WordEntry>(256);
        this.files = new IndexedFileHashedArray(101);
        this.footprint = 0L;
        this.sortedWordEntries = null;
        this.sortedFiles = null;
    }

    public void save(VirtualFile file) throws IOException {
        BlocksIndexOutput output = new BlocksIndexOutput(file);
        this.save(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(IndexOutput output) throws IOException {
        boolean ok = false;
        try {
            int i;
            output.open();
            IndexedFile[] indexedFiles = this.files.asArray();
            int length = indexedFiles.length;
            for (i = 0; i < length; ++i) {
                output.addFile(indexedFiles[i]);
            }
            this.getSortedWordEntries();
            int numWords = this.sortedWordEntries.length;
            for (i = 0; i < numWords; ++i) {
                output.addWord(this.sortedWordEntries[i]);
            }
            output.flush();
            output.close();
            ok = true;
        }
        finally {
            if (!ok && output != null) {
                output.close();
            }
        }
    }
}

