/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.plugins.context.zip.ZipEntryContext;
import org.jboss.virtual.spi.VirtualFileHandler;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.index.IEntryResult;
import org.teiid.core.util.StringUtil;
import org.teiid.internal.core.index.Index;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.index.RecordFactory;
import org.teiid.metadata.index.SimpleIndexUtil;
import org.teiid.metadata.index.TransformationRecordImpl;
import org.teiid.query.metadata.TransformationMetadata;

public class IndexMetadataFactory {
    private Index[] indexes;
    private RecordFactory recordFactory = new RecordFactory(){

        @Override
        protected AbstractMetadataRecord getMetadataRecord(char[] record) {
            if (record == null || record.length == 0) {
                return null;
            }
            char c = record[0];
            switch (c) {
                case 'W': {
                    List<String> tokens = RecordFactory.getStrings(record, '\u00a0');
                    int indexVersion = IndexMetadataFactory.this.recordFactory.getIndexVersion(record);
                    String uuid = tokens.get(2);
                    int tokenIndex = 6;
                    if (IndexMetadataFactory.this.recordFactory.includeAnnotationProperties(indexVersion)) {
                        // empty if block
                    }
                    int n = ++tokenIndex;
                    ++tokenIndex;
                    IndexMetadataFactory.this.annotationCache.put(uuid, tokens.get(n));
                    return null;
                }
                case 'X': {
                    List<String> tokens = RecordFactory.getStrings(record, '\u00a0');
                    String uuid = tokens.get(1);
                    LinkedHashMap<String, String> result = (LinkedHashMap<String, String>)IndexMetadataFactory.this.extensionCache.get(uuid);
                    if (result == null) {
                        result = new LinkedHashMap<String, String>();
                        IndexMetadataFactory.this.extensionCache.put(uuid, result);
                    }
                    int tokenIndex = 2;
                    result.put(tokens.get(tokenIndex++), tokens.get(tokenIndex++));
                    return null;
                }
            }
            AbstractMetadataRecord abstractMetadataRecord = super.getMetadataRecord(record);
            if (abstractMetadataRecord == null) {
                return null;
            }
            String parentName = null;
            if (record[0] == 'B') {
                parentName = ((Schema)((Table)abstractMetadataRecord).getParent()).getName();
            } else if (record[0] == 'E') {
                parentName = ((Procedure)abstractMetadataRecord).getParent().getName();
            }
            if (parentName != null) {
                ArrayList<AbstractMetadataRecord> typeRecords;
                HashMap<Character, ArrayList<AbstractMetadataRecord>> map = (HashMap<Character, ArrayList<AbstractMetadataRecord>>)IndexMetadataFactory.this.schemaEntries.get(parentName);
                if (map == null) {
                    map = new HashMap<Character, ArrayList<AbstractMetadataRecord>>();
                    IndexMetadataFactory.this.schemaEntries.put(parentName, map);
                }
                if ((typeRecords = (ArrayList<AbstractMetadataRecord>)map.get(Character.valueOf(record[0]))) == null) {
                    typeRecords = new ArrayList<AbstractMetadataRecord>();
                    map.put(Character.valueOf(record[0]), typeRecords);
                }
                typeRecords.add(abstractMetadataRecord);
            }
            Map<String, AbstractMetadataRecord> uuidMap = IndexMetadataFactory.this.getByType(record[0]);
            uuidMap.put(abstractMetadataRecord.getUUID(), abstractMetadataRecord);
            if (this.parentId != null) {
                List<AbstractMetadataRecord> typeChildren = IndexMetadataFactory.this.getByParent(this.parentId, record[0], AbstractMetadataRecord.class, true);
                typeChildren.add(abstractMetadataRecord);
            }
            return abstractMetadataRecord;
        }
    };
    private Map<String, String> annotationCache = new HashMap<String, String>();
    private Map<String, LinkedHashMap<String, String>> extensionCache = new HashMap<String, LinkedHashMap<String, String>>();
    private Map<String, Map<Character, List<AbstractMetadataRecord>>> schemaEntries = new HashMap<String, Map<Character, List<AbstractMetadataRecord>>>();
    private Map<String, Map<Character, List<AbstractMetadataRecord>>> childRecords = new HashMap<String, Map<Character, List<AbstractMetadataRecord>>>();
    private Map<Character, LinkedHashMap<String, AbstractMetadataRecord>> allRecords = new HashMap<Character, LinkedHashMap<String, AbstractMetadataRecord>>();
    private MetadataStore store;
    private HashSet<VirtualFile> indexFiles = new HashSet();
    private LinkedHashMap<String, TransformationMetadata.Resource> vdbEntries;

    public IndexMetadataFactory() {
    }

    public IndexMetadataFactory(URL url) throws IOException, URISyntaxException {
        VFS.init();
        ZipEntryContext context = new ZipEntryContext(url);
        VirtualFileHandler vfh = context.getRoot();
        VirtualFile vdb = new VirtualFile(vfh);
        List children = vdb.getChildrenRecursively(new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return file.getName().endsWith(".INDEX");
            }
        });
        for (VirtualFile f : children) {
            this.addIndexFile(f);
        }
        this.addEntriesPlusVisibilities(vdb, new VDBMetaData());
    }

    Map<String, AbstractMetadataRecord> getByType(char type) {
        LinkedHashMap<String, Object> uuidMap = this.allRecords.get(Character.valueOf(type));
        if (uuidMap == null) {
            uuidMap = new LinkedHashMap();
            this.allRecords.put(Character.valueOf(type), uuidMap);
        }
        return uuidMap;
    }

    <T extends AbstractMetadataRecord> List<T> getByParent(String parentId, char type, Class<T> clazz, boolean create) {
        List<AbstractMetadataRecord> typeChildren;
        Map<Character, List<AbstractMetadataRecord>> children = this.childRecords.get(parentId);
        if (children == null) {
            children = new HashMap<Character, List<AbstractMetadataRecord>>();
            this.childRecords.put(parentId, children);
        }
        if ((typeChildren = children.get(Character.valueOf(type))) == null) {
            if (!create) {
                return Collections.emptyList();
            }
            typeChildren = new ArrayList<AbstractMetadataRecord>(2);
            children.put(Character.valueOf(type), typeChildren);
        }
        return typeChildren;
    }

    private void loadAll() {
        for (Index index : this.indexes) {
            try {
                IEntryResult[] results = SimpleIndexUtil.queryIndex(new Index[]{index}, new char[0], true, true, false);
                this.recordFactory.getMetadataRecord(results);
            }
            catch (TeiidException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
        for (LinkedHashMap<String, AbstractMetadataRecord> map : this.allRecords.values()) {
            for (AbstractMetadataRecord metadataRecord : map.values()) {
                String uuid = metadataRecord.getUUID();
                metadataRecord.setAnnotation(this.annotationCache.get(uuid));
                metadataRecord.setProperties(this.extensionCache.get(uuid));
            }
        }
    }

    public MetadataStore getMetadataStore(Collection<Datatype> systemDatatypes) throws IOException {
        if (this.store == null) {
            this.store = new MetadataStore();
            ArrayList<Index> tmp = new ArrayList<Index>();
            for (VirtualFile f : this.indexFiles) {
                Index index = new Index(f, true);
                index.setDoCache(true);
                tmp.add(index);
            }
            this.indexes = tmp.toArray(new Index[tmp.size()]);
            this.loadAll();
            for (Index index : tmp) {
                index.close();
            }
            Map<String, AbstractMetadataRecord> uuidToRecord = this.getByType('M');
            for (AbstractMetadataRecord datatypeRecordImpl : uuidToRecord.values()) {
                this.store.addDatatype((Datatype)datatypeRecordImpl);
            }
            if (systemDatatypes != null) {
                for (Datatype datatype : systemDatatypes) {
                    uuidToRecord.put(datatype.getUUID(), (AbstractMetadataRecord)datatype);
                }
            }
            this.getModels();
            this.getTables();
            this.getProcedures();
        }
        return this.store;
    }

    public void addIndexFile(VirtualFile f) {
        this.indexFiles.add(f);
    }

    public void addEntriesPlusVisibilities(VirtualFile root, VDBMetaData vdb) throws IOException {
        LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap = new LinkedHashMap<String, TransformationMetadata.Resource>();
        for (VirtualFile f : root.getChildrenRecursively()) {
            if (!f.isLeaf()) continue;
            String path = f.getPathName().substring(root.getPathName().length());
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            visibilityMap.put(path, new TransformationMetadata.Resource(f, this.isFileVisible(f.getPathName(), vdb)));
        }
        this.vdbEntries = visibilityMap;
    }

    private boolean isFileVisible(String pathInVDB, VDBMetaData vdb) {
        String modelName;
        ModelMetaData model;
        if (pathInVDB.endsWith(".xmi") && (model = vdb.getModel(modelName = StringUtil.getFirstToken((String)StringUtil.getLastToken((String)pathInVDB, (String)"/"), (String)"."))) != null) {
            return model.isVisible();
        }
        if (pathInVDB.startsWith("META-INF/")) {
            return false;
        }
        String entry = StringUtil.getLastToken((String)pathInVDB, (String)"/");
        if (entry.endsWith(".INDEX") || entry.endsWith(".SEARCH_INDEX")) {
            return false;
        }
        return !entry.equalsIgnoreCase("vdb.xml");
    }

    public LinkedHashMap<String, TransformationMetadata.Resource> getEntriesPlusVisibilities() {
        return this.vdbEntries;
    }

    public void getModels() {
        Collection<AbstractMetadataRecord> records = this.getByType('A').values();
        for (AbstractMetadataRecord modelRecord : records) {
            this.store.addSchema((Schema)modelRecord);
        }
    }

    public void getTables() {
        for (Schema model : this.store.getSchemas().values()) {
            List<AbstractMetadataRecord> recs;
            Map<Character, List<AbstractMetadataRecord>> entries = this.schemaEntries.get(model.getName());
            if (entries == null || (recs = entries.get(Character.valueOf('B'))) == null) continue;
            List<AbstractMetadataRecord> records = recs;
            Collections.sort(records, new Comparator<Table>(){

                @Override
                public int compare(Table o1, Table o2) {
                    if (!o1.isMaterialized()) {
                        return -1;
                    }
                    if (!o2.isMaterialized()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (Table table : records) {
                ArrayList<Column> columns = new ArrayList<Column>(this.getByParent(table.getUUID(), 'G', Column.class, false));
                for (Column columnRecordImpl : columns) {
                    columnRecordImpl.setDatatype((Datatype)this.getByType('M').get(columnRecordImpl.getDatatypeUUID()));
                    columnRecordImpl.setParent((ColumnSet)table);
                    String fullName = columnRecordImpl.getName();
                    if (!fullName.startsWith(table.getName() + '.')) continue;
                    columnRecordImpl.setName(new String(fullName.substring(table.getName().length() + 1)));
                }
                Collections.sort(columns);
                table.setColumns(columns);
                table.setAccessPatterns(this.getByParent(table.getUUID(), 'H', KeyRecord.class, false));
                HashMap<String, Column> uuidColumnMap = new HashMap<String, Column>();
                for (Column columnRecordImpl : columns) {
                    uuidColumnMap.put(columnRecordImpl.getUUID(), columnRecordImpl);
                }
                for (KeyRecord columnSetRecordImpl : table.getAccessPatterns()) {
                    this.loadColumnSetRecords((ColumnSet<?>)columnSetRecordImpl, (Map<String, Column>)uuidColumnMap);
                    columnSetRecordImpl.setParent((AbstractMetadataRecord)table);
                }
                table.setForiegnKeys(this.getByParent(table.getUUID(), 'J', ForeignKey.class, false));
                for (ForeignKey foreignKeyRecord : table.getForeignKeys()) {
                    KeyRecord pk = (KeyRecord)this.getRecordByType(foreignKeyRecord.getUniqueKeyID(), 'K', false);
                    if (pk == null) {
                        pk = (KeyRecord)this.getRecordByType(foreignKeyRecord.getUniqueKeyID(), 'I');
                    }
                    foreignKeyRecord.setPrimaryKey(pk);
                    this.loadColumnSetRecords((ColumnSet<?>)foreignKeyRecord, (Map<String, Column>)uuidColumnMap);
                    foreignKeyRecord.setParent((AbstractMetadataRecord)table);
                }
                table.setUniqueKeys(this.getByParent(table.getUUID(), 'I', KeyRecord.class, false));
                for (KeyRecord columnSetRecordImpl : table.getUniqueKeys()) {
                    this.loadColumnSetRecords((ColumnSet<?>)columnSetRecordImpl, (Map<String, Column>)uuidColumnMap);
                    columnSetRecordImpl.setParent((AbstractMetadataRecord)table);
                }
                table.setIndexes(this.getByParent(table.getUUID(), 'L', KeyRecord.class, false));
                for (KeyRecord columnSetRecordImpl : table.getIndexes()) {
                    this.loadColumnSetRecords((ColumnSet<?>)columnSetRecordImpl, (Map<String, Column>)uuidColumnMap);
                    columnSetRecordImpl.setParent((AbstractMetadataRecord)table);
                }
                if (table.getPrimaryKey() != null) {
                    KeyRecord primaryKey = (KeyRecord)this.getRecordByType(table.getPrimaryKey().getUUID(), 'K');
                    this.loadColumnSetRecords((ColumnSet<?>)primaryKey, (Map<String, Column>)uuidColumnMap);
                    primaryKey.setParent((AbstractMetadataRecord)table);
                    table.setPrimaryKey(primaryKey);
                }
                String groupUUID = table.getUUID();
                if (table.isVirtual()) {
                    TransformationRecordImpl select;
                    TransformationRecordImpl delete;
                    TransformationRecordImpl insert;
                    TransformationRecordImpl update = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'R', false);
                    if (update != null) {
                        table.setUpdatePlan(update.getTransformation());
                    }
                    if ((insert = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'Q', false)) != null) {
                        table.setInsertPlan(insert.getTransformation());
                    }
                    if ((delete = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'S', false)) != null) {
                        table.setDeletePlan(delete.getTransformation());
                    }
                    if ((select = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'P', false)) == null) {
                        select = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'U', false);
                    }
                    if (select != null) {
                        table.setSelectTransformation(select.getTransformation());
                        table.setBindings(select.getBindings());
                        table.setSchemaPaths(select.getSchemaPaths());
                        table.setResourcePath(select.getResourcePath());
                    }
                }
                if (table.isMaterialized()) {
                    table.setMaterializedStageTable((Table)this.getByType('B').get(table.getMaterializedStageTable().getUUID()));
                    table.setMaterializedTable((Table)this.getByType('B').get(table.getMaterializedTable().getUUID()));
                }
                model.addTable(table);
            }
        }
    }

    private KeyRecord getPrimaryKey(String uuid) {
        KeyRecord key = (KeyRecord)this.getByType('K').get(uuid);
        if (key == null) {
            throw new TeiidRuntimeException(uuid + " PrimaryKey " + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        return key;
    }

    private Column findElement(String fullName) {
        Column columnRecord = (Column)this.getRecordByType(fullName, 'G');
        columnRecord.setDatatype((Datatype)this.getByType('M').get(columnRecord.getDatatypeUUID()));
        return columnRecord;
    }

    private AbstractMetadataRecord getRecordByType(String entityName, char recordType) {
        return this.getRecordByType(entityName, recordType, true);
    }

    private AbstractMetadataRecord getRecordByType(String entityName, char recordType, boolean mustExist) {
        AbstractMetadataRecord record = this.getByType(recordType).get(entityName);
        if (record == null) {
            if (mustExist) {
                throw new TeiidRuntimeException(entityName + TransformationMetadata.NOT_EXISTS_MESSAGE);
            }
            return null;
        }
        return record;
    }

    public void getProcedures() {
        for (Schema model : this.store.getSchemas().values()) {
            List<AbstractMetadataRecord> recs;
            Map<Character, List<AbstractMetadataRecord>> entries = this.schemaEntries.get(model.getName());
            if (entries == null || (recs = entries.get(Character.valueOf('E'))) == null) continue;
            List<AbstractMetadataRecord> records = recs;
            for (Procedure procedure : records) {
                ColumnSet resultRecord;
                for (int i = 0; i < procedure.getParameters().size(); ++i) {
                    ProcedureParameter paramRecord = (ProcedureParameter)this.getRecordByType(((ProcedureParameter)procedure.getParameters().get(i)).getUUID(), 'F');
                    paramRecord.setDatatype((Datatype)this.getByType('M').get(paramRecord.getDatatypeUUID()));
                    procedure.getParameters().set(i, paramRecord);
                    paramRecord.setProcedure(procedure);
                }
                ColumnSet result = procedure.getResultSet();
                if (result != null && (resultRecord = (ColumnSet)this.getRecordByType(result.getUUID(), 'C', false)) != null) {
                    resultRecord.setParent((AbstractMetadataRecord)procedure);
                    resultRecord.setName(RecordFactory.getShortName(resultRecord.getName()));
                    this.loadColumnSetRecords(resultRecord, null);
                    procedure.setResultSet(resultRecord);
                }
                if (procedure.isVirtual()) {
                    TransformationRecordImpl transformRecord = (TransformationRecordImpl)this.getRecordByType(procedure.getUUID(), 'T', false);
                    if (transformRecord != null) {
                        procedure.setQueryPlan(transformRecord.getTransformation());
                    }
                } else if (procedure.isFunction()) {
                    boolean deterministic = Boolean.valueOf(procedure.getProperty("{http://www.teiid.org/ext/relational/2012}deterministic", true));
                    boolean nullOnNull = Boolean.valueOf(procedure.getProperty("{http://www.teiid.org/ext/relational/2012}null-on-null", false));
                    boolean varargs = Boolean.valueOf(procedure.getProperty("{http://www.teiid.org/ext/relational/2012}varargs", false));
                    FunctionParameter outputParam = null;
                    ArrayList<FunctionParameter> args = new ArrayList<FunctionParameter>(procedure.getParameters().size() - 1);
                    boolean valid = true;
                    block7: for (ProcedureParameter param : procedure.getParameters()) {
                        FunctionParameter fp = new FunctionParameter();
                        fp.setName(param.getName());
                        fp.setDescription(param.getAnnotation());
                        fp.setType(param.getRuntimeType());
                        switch (param.getType()) {
                            case ReturnValue: {
                                if (outputParam != null) {
                                    valid = false;
                                }
                                outputParam = fp;
                                continue block7;
                            }
                            case In: {
                                args.add(fp);
                                continue block7;
                            }
                        }
                        valid = false;
                    }
                    if (valid && outputParam != null) {
                        FunctionMethod function = new FunctionMethod(procedure.getName(), procedure.getAnnotation(), model.getName(), FunctionMethod.PushDown.MUST_PUSHDOWN, null, null, args.toArray(new FunctionParameter[args.size()]), outputParam, false, deterministic ? FunctionMethod.Determinism.DETERMINISTIC : FunctionMethod.Determinism.NONDETERMINISTIC);
                        function.setNullOnNull(nullOnNull);
                        if (varargs && !function.getInputParameters().isEmpty()) {
                            ((FunctionParameter)function.getInputParameters().get(args.size() - 1)).setVarArg(varargs);
                        }
                        model.addFunction(function);
                        continue;
                    }
                }
                model.addProcedure(procedure);
            }
        }
    }

    private void loadColumnSetRecords(ColumnSet<?> indexRecord, Map<String, Column> columns) {
        for (int i = 0; i < indexRecord.getColumns().size(); ++i) {
            String uuid = ((Column)indexRecord.getColumns().get(i)).getUUID();
            Column c = null;
            if (columns != null) {
                c = columns.get(uuid);
            } else {
                c = this.findElement(uuid);
                c.setName(RecordFactory.getShortName(c.getName()));
            }
            indexRecord.getColumns().set(i, c);
            if (columns != null) continue;
            c.setParent(indexRecord);
        }
    }
}

