/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.index;

import java.io.IOException;
import java.util.ArrayList;
import org.teiid.core.index.IDocument;
import org.teiid.core.index.IEntryResult;
import org.teiid.core.index.IQueryResult;
import org.teiid.internal.core.index.InMemoryIndex;
import org.teiid.internal.core.index.IndexInput;
import org.teiid.internal.core.index.IndexedFile;
import org.teiid.internal.core.index.WordEntry;

public class SimpleIndexInput
extends IndexInput {
    protected WordEntry[] sortedWordEntries;
    protected IndexedFile currentFile;
    protected IndexedFile[] sortedFiles;
    protected InMemoryIndex index;

    public SimpleIndexInput(InMemoryIndex index) {
        this.index = index;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void close() throws IOException {
        this.sortedFiles = null;
    }

    @Override
    public IndexedFile getCurrentFile() throws IOException {
        if (!this.hasMoreFiles()) {
            return null;
        }
        return this.currentFile;
    }

    @Override
    public IndexedFile getIndexedFile(int fileNum) throws IOException {
        for (int i = 0; i < this.sortedFiles.length; ++i) {
            if (this.sortedFiles[i].getFileNumber() != fileNum) continue;
            return this.sortedFiles[i];
        }
        return null;
    }

    @Override
    public IndexedFile getIndexedFile(IDocument document) throws IOException {
        String name = document.getName();
        for (int i = this.index.getNumFiles(); i >= 1; --i) {
            IndexedFile file = this.getIndexedFile(i);
            if (!name.equals(file.getPath())) continue;
            return file;
        }
        return null;
    }

    @Override
    public int getNumFiles() {
        return this.index.getNumFiles();
    }

    @Override
    public int getNumWords() {
        return this.sortedWordEntries.length;
    }

    @Override
    public Object getSource() {
        return this.index;
    }

    public void init() {
        this.index.init();
    }

    @Override
    public void moveToNextFile() throws IOException {
        ++this.filePosition;
        if (!this.hasMoreFiles()) {
            return;
        }
        this.currentFile = this.sortedFiles[this.filePosition - 1];
    }

    @Override
    public void moveToNextWordEntry() throws IOException {
        ++this.wordPosition;
        if (this.hasMoreWords()) {
            this.currentWordEntry = this.sortedWordEntries[this.wordPosition - 1];
        }
    }

    @Override
    public void open() throws IOException {
        this.sortedWordEntries = this.index.getSortedWordEntries();
        this.sortedFiles = this.index.getSortedFiles();
        this.filePosition = 1;
        this.wordPosition = 1;
        this.setFirstFile();
        this.setFirstWord();
    }

    @Override
    public IEntryResult[] queryEntriesPrefixedBy(char[] prefix) throws IOException {
        return null;
    }

    @Override
    public IQueryResult[] queryFilesReferringToPrefix(char[] prefix) throws IOException {
        return null;
    }

    @Override
    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        this.setFirstFile();
        ArrayList<String> matches = new ArrayList<String>();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            if (file.getPath().indexOf(word) != -1) {
                matches.add(file.getPath());
            }
            this.moveToNextFile();
        }
        IQueryResult[] match = new IQueryResult[matches.size()];
        matches.toArray(match);
        return match;
    }

    @Override
    protected void setFirstFile() throws IOException {
        this.filePosition = 1;
        if (this.sortedFiles.length > 0) {
            this.currentFile = this.sortedFiles[0];
        }
    }

    @Override
    protected void setFirstWord() throws IOException {
        this.wordPosition = 1;
        if (this.sortedWordEntries.length > 0) {
            this.currentWordEntry = this.sortedWordEntries[0];
        }
    }
}

